/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.integration.residence;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.integration.IntegrateStage;
import org.maxgamer.quickshop.integration.IntegrationStage;
import org.maxgamer.quickshop.integration.QSIntegratedPlugin;

@IntegrationStage(loadStage=IntegrateStage.onEnableAfter)
public class ResidenceIntegration
extends QSIntegratedPlugin {
    private static final String createFlag = "quickshop-create";
    private static final String tradeFlag = "quickshop-trade";
    private final List<String> createLimits;
    private final List<String> tradeLimits;
    private final boolean whiteList;

    public ResidenceIntegration(QuickShop plugin) {
        super(plugin);
        this.whiteList = plugin.getConfig().getBoolean("integration.residence.whitelist-mode");
        this.createLimits = plugin.getConfig().getStringList("integration.residence.create");
        this.tradeLimits = plugin.getConfig().getStringList("integration.residence.trade");
    }

    @Override
    @NotNull
    public String getName() {
        return "Residence";
    }

    private boolean playerHas(FlagPermissions permissions, Player player, String name, boolean def) {
        Flags internalFlag = Flags.getFlag((String)name);
        if (internalFlag == null) {
            Map permPlayerMap = permissions.getPlayerFlags(player.getName());
            Map permGlobalMap = permissions.getFlags();
            if (permPlayerMap != null) {
                return permPlayerMap.getOrDefault(name, permGlobalMap.getOrDefault(name, def));
            }
            return permGlobalMap.getOrDefault(name, def);
        }
        return permissions.playerHas(player, internalFlag, def);
    }

    @Override
    public boolean canCreateShopHere(@NotNull Player player, @NotNull Location location) {
        ClaimedResidence residence = Residence.getInstance().getResidenceManager().getByLoc(location);
        for (String limit : this.createLimits) {
            if (!("FLAG".equalsIgnoreCase(limit) ? (residence == null ? !this.playerHas(Residence.getInstance().getWorldFlags().getPerms(location.getWorld().getName()), player, createFlag, !this.whiteList) : !this.playerHas((FlagPermissions)residence.getPermissions(), player, createFlag, false)) : (residence == null ? !this.playerHas(Residence.getInstance().getWorldFlags().getPerms(location.getWorld().getName()), player, limit, !this.whiteList) : !this.playerHas((FlagPermissions)residence.getPermissions(), player, limit, false)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canTradeShopHere(@NotNull Player player, @NotNull Location location) {
        ClaimedResidence residence = Residence.getInstance().getResidenceManager().getByLoc(location);
        for (String limit : this.tradeLimits) {
            if (!("FLAG".equalsIgnoreCase(limit) ? (residence == null ? !this.playerHas(Residence.getInstance().getWorldFlags().getPerms(location.getWorld().getName()), player, tradeFlag, !this.whiteList) : !this.playerHas((FlagPermissions)residence.getPermissions(), player, tradeFlag, true)) : (residence == null ? !this.playerHas(Residence.getInstance().getWorldFlags().getPerms(location.getWorld().getName()), player, limit, !this.whiteList) : !this.playerHas((FlagPermissions)residence.getPermissions(), player, limit, false)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void load() {
        FlagPermissions.addFlag((String)createFlag);
        FlagPermissions.addFlag((String)tradeFlag);
    }

    @Override
    public void unload() {
    }
}

