/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.integration.superiorskyblock;

import com.bgsoftware.superiorskyblock.api.SuperiorSkyblockAPI;
import com.bgsoftware.superiorskyblock.api.events.IslandChunkResetEvent;
import com.bgsoftware.superiorskyblock.api.events.IslandKickEvent;
import com.bgsoftware.superiorskyblock.api.events.IslandQuitEvent;
import com.bgsoftware.superiorskyblock.api.island.Island;
import com.bgsoftware.superiorskyblock.api.wrappers.SuperiorPlayer;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.integration.IntegrateStage;
import org.maxgamer.quickshop.integration.IntegrationStage;
import org.maxgamer.quickshop.integration.QSIntegratedPlugin;
import org.maxgamer.quickshop.shop.Shop;

@IntegrationStage(loadStage=IntegrateStage.onEnableAfter)
public class SuperiorSkyblock2Integration
extends QSIntegratedPlugin
implements Listener {
    private final boolean onlyOwnerCanCreateShop;
    private final boolean deleteShopOnMemberLeave;

    public SuperiorSkyblock2Integration(QuickShop plugin) {
        super(plugin);
        this.onlyOwnerCanCreateShop = plugin.getConfig().getBoolean("integration.superiorskyblock.owner-create-only");
        this.deleteShopOnMemberLeave = plugin.getConfig().getBoolean("integration.superiorskyblock.delete-shop-on-member-leave");
    }

    @Override
    @NotNull
    public String getName() {
        return "SuperiorSkyblock";
    }

    @Override
    public boolean canCreateShopHere(@NotNull Player player, @NotNull Location location) {
        Island island = SuperiorSkyblockAPI.getIslandAt((Location)location);
        SuperiorPlayer superiorPlayer = SuperiorSkyblockAPI.getPlayer((Player)player);
        if (island == null) {
            return false;
        }
        if (this.onlyOwnerCanCreateShop) {
            return island.getOwner().equals(superiorPlayer);
        }
        if (island.getOwner().equals(superiorPlayer)) {
            return true;
        }
        return island.isMember(superiorPlayer);
    }

    @Override
    public boolean canTradeShopHere(@NotNull Player player, @NotNull Location location) {
        return true;
    }

    @Override
    public void load() {
        if (this.plugin.getConfig().getBoolean("integration.superiorskyblock.delete-shop-on-member-leave")) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        }
    }

    @Override
    public void unload() {
        IslandQuitEvent.getHandlerList().unregister((Listener)this);
        IslandKickEvent.getHandlerList().unregister((Listener)this);
        IslandChunkResetEvent.getHandlerList().unregister((Listener)this);
    }

    @EventHandler
    public void deleteShops(IslandQuitEvent event) {
        event.getIsland().getAllChunks().forEach(chunk -> {
            Map<Location, Shop> shops = this.plugin.getShopManager().getShops((Chunk)chunk);
            if (shops != null && !shops.isEmpty()) {
                shops.forEach((location, shop) -> {
                    if (shop.getOwner().equals(event.getPlayer().getUniqueId())) {
                        this.plugin.log("[SuperiorSkyBlock2 Integration]Shop " + shop + " deleted caused by ShopOwnerQuitFromIsland");
                        shop.delete();
                    }
                });
            }
        });
    }

    @EventHandler
    public void deleteShops(IslandKickEvent event) {
        event.getIsland().getAllChunks().forEach(chunk -> {
            Map<Location, Shop> shops = this.plugin.getShopManager().getShops((Chunk)chunk);
            if (shops != null && !shops.isEmpty()) {
                shops.forEach((location, shop) -> {
                    if (shop.getOwner().equals(event.getTarget().getUniqueId())) {
                        this.plugin.log("[SuperiorSkyBlock2 Integration]Shop " + shop + " deleted caused by ShopOwnerKickedFromIsland");
                        shop.delete();
                    }
                });
            }
        });
    }

    @EventHandler
    public void deleteShops(IslandChunkResetEvent event) {
        Map<Location, Shop> shops = this.plugin.getShopManager().getShops(event.getWorld().getName(), event.getChunkX(), event.getChunkZ());
        if (shops != null && !shops.isEmpty()) {
            shops.forEach((location, shop) -> {
                this.plugin.log("[SuperiorSkyBlock2 Integration]Shop " + shop + " deleted caused by IslandChunkReset.");
                shop.delete();
            });
        }
    }
}

