/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.integration.worldguard;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagConflictException;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.integration.IntegrateStage;
import org.maxgamer.quickshop.integration.IntegrationStage;
import org.maxgamer.quickshop.integration.QSIntegratedPlugin;
import org.maxgamer.quickshop.integration.worldguard.WorldGuardFlags;
import org.maxgamer.quickshop.util.Util;

@IntegrationStage(loadStage=IntegrateStage.onLoadAfter)
public class WorldGuardIntegration
extends QSIntegratedPlugin {
    private final StateFlag createFlag = this.createOrGet("quickshop-create", false);
    private final StateFlag tradeFlag = this.createOrGet("quickshop-trade", true);
    private List<WorldGuardFlags> createFlags;
    private List<WorldGuardFlags> tradeFlags;
    private boolean anyOwner;
    private boolean whiteList;
    private boolean load = false;

    public WorldGuardIntegration(QuickShop plugin) {
        super(plugin);
    }

    private StateFlag createOrGet(String key, boolean def) {
        FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
        Flag result = WorldGuard.getInstance().getFlagRegistry().get(key);
        if (!(result instanceof StateFlag)) {
            result = new StateFlag(key, def);
            try {
                registry.register(result);
                this.plugin.getLogger().info(ChatColor.GREEN + this.getName() + " flags register successfully.");
                Util.debugLog("Success register " + this.getName() + " flags.");
            }
            catch (FlagConflictException | IllegalStateException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to register " + this.getName() + " flags.", e);
            }
        }
        return (StateFlag)result;
    }

    @Override
    public void load() {
        if (this.load) {
            return;
        }
        this.whiteList = this.plugin.getConfig().getBoolean("integration.worldguard.whitelist-mode");
        this.anyOwner = this.plugin.getConfig().getBoolean("integration.worldguard.any-owner");
        this.createFlags = WorldGuardFlags.deserialize(this.plugin.getConfig().getStringList("integration.worldguard.create"));
        this.tradeFlags = WorldGuardFlags.deserialize(this.plugin.getConfig().getStringList("integration.worldguard.trade"));
        this.load = true;
    }

    @Override
    public void unload() {
        this.load = false;
    }

    private void checkIfLoaded() {
        if (!this.load) {
            this.load();
            Util.debugLog(this.getName() + " Integration not loaded, loading...");
        }
    }

    @Override
    @NotNull
    public String getName() {
        return "WorldGuard";
    }

    @Override
    public boolean canCreateShopHere(@NotNull Player player, @NotNull Location location) {
        this.checkIfLoaded();
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        com.sk89q.worldedit.util.Location wgLoc = BukkitAdapter.adapt((Location)location);
        boolean canBypass = WorldGuard.getInstance().getPlatform().getSessionManager().hasBypass(localPlayer, BukkitAdapter.adapt((World)location.getWorld()));
        if (canBypass) {
            Util.debugLog("Player " + player.getName() + " bypassing the protection checks, because player have bypass permission in WorldGuard");
            return true;
        }
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        if (query.getApplicableRegions(wgLoc).getRegions().isEmpty()) {
            return !this.whiteList;
        }
        for (WorldGuardFlags flag : this.createFlags) {
            switch (flag) {
                case BUILD: {
                    if (query.queryState(wgLoc, localPlayer, new StateFlag[]{Flags.BUILD}) != StateFlag.State.DENY) break;
                    return false;
                }
                case FLAG: {
                    if (query.queryState(wgLoc, localPlayer, new StateFlag[]{this.createFlag}) != StateFlag.State.DENY) break;
                    return false;
                }
                case CHEST_ACCESS: {
                    if (query.queryState(wgLoc, localPlayer, new StateFlag[]{Flags.CHEST_ACCESS}) != StateFlag.State.DENY) break;
                    return false;
                }
                case INTERACT: {
                    if (query.queryState(wgLoc, localPlayer, new StateFlag[]{Flags.INTERACT}) != StateFlag.State.DENY) break;
                    return false;
                }
                case OWN: {
                    if (!(this.anyOwner ? query.getApplicableRegions(wgLoc).getRegions().stream().noneMatch(region -> region.isOwner(localPlayer)) : !query.getApplicableRegions(wgLoc).isOwnerOfAll(localPlayer))) break;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean canTradeShopHere(@NotNull Player player, @NotNull Location location) {
        this.checkIfLoaded();
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        com.sk89q.worldedit.util.Location wgLoc = BukkitAdapter.adapt((Location)location);
        boolean canBypass = WorldGuard.getInstance().getPlatform().getSessionManager().hasBypass(localPlayer, BukkitAdapter.adapt((World)location.getWorld()));
        if (canBypass) {
            Util.debugLog("Player " + player.getName() + " bypassing the protection checks, because player have bypass permission in WorldGuard");
            return true;
        }
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        if (query.getApplicableRegions(wgLoc).getRegions().isEmpty()) {
            return !this.whiteList;
        }
        for (WorldGuardFlags flag : this.tradeFlags) {
            switch (flag) {
                case BUILD: {
                    if (query.testState(wgLoc, localPlayer, new StateFlag[]{Flags.BUILD})) break;
                    return false;
                }
                case FLAG: {
                    if (query.testState(wgLoc, localPlayer, new StateFlag[]{this.tradeFlag})) break;
                    return false;
                }
                case CHEST_ACCESS: {
                    if (query.testState(wgLoc, localPlayer, new StateFlag[]{Flags.CHEST_ACCESS})) break;
                    return false;
                }
                case INTERACT: {
                    if (!query.testState(wgLoc, localPlayer, new StateFlag[]{Flags.INTERACT})) {
                        return false;
                    }
                }
                case OWN: {
                    if (this.anyOwner) {
                        return query.getApplicableRegions(wgLoc).getRegions().stream().anyMatch(region -> region.isOwner(localPlayer));
                    }
                    return query.getApplicableRegions(wgLoc).isOwnerOfAll(localPlayer);
                }
            }
        }
        return true;
    }
}

