/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.listener;

import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.Cache;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.listener.EnhanceDisplayProtectionListener;
import org.maxgamer.quickshop.listener.ProtectionListenerBase;
import org.maxgamer.quickshop.shop.DisplayItem;
import org.maxgamer.quickshop.shop.DisplayType;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.Util;

public class DisplayProtectionListener
extends ProtectionListenerBase {
    public DisplayProtectionListener(QuickShop plugin, Cache cache) {
        super(plugin, cache);
        boolean useEnhanceProtection = plugin.getConfig().getBoolean("shop.enchance-display-protect");
        if (useEnhanceProtection) {
            plugin.getServer().getPluginManager().registerEvents((Listener)new EnhanceDisplayProtectionListener(plugin, cache), (Plugin)plugin);
        }
    }

    private void sendAlert(@NotNull String msg) {
        if (!this.plugin.getConfig().getBoolean("send-display-item-protection-alert")) {
            return;
        }
        MsgUtil.sendGlobalAlert(msg);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void portal(EntityPortalEvent event) {
        if (DisplayItem.getNowUsing() != DisplayType.REALITEM) {
            return;
        }
        if (!(event.getEntity() instanceof Item)) {
            return;
        }
        if (DisplayItem.checkIsGuardItemStack(((Item)event.getEntity()).getItemStack())) {
            event.setCancelled(true);
            event.getEntity().remove();
            this.sendAlert("[DisplayGuard] Somebody want dupe the display by Portal at " + event.getFrom() + " , QuickShop already cancel it.");
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void inventory(InventoryOpenEvent event) {
        Util.inventoryCheck(event.getInventory());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void inventory(InventoryPickupItemEvent event) {
        ItemStack itemStack = event.getItem().getItemStack();
        if (DisplayItem.getNowUsing() != DisplayType.REALITEM) {
            return;
        }
        if (!DisplayItem.checkIsGuardItemStack(itemStack)) {
            return;
        }
        @Nullable Location loc = event.getInventory().getLocation();
        @Nullable InventoryHolder holder = event.getInventory().getHolder();
        event.setCancelled(true);
        this.sendAlert("[DisplayGuard] Something  " + holder + " at " + loc + " trying pickup the DisplayItem,  you should teleport to that location and to check detail..");
        Util.inventoryCheck(event.getInventory());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void item(ItemDespawnEvent event) {
        if (DisplayItem.getNowUsing() != DisplayType.REALITEM) {
            return;
        }
        ItemStack itemStack = event.getEntity().getItemStack();
        if (DisplayItem.checkIsGuardItemStack(itemStack)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void player(PlayerFishEvent event) {
        if (DisplayItem.getNowUsing() != DisplayType.REALITEM) {
            return;
        }
        if (event.getState() != PlayerFishEvent.State.CAUGHT_ENTITY) {
            return;
        }
        if (event.getCaught() == null) {
            return;
        }
        if (event.getCaught().getType() != EntityType.DROPPED_ITEM) {
            return;
        }
        Item item = (Item)event.getCaught();
        ItemStack is = item.getItemStack();
        if (!DisplayItem.checkIsGuardItemStack(is)) {
            return;
        }
        event.getHook().remove();
        event.setCancelled(true);
        this.sendAlert("[DisplayGuard] Player " + event.getPlayer().getName() + " trying hook item use Fishing Rod, QuickShop already removed it.");
        Util.inventoryCheck((Inventory)event.getPlayer().getInventory());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void player(PlayerArmorStandManipulateEvent event) {
        if (!DisplayItem.checkIsGuardItemStack(event.getArmorStandItem())) {
            return;
        }
        if (DisplayItem.getNowUsing() != DisplayType.REALITEM) {
            return;
        }
        event.setCancelled(true);
        Util.inventoryCheck((Inventory)event.getPlayer().getInventory());
        this.sendAlert("[DisplayGuard] Player  " + event.getPlayer().getName() + " trying mainipulate armorstand contains displayItem.");
    }
}

