/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.listener;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.BlockIterator;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.economy.Economy;
import org.maxgamer.quickshop.listener.QSListener;
import org.maxgamer.quickshop.shade.me.lucko.helper.cooldown.Cooldown;
import org.maxgamer.quickshop.shade.me.lucko.helper.cooldown.CooldownMap;
import org.maxgamer.quickshop.shop.Info;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.shop.ShopAction;
import org.maxgamer.quickshop.util.InteractUtil;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.Util;

public class PlayerListener
extends QSListener {
    private final CooldownMap<Player> cooldownMap = CooldownMap.create(Cooldown.of(1L, TimeUnit.SECONDS));
    private final boolean swapBehavior;

    public PlayerListener(QuickShop plugin) {
        super(plugin);
        this.swapBehavior = plugin.getConfig().getBoolean("shop.interact.swap-click-behavior");
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onClick(PlayerInteractEvent e) {
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Block b = e.getClickedBlock();
        if (e.getPlayer().getGameMode() == GameMode.ADVENTURE) {
            this.cooldownMap.test(e.getPlayer());
        }
        if (!e.getAction().equals((Object)Action.LEFT_CLICK_BLOCK) && b != null && e.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            if (!this.swapBehavior) {
                this.postControlPanel(e);
            } else {
                this.postTrade(e);
            }
            return;
        }
        if (!this.swapBehavior) {
            this.postTrade(e);
        } else {
            this.postControlPanel(e);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onAdventureClick(PlayerAnimationEvent event) {
        if (event.getPlayer().getGameMode() != GameMode.ADVENTURE) {
            return;
        }
        if (!this.cooldownMap.test(event.getPlayer())) {
            return;
        }
        Block focused = event.getPlayer().getTargetBlock(null, 5);
        PlayerInteractEvent interactEvent = new PlayerInteractEvent(event.getPlayer(), focused.getType() == Material.AIR ? Action.LEFT_CLICK_AIR : Action.LEFT_CLICK_BLOCK, event.getPlayer().getInventory().getItemInMainHand(), focused, event.getPlayer().getFacing().getOppositeFace());
        if (!this.swapBehavior) {
            this.postTrade(interactEvent);
        } else {
            this.postControlPanel(interactEvent);
        }
    }

    private void playClickSound(@NotNull Player player) {
        if (this.plugin.getConfig().getBoolean("effect.sound.onclick")) {
            player.playSound(player.getLocation(), Sound.BLOCK_DISPENSER_FAIL, 80.0f, 1.0f);
        }
    }

    private void postControlPanel(PlayerInteractEvent e) {
        Block b = e.getClickedBlock();
        Player p = e.getPlayer();
        if (Util.isWallSign(b.getType())) {
            Block block = Util.isWallSign(b.getType()) ? Util.getAttached(b) : e.getClickedBlock();
            Shop controlPanelShop = this.plugin.getShopManager().getShop(Objects.requireNonNull(block).getLocation());
            if (controlPanelShop != null && (controlPanelShop.getOwner().equals(p.getUniqueId()) || QuickShop.getPermissionManager().hasPermission((CommandSender)p, "quickshop.other.control"))) {
                MsgUtil.sendControlPanelInfo((CommandSender)p, Objects.requireNonNull(this.plugin.getShopManager().getShop(block.getLocation())));
                this.playClickSound(e.getPlayer());
                Objects.requireNonNull(this.plugin.getShopManager().getShop(block.getLocation())).setSignText();
            }
        }
    }

    private void postTrade(PlayerInteractEvent e) {
        Block b = e.getClickedBlock();
        Player p = e.getPlayer();
        if (b == null) {
            return;
        }
        if (!Util.canBeShop(b) && !Util.isWallSign(b.getType())) {
            return;
        }
        Location loc = b.getLocation();
        ItemStack item = e.getItem();
        Shop shop = this.plugin.getShopManager().getShop(loc);
        if (shop == null) {
            Shop secondHalfShop;
            Block attached;
            if (Util.isWallSign(b.getType())) {
                attached = Util.getAttached(b);
                if (attached != null) {
                    shop = this.plugin.getShopManager().getShop(attached.getLocation());
                }
            } else if (Util.isDoubleChest(b.getBlockData()) && (attached = Util.getSecondHalf(b)) != null && (secondHalfShop = this.plugin.getShopManager().getShop(attached.getLocation())) != null && !p.getUniqueId().equals(secondHalfShop.getOwner())) {
                shop = secondHalfShop;
            }
        }
        if (shop != null && QuickShop.getPermissionManager().hasPermission((CommandSender)p, "quickshop.use")) {
            if (!InteractUtil.check(InteractUtil.Action.TRADE, p.isSneaking())) {
                return;
            }
            shop.onClick();
            this.playClickSound(e.getPlayer());
            MsgUtil.sendShopInfo(p, shop);
            shop.setSignText();
            Economy eco = this.plugin.getEconomy();
            double price = shop.getPrice();
            double money = this.plugin.getEconomy().getBalance(p.getUniqueId(), shop.getLocation().getWorld(), shop.getCurrency());
            if (shop.isSelling()) {
                int itemAmount = Math.min(Util.countSpace((Inventory)p.getInventory(), shop.getItem()), (int)Math.floor(money / price));
                if (!shop.isUnlimited()) {
                    itemAmount = Math.min(itemAmount, shop.getRemainingStock());
                }
                if (itemAmount < 0) {
                    itemAmount = 0;
                }
                if (shop.isStackingShop()) {
                    MsgUtil.sendMessage((CommandSender)p, "how-many-buy-stack", Integer.toString(shop.getItem().getAmount()), Integer.toString(itemAmount));
                } else {
                    MsgUtil.sendMessage((CommandSender)p, "how-many-buy", Integer.toString(itemAmount));
                }
            } else {
                double ownerBalance = eco.getBalance(shop.getOwner(), shop.getLocation().getWorld(), shop.getCurrency());
                int items = Util.countItems((Inventory)p.getInventory(), shop.getItem());
                int ownerCanAfford = (int)(ownerBalance / shop.getPrice());
                if (!shop.isUnlimited()) {
                    items = Math.min(items, shop.getRemainingSpace());
                    items = Math.min(items, ownerCanAfford);
                } else if (this.plugin.getConfig().getBoolean("shop.pay-unlimited-shop-owners")) {
                    items = Math.min(items, ownerCanAfford);
                }
                if (items < 0) {
                    items = 0;
                }
                if (shop.isStackingShop()) {
                    MsgUtil.sendMessage((CommandSender)p, "how-many-sell-stack", Integer.toString(shop.getItem().getAmount()), Integer.toString(items));
                } else {
                    MsgUtil.sendMessage((CommandSender)p, "how-many-sell", Integer.toString(items));
                }
            }
            Map<UUID, Info> actions = this.plugin.getShopManager().getActions();
            Info info = new Info(shop.getLocation(), ShopAction.BUY, null, null, shop);
            actions.put(p.getUniqueId(), info);
        } else if (e.useInteractedBlock() == Event.Result.ALLOW && shop == null && item != null && item.getType() != Material.AIR && QuickShop.getPermissionManager().hasPermission((CommandSender)p, "quickshop.create.sell") && p.getGameMode() != GameMode.CREATIVE) {
            Block n;
            if (e.useInteractedBlock() == Event.Result.DENY || !InteractUtil.check(InteractUtil.Action.CREATE, p.isSneaking()) || this.plugin.getConfig().getBoolean("shop.disable-quick-create") || !this.plugin.getShopManager().canBuildShop(p, b, e.getBlockFace())) {
                return;
            }
            if (Util.isDoubleChest(b.getBlockData()) && !QuickShop.getPermissionManager().hasPermission((CommandSender)p, "quickshop.create.double")) {
                MsgUtil.sendMessage((CommandSender)p, "no-double-chests", new String[0]);
                return;
            }
            if (Util.isBlacklisted(item) && !QuickShop.getPermissionManager().hasPermission((CommandSender)p, "quickshop.bypass." + item.getType().name())) {
                MsgUtil.sendMessage((CommandSender)p, "blacklisted-item", new String[0]);
                return;
            }
            if (b.getType() == Material.ENDER_CHEST && !QuickShop.getPermissionManager().hasPermission((CommandSender)p, "quickshop.create.enderchest")) {
                return;
            }
            if (Util.isWallSign(b.getType())) {
                return;
            }
            Block last = null;
            Location from = p.getLocation().clone();
            from.setY((double)b.getY());
            from.setPitch(0.0f);
            BlockIterator bIt = new BlockIterator(from, 0.0, 7);
            while (bIt.hasNext() && !(n = bIt.next()).equals(b)) {
                last = n;
            }
            Info info = new Info(b.getLocation(), ShopAction.CREATE, e.getItem(), last);
            this.plugin.getShopManager().getActions().put(p.getUniqueId(), info);
            MsgUtil.sendMessage((CommandSender)p, "how-much-to-trade-for", Util.getItemStackName(Objects.requireNonNull(e.getItem())), Integer.toString(this.plugin.isAllowStack() && QuickShop.getPermissionManager().hasPermission((CommandSender)p, "quickshop.create.stacks") ? item.getAmount() : 1));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryClose(InventoryCloseEvent e) {
        try {
            if (e.getInventory() == null) {
                return;
            }
            if (e.getInventory().getLocation() == null) {
                return;
            }
            Location location = e.getInventory().getLocation();
            if (location == null) {
                return;
            }
            Shop shop = this.plugin.getShopManager().getShopIncludeAttached(location);
            if (shop != null) {
                shop.setSignText();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onJoin(PlayerJoinEvent e) {
        if (this.plugin.getConfig().getBoolean("shop.auto-fetch-shop-messages")) {
            MsgUtil.flush((OfflinePlayer)e.getPlayer());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent e) {
        this.plugin.getShopManager().getActions().remove(e.getPlayer().getUniqueId());
    }

    @EventHandler(ignoreCancelled=true)
    public void onTeleport(PlayerTeleportEvent e) {
        this.onMove(new PlayerMoveEvent(e.getPlayer(), e.getFrom(), e.getTo()));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onMove(PlayerMoveEvent e) {
        Info info = this.plugin.getShopManager().getActions().get(e.getPlayer().getUniqueId());
        if (info == null) {
            return;
        }
        Player p = e.getPlayer();
        Location loc1 = info.getLocation();
        Location loc2 = p.getLocation();
        if (loc1.getWorld() != loc2.getWorld() || loc1.distanceSquared(loc2) > 25.0) {
            if (info.getAction() == ShopAction.BUY) {
                MsgUtil.sendMessage((CommandSender)p, "shop-purchase-cancelled", new String[0]);
                Util.debugLog(p.getName() + " too far with the shop location.");
            } else if (info.getAction() == ShopAction.CREATE) {
                MsgUtil.sendMessage((CommandSender)p, "shop-creation-cancelled", new String[0]);
                Util.debugLog(p.getName() + " too far with the shop location.");
            }
            this.plugin.getShopManager().getActions().remove(p.getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onDyeing(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK || e.getItem() == null || !Util.isDyes(e.getItem().getType())) {
            return;
        }
        Block block = e.getClickedBlock();
        if (block == null || !Util.isWallSign(block.getType())) {
            return;
        }
        Block attachedBlock = Util.getAttached(block);
        if (attachedBlock == null || this.plugin.getShopManager().getShopIncludeAttached(attachedBlock.getLocation()) == null) {
            return;
        }
        e.setCancelled(true);
        Util.debugLog("Disallow " + e.getPlayer().getName() + " dye the shop sign.");
    }
}

