/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.listener;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.listener.QSListener;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.shop.ShopChunk;

public class WorldListener
extends QSListener {
    public WorldListener(QuickShop plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldLoad(WorldLoadEvent e) {
        World world = e.getWorld();
        this.plugin.getShopLoader().loadShops(world.getName());
        ConcurrentHashMap inWorld = new ConcurrentHashMap(1);
        Map<ShopChunk, Map<Location, Shop>> oldInWorld = this.plugin.getShopManager().getShops(world.getName());
        if (oldInWorld == null) {
            return;
        }
        for (Map.Entry<ShopChunk, Map<Location, Shop>> oldInChunk : oldInWorld.entrySet()) {
            ConcurrentHashMap<Location, Shop> inChunk = new ConcurrentHashMap<Location, Shop>(1);
            inWorld.put(oldInChunk.getKey(), inChunk);
            for (Map.Entry<Location, Shop> entry : oldInChunk.getValue().entrySet()) {
                Shop shop = entry.getValue();
                shop.getLocation().setWorld(world);
                inChunk.put(shop.getLocation(), shop);
            }
        }
        this.plugin.getShopManager().getShops().put(world.getName(), inWorld);
        for (Chunk chunk : world.getLoadedChunks()) {
            Map<Location, Shop> inChunk = this.plugin.getShopManager().getShops(chunk);
            if (inChunk == null) continue;
            for (Shop shop : inChunk.values()) {
                shop.onLoad();
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldUnload(WorldUnloadEvent e) {
        for (Chunk chunk : e.getWorld().getLoadedChunks()) {
            Map<Location, Shop> inChunk = this.plugin.getShopManager().getShops(chunk);
            if (inChunk == null) continue;
            for (Shop shop : inChunk.values()) {
                if (!shop.isLoaded()) continue;
                shop.onUnload();
            }
        }
    }
}

