/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.listener.worldedit;

import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import org.bukkit.Location;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.util.Util;

public class WorldEditBlockListener
extends AbstractDelegateExtent {
    private final Actor actor;
    private final World world;
    private final Extent extent;
    private final QuickShop plugin;

    WorldEditBlockListener(Actor actor, World world, Extent originalExtent, QuickShop plugin) {
        super(originalExtent);
        this.actor = actor;
        this.world = world;
        this.extent = originalExtent;
        this.plugin = plugin;
    }

    public <T extends BlockStateHolder<T>> boolean setBlock(BlockVector3 position, T block) throws WorldEditException {
        Shop shop;
        if (!(this.world instanceof BukkitWorld)) {
            return super.setBlock(position, block);
        }
        org.bukkit.World world = ((BukkitWorld)this.world).getWorld();
        BlockState oldBlock = this.extent.getBlock(position);
        BlockState newBlock = block.toImmutableState();
        Location location = new Location(world, (double)position.getBlockX(), (double)position.getBlockY(), (double)position.getBlockZ());
        if (this.extent.setBlock(position, block) && oldBlock.getBlockType().getMaterial().hasContainer() && !newBlock.getBlockType().getMaterial().hasContainer() && (shop = this.plugin.getShopManager().getShop(location, true)) != null) {
            this.plugin.getLogger().info("Removing shop at " + location + " because removed by WorldEdit.");
            this.plugin.log("Deleting shop " + shop + " as requested by the WorldEdit support.");
            Util.mainThreadRun(shop::delete);
        }
        return super.setBlock(position, block);
    }
}

