/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.shade.com.rollbar.api.payload.data.body;

import java.util.HashMap;
import java.util.Map;
import org.maxgamer.quickshop.shade.com.rollbar.api.json.JsonSerializable;

public class ExceptionInfo
implements JsonSerializable {
    private static final long serialVersionUID = -2271411217988417830L;
    private final String className;
    private final String message;
    private final String description;

    private ExceptionInfo(Builder builder) {
        this.className = builder.className;
        this.message = builder.message;
        this.description = builder.description;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public Map<String, Object> asJson() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (this.className != null) {
            values.put("class", this.className);
        }
        if (this.message != null) {
            values.put("message", this.message);
        }
        if (this.description != null) {
            values.put("description", this.description);
        }
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExceptionInfo that = (ExceptionInfo)o;
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        return this.description != null ? this.description.equals(that.description) : that.description == null;
    }

    public int hashCode() {
        int result = this.className != null ? this.className.hashCode() : 0;
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ExceptionInfo{classname='" + this.className + '\'' + ", message='" + this.message + '\'' + ", description='" + this.description + '\'' + '}';
    }

    public static final class Builder {
        private String className;
        private String message;
        private String description;

        public Builder() {
        }

        public Builder(ExceptionInfo exceptionInfo) {
            this.className = exceptionInfo.className;
            this.message = exceptionInfo.message;
            this.description = exceptionInfo.description;
        }

        public Builder className(String className) {
            this.className = className;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public ExceptionInfo build() {
            return new ExceptionInfo(this);
        }
    }
}

