/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.shade.me.lucko.helper.cooldown;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.maxgamer.quickshop.shade.me.lucko.helper.cooldown.CooldownImpl;
import org.maxgamer.quickshop.shade.me.lucko.helper.gson.GsonSerializable;
import org.maxgamer.quickshop.shade.me.lucko.helper.scheduler.Ticks;
import org.maxgamer.quickshop.shade.me.lucko.helper.time.Time;

public interface Cooldown
extends GsonSerializable {
    public static Cooldown deserialize(JsonElement element) {
        Preconditions.checkArgument(element.isJsonObject());
        JsonObject object = element.getAsJsonObject();
        Preconditions.checkArgument(object.has("lastTested"));
        Preconditions.checkArgument(object.has("timeout"));
        long lastTested = object.get("lastTested").getAsLong();
        long timeout = object.get("timeout").getAsLong();
        Cooldown c = Cooldown.of(timeout, TimeUnit.MILLISECONDS);
        c.setLastTested(lastTested);
        return c;
    }

    @Nonnull
    public static Cooldown ofTicks(long ticks) {
        return new CooldownImpl(Ticks.to(ticks, TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    @Nonnull
    public static Cooldown of(long amount, @Nonnull TimeUnit unit) {
        return new CooldownImpl(amount, unit);
    }

    default public boolean test() {
        if (!this.testSilently()) {
            return false;
        }
        this.reset();
        return true;
    }

    default public boolean testSilently() {
        return this.elapsed() > this.getTimeout();
    }

    default public long elapsed() {
        return Time.nowMillis() - this.getLastTested().orElse(0L);
    }

    default public void reset() {
        this.setLastTested(Time.nowMillis());
    }

    default public long remainingMillis() {
        long diff = this.elapsed();
        return diff > this.getTimeout() ? 0L : this.getTimeout() - diff;
    }

    default public long remainingTime(TimeUnit unit) {
        return Math.max(0L, unit.convert(this.remainingMillis(), TimeUnit.MILLISECONDS));
    }

    @Nonnull
    public OptionalLong getLastTested();

    public void setLastTested(long var1);

    public long getTimeout();

    @Nonnull
    public Cooldown copy();
}

