/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.shade.me.lucko.helper.gson;

import com.google.gson.JsonElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface GsonSerializable {
    @Nonnull
    public static <T extends GsonSerializable> T deserialize(@Nonnull Class<T> clazz, @Nonnull JsonElement element) {
        Method deserializeMethod = GsonSerializable.getDeserializeMethod(clazz);
        if (deserializeMethod == null) {
            throw new IllegalStateException("Class does not have a deserialize method accessible.");
        }
        try {
            return (T)((GsonSerializable)deserializeMethod.invoke(null, element));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static GsonSerializable deserializeRaw(@Nonnull Class<?> clazz, @Nonnull JsonElement element) {
        Class<GsonSerializable> typeCastedClass = clazz.asSubclass(GsonSerializable.class);
        return GsonSerializable.deserialize(typeCastedClass, element);
    }

    @Nullable
    public static Method getDeserializeMethod(@Nonnull Class<?> clazz) {
        Method deserializeMethod;
        if (!GsonSerializable.class.isAssignableFrom(clazz)) {
            return null;
        }
        try {
            deserializeMethod = clazz.getDeclaredMethod("deserialize", JsonElement.class);
            deserializeMethod.setAccessible(true);
        }
        catch (Exception e) {
            return null;
        }
        if (!Modifier.isStatic(deserializeMethod.getModifiers())) {
            return null;
        }
        return deserializeMethod;
    }

    @Nonnull
    public JsonElement serialize();
}

