/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.shade.me.lucko.helper.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.maxgamer.quickshop.shade.me.lucko.helper.gson.GsonSerializable;
import org.maxgamer.quickshop.shade.me.lucko.helper.utils.annotation.NonnullByDefault;

@NonnullByDefault
public final class JsonBuilder {
    public static JsonObjectBuilder object(JsonObject object, boolean copy) {
        Objects.requireNonNull(object, "object");
        if (copy) {
            return JsonBuilder.object().addAll(object, true);
        }
        return new JsonObjectBuilderImpl(object);
    }

    public static JsonObjectBuilder object(JsonObject object) {
        Objects.requireNonNull(object, "object");
        return JsonBuilder.object(object, false);
    }

    public static JsonObjectBuilder object() {
        return JsonBuilder.object(new JsonObject());
    }

    public static JsonArrayBuilder array(JsonArray array, boolean copy) {
        Objects.requireNonNull(array, "array");
        if (copy) {
            return JsonBuilder.array().addAll(array, true);
        }
        return new JsonArrayBuilderImpl(array);
    }

    public static JsonArrayBuilder array(JsonArray array) {
        Objects.requireNonNull(array, "array");
        return JsonBuilder.array(array, false);
    }

    public static JsonArrayBuilder array() {
        return JsonBuilder.array(new JsonArray());
    }

    public static JsonElement primitive(@Nullable String value) {
        return value == null ? JsonBuilder.nullValue() : new JsonPrimitive(value);
    }

    public static JsonElement primitive(@Nullable Number value) {
        return value == null ? JsonBuilder.nullValue() : new JsonPrimitive(value);
    }

    public static JsonElement primitive(@Nullable Boolean value) {
        return value == null ? JsonBuilder.nullValue() : new JsonPrimitive(value);
    }

    public static JsonElement primitive(@Nullable Character value) {
        return value == null ? JsonBuilder.nullValue() : new JsonPrimitive(value);
    }

    public static JsonNull nullValue() {
        return JsonNull.INSTANCE;
    }

    public static JsonPrimitive primitiveNonNull(String value) {
        Objects.requireNonNull(value, "value");
        return new JsonPrimitive(value);
    }

    public static JsonPrimitive primitiveNonNull(Number value) {
        Objects.requireNonNull(value, "value");
        return new JsonPrimitive(value);
    }

    public static JsonPrimitive primitiveNonNull(Boolean value) {
        Objects.requireNonNull(value, "value");
        return new JsonPrimitive(value);
    }

    public static JsonPrimitive primitiveNonNull(Character value) {
        Objects.requireNonNull(value, "value");
        return new JsonPrimitive(value);
    }

    public static <T> Collector<T, JsonObjectBuilder, JsonObject> collectToObject(Function<? super T, String> keyMapper, Function<? super T, JsonElement> valueMapper) {
        return Collector.of(JsonBuilder::object, (r, t) -> r.add((String)keyMapper.apply(t), (JsonElement)valueMapper.apply(t)), (l, r) -> l.addAll(r.build()), JsonObjectBuilder::build, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, JsonArrayBuilder, JsonArray> collectToArray(Function<? super T, JsonElement> valueMapper) {
        return Collector.of(JsonBuilder::array, (r, t) -> r.add((JsonElement)valueMapper.apply(t)), (l, r) -> l.addAll(r.build()), JsonArrayBuilder::build, new Collector.Characteristics[0]);
    }

    public static Collector<JsonElement, JsonArrayBuilder, JsonArray> collectToArray() {
        return Collector.of(JsonBuilder::array, JsonArrayBuilder::add, (l, r) -> l.addAll(r.build()), JsonArrayBuilder::build, new Collector.Characteristics[0]);
    }

    public static Collector<GsonSerializable, JsonArrayBuilder, JsonArray> collectSerializablesToArray() {
        return Collector.of(JsonBuilder::array, JsonArrayBuilder::add, (l, r) -> l.addAll(r.build()), JsonArrayBuilder::build, new Collector.Characteristics[0]);
    }

    private JsonBuilder() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    private static final class JsonArrayBuilderImpl
    implements JsonArrayBuilder {
        private final JsonArray handle;

        private JsonArrayBuilderImpl(JsonArray handle) {
            this.handle = handle;
        }

        @Override
        public JsonArrayBuilder add(@Nullable JsonElement value, boolean copy) {
            if (value == null) {
                value = JsonBuilder.nullValue();
            }
            if (copy && value.isJsonObject()) {
                this.handle.add((JsonElement)JsonBuilder.object(value.getAsJsonObject(), true).build());
            } else if (copy && value.isJsonArray()) {
                this.handle.add((JsonElement)JsonBuilder.array(value.getAsJsonArray(), true).build());
            } else {
                this.handle.add(value);
            }
            return this;
        }

        @Override
        public JsonArray build() {
            return this.handle;
        }
    }

    private static final class JsonObjectBuilderImpl
    implements JsonObjectBuilder {
        private final JsonObject handle;

        private JsonObjectBuilderImpl(JsonObject handle) {
            this.handle = handle;
        }

        @Override
        public JsonObjectBuilder add(String property, @Nullable JsonElement value, boolean copy) {
            Objects.requireNonNull(property, "property");
            if (value == null) {
                value = JsonBuilder.nullValue();
            }
            if (copy && value.isJsonObject()) {
                this.handle.add(property, (JsonElement)JsonBuilder.object(value.getAsJsonObject(), true).build());
            } else if (copy && value.isJsonArray()) {
                this.handle.add(property, (JsonElement)JsonBuilder.array(value.getAsJsonArray(), true).build());
            } else {
                this.handle.add(property, value);
            }
            return this;
        }

        @Override
        public JsonObjectBuilder addIfAbsent(String property, @Nullable JsonElement value, boolean copy) {
            Objects.requireNonNull(property, "property");
            if (this.handle.has(property)) {
                return this;
            }
            return this.add(property, value, copy);
        }

        @Override
        public JsonObject build() {
            return this.handle;
        }
    }

    public static interface JsonArrayBuilder
    extends Consumer<JsonElement> {
        @Override
        default public void accept(JsonElement value) {
            this.add(value);
        }

        public JsonArrayBuilder add(@Nullable JsonElement var1, boolean var2);

        default public JsonArrayBuilder add(@Nullable JsonElement value) {
            return this.add(value, false);
        }

        default public JsonArrayBuilder add(@Nullable GsonSerializable serializable) {
            return serializable == null ? this.add((JsonElement)JsonBuilder.nullValue()) : this.add(serializable.serialize());
        }

        default public JsonArrayBuilder add(@Nullable String value) {
            return this.add(JsonBuilder.primitive(value));
        }

        default public JsonArrayBuilder add(@Nullable Number value) {
            return this.add(JsonBuilder.primitive(value));
        }

        default public JsonArrayBuilder add(@Nullable Boolean value) {
            return this.add(JsonBuilder.primitive(value));
        }

        default public JsonArrayBuilder add(@Nullable Character value) {
            return this.add(JsonBuilder.primitive(value));
        }

        default public <T extends JsonElement> JsonArrayBuilder addAll(Iterable<T> iterable, boolean copy) {
            Objects.requireNonNull(iterable, "iterable");
            for (JsonElement e : iterable) {
                this.add(e, copy);
            }
            return this;
        }

        default public <T extends JsonElement> JsonArrayBuilder addAll(Iterable<T> iterable) {
            return this.addAll(iterable, false);
        }

        default public <T extends JsonElement> JsonArrayBuilder addAll(Stream<T> stream, boolean copy) {
            Objects.requireNonNull(stream, "iterable");
            stream.forEach(e -> this.add((JsonElement)e, copy));
            return this;
        }

        default public <T extends JsonElement> JsonArrayBuilder addAll(Stream<T> stream) {
            return this.addAll(stream, false);
        }

        default public <T extends GsonSerializable> JsonArrayBuilder addSerializables(Iterable<T> iterable) {
            Objects.requireNonNull(iterable, "iterable");
            for (GsonSerializable e : iterable) {
                this.add(e);
            }
            return this;
        }

        default public JsonArrayBuilder addStrings(Iterable<String> iterable) {
            Objects.requireNonNull(iterable, "iterable");
            for (String e : iterable) {
                this.add(e);
            }
            return this;
        }

        default public <T extends Number> JsonArrayBuilder addNumbers(Iterable<T> iterable) {
            Objects.requireNonNull(iterable, "iterable");
            for (Number e : iterable) {
                this.add(e);
            }
            return this;
        }

        default public JsonArrayBuilder addBooleans(Iterable<Boolean> iterable) {
            Objects.requireNonNull(iterable, "iterable");
            for (Boolean e : iterable) {
                this.add(e);
            }
            return this;
        }

        default public JsonArrayBuilder addCharacters(Iterable<Character> iterable) {
            Objects.requireNonNull(iterable, "iterable");
            for (Character e : iterable) {
                this.add(e);
            }
            return this;
        }

        public JsonArray build();
    }

    public static interface JsonObjectBuilder
    extends BiConsumer<String, JsonElement>,
    Consumer<Map.Entry<String, JsonElement>> {
        @Override
        default public void accept(Map.Entry<String, JsonElement> entry) {
            Objects.requireNonNull(entry, "entry");
            this.add(entry.getKey(), entry.getValue());
        }

        @Override
        default public void accept(String property, JsonElement value) {
            this.add(property, value);
        }

        public JsonObjectBuilder add(String var1, @Nullable JsonElement var2, boolean var3);

        default public JsonObjectBuilder add(String property, @Nullable JsonElement value) {
            return this.add(property, value, false);
        }

        default public JsonObjectBuilder add(String property, @Nullable GsonSerializable serializable) {
            return serializable == null ? this.add(property, (JsonElement)JsonBuilder.nullValue()) : this.add(property, serializable.serialize());
        }

        default public JsonObjectBuilder add(String property, @Nullable String value) {
            return this.add(property, JsonBuilder.primitive(value));
        }

        default public JsonObjectBuilder add(String property, @Nullable Number value) {
            return this.add(property, JsonBuilder.primitive(value));
        }

        default public JsonObjectBuilder add(String property, @Nullable Boolean value) {
            return this.add(property, JsonBuilder.primitive(value));
        }

        default public JsonObjectBuilder add(String property, @Nullable Character value) {
            return this.add(property, JsonBuilder.primitive(value));
        }

        public JsonObjectBuilder addIfAbsent(String var1, @Nullable JsonElement var2, boolean var3);

        default public JsonObjectBuilder addIfAbsent(String property, @Nullable JsonElement value) {
            return this.addIfAbsent(property, value, false);
        }

        default public JsonObjectBuilder addIfAbsent(String property, @Nullable GsonSerializable serializable) {
            return serializable == null ? this.addIfAbsent(property, (JsonElement)JsonBuilder.nullValue()) : this.addIfAbsent(property, serializable.serialize());
        }

        default public JsonObjectBuilder addIfAbsent(String property, @Nullable String value) {
            return this.addIfAbsent(property, JsonBuilder.primitive(value));
        }

        default public JsonObjectBuilder addIfAbsent(String property, @Nullable Number value) {
            return this.addIfAbsent(property, JsonBuilder.primitive(value));
        }

        default public JsonObjectBuilder addIfAbsent(String property, @Nullable Boolean value) {
            return this.addIfAbsent(property, JsonBuilder.primitive(value));
        }

        default public JsonObjectBuilder addIfAbsent(String property, @Nullable Character value) {
            return this.addIfAbsent(property, JsonBuilder.primitive(value));
        }

        default public <T extends JsonElement> JsonObjectBuilder addAll(Iterable<Map.Entry<String, T>> iterable, boolean deepCopy) {
            Objects.requireNonNull(iterable, "iterable");
            for (Map.Entry<String, T> e : iterable) {
                if (e == null || e.getKey() == null) continue;
                this.add(e.getKey(), (JsonElement)e.getValue(), deepCopy);
            }
            return this;
        }

        default public <T extends JsonElement> JsonObjectBuilder addAll(Iterable<Map.Entry<String, T>> iterable) {
            return this.addAll(iterable, false);
        }

        default public <T extends JsonElement> JsonObjectBuilder addAll(Stream<Map.Entry<String, T>> stream, boolean deepCopy) {
            Objects.requireNonNull(stream, "stream");
            stream.forEach(e -> {
                if (e == null || e.getKey() == null) {
                    return;
                }
                this.add((String)e.getKey(), (JsonElement)e.getValue(), deepCopy);
            });
            return this;
        }

        default public <T extends JsonElement> JsonObjectBuilder addAll(Stream<Map.Entry<String, T>> stream) {
            return this.addAll(stream, false);
        }

        default public JsonObjectBuilder addAll(JsonObject object, boolean deepCopy) {
            Objects.requireNonNull(object, "object");
            return this.addAll(object.entrySet(), deepCopy);
        }

        default public JsonObjectBuilder addAll(JsonObject object) {
            return this.addAll(object, false);
        }

        default public <T extends GsonSerializable> JsonObjectBuilder addAllSerializables(Iterable<Map.Entry<String, T>> iterable) {
            Objects.requireNonNull(iterable, "iterable");
            for (Map.Entry<String, T> e : iterable) {
                if (e == null || e.getKey() == null) continue;
                this.add(e.getKey(), (GsonSerializable)e.getValue());
            }
            return this;
        }

        default public JsonObjectBuilder addAllStrings(Iterable<Map.Entry<String, String>> iterable) {
            Objects.requireNonNull(iterable, "iterable");
            for (Map.Entry<String, String> e : iterable) {
                if (e == null || e.getKey() == null) continue;
                this.add(e.getKey(), e.getValue());
            }
            return this;
        }

        default public <T extends Number> JsonObjectBuilder addAllNumbers(Iterable<Map.Entry<String, T>> iterable) {
            Objects.requireNonNull(iterable, "iterable");
            for (Map.Entry<String, T> e : iterable) {
                if (e == null || e.getKey() == null) continue;
                this.add(e.getKey(), (Number)e.getValue());
            }
            return this;
        }

        default public JsonObjectBuilder addAllBooleans(Iterable<Map.Entry<String, Boolean>> iterable) {
            Objects.requireNonNull(iterable, "iterable");
            for (Map.Entry<String, Boolean> e : iterable) {
                if (e == null || e.getKey() == null) continue;
                this.add(e.getKey(), e.getValue());
            }
            return this;
        }

        default public JsonObjectBuilder addAllCharacters(Iterable<Map.Entry<String, Character>> iterable) {
            Objects.requireNonNull(iterable, "iterable");
            for (Map.Entry<String, Character> e : iterable) {
                if (e == null || e.getKey() == null) continue;
                this.add(e.getKey(), e.getValue());
            }
            return this;
        }

        default public <T extends JsonElement> JsonObjectBuilder addAllIfAbsent(Iterable<Map.Entry<String, T>> iterable, boolean deepCopy) {
            Objects.requireNonNull(iterable, "iterable");
            for (Map.Entry<String, T> e : iterable) {
                if (e == null || e.getKey() == null) continue;
                this.addIfAbsent(e.getKey(), (JsonElement)e.getValue(), deepCopy);
            }
            return this;
        }

        default public <T extends JsonElement> JsonObjectBuilder addAllIfAbsent(Iterable<Map.Entry<String, T>> iterable) {
            return this.addAllIfAbsent(iterable, false);
        }

        default public <T extends JsonElement> JsonObjectBuilder addAllIfAbsent(Stream<Map.Entry<String, T>> stream, boolean deepCopy) {
            Objects.requireNonNull(stream, "stream");
            stream.forEach(e -> {
                if (e == null || e.getKey() == null) {
                    return;
                }
                this.addIfAbsent((String)e.getKey(), (JsonElement)e.getValue(), deepCopy);
            });
            return this;
        }

        default public <T extends JsonElement> JsonObjectBuilder addAllIfAbsent(Stream<Map.Entry<String, T>> stream) {
            return this.addAllIfAbsent(stream, false);
        }

        default public JsonObjectBuilder addAllIfAbsent(JsonObject object, boolean deepCopy) {
            Objects.requireNonNull(object, "object");
            return this.addAllIfAbsent(object.entrySet(), deepCopy);
        }

        default public JsonObjectBuilder addAllIfAbsent(JsonObject object) {
            return this.addAllIfAbsent(object, false);
        }

        default public <T extends GsonSerializable> JsonObjectBuilder addAllSerializablesIfAbsent(Iterable<Map.Entry<String, T>> iterable) {
            Objects.requireNonNull(iterable, "iterable");
            for (Map.Entry<String, T> e : iterable) {
                if (e == null || e.getKey() == null) continue;
                this.addIfAbsent(e.getKey(), (GsonSerializable)e.getValue());
            }
            return this;
        }

        default public JsonObjectBuilder addAllStringsIfAbsent(Iterable<Map.Entry<String, String>> iterable) {
            Objects.requireNonNull(iterable, "iterable");
            for (Map.Entry<String, String> e : iterable) {
                if (e == null || e.getKey() == null) continue;
                this.addIfAbsent(e.getKey(), e.getValue());
            }
            return this;
        }

        default public <T extends Number> JsonObjectBuilder addAllNumbersIfAbsent(Iterable<Map.Entry<String, T>> iterable) {
            Objects.requireNonNull(iterable, "iterable");
            for (Map.Entry<String, T> e : iterable) {
                if (e == null || e.getKey() == null) continue;
                this.addIfAbsent(e.getKey(), (Number)e.getValue());
            }
            return this;
        }

        default public JsonObjectBuilder addAllBooleansIfAbsent(Iterable<Map.Entry<String, Boolean>> iterable) {
            Objects.requireNonNull(iterable, "iterable");
            for (Map.Entry<String, Boolean> e : iterable) {
                if (e == null || e.getKey() == null) continue;
                this.addIfAbsent(e.getKey(), e.getValue());
            }
            return this;
        }

        default public JsonObjectBuilder addAllCharactersIfAbsent(Iterable<Map.Entry<String, Character>> iterable) {
            Objects.requireNonNull(iterable, "iterable");
            for (Map.Entry<String, Character> e : iterable) {
                if (e == null || e.getKey() == null) continue;
                this.addIfAbsent(e.getKey(), e.getValue());
            }
            return this;
        }

        public JsonObject build();
    }
}

