/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.shop;

import com.lishid.openinv.OpenInv;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.data.type.Chest;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.event.ShopClickEvent;
import org.maxgamer.quickshop.event.ShopDeleteEvent;
import org.maxgamer.quickshop.event.ShopItemChangeEvent;
import org.maxgamer.quickshop.event.ShopLoadEvent;
import org.maxgamer.quickshop.event.ShopModeratorChangedEvent;
import org.maxgamer.quickshop.event.ShopPriceChangeEvent;
import org.maxgamer.quickshop.event.ShopSignUpdateEvent;
import org.maxgamer.quickshop.event.ShopTypeChangeEvent;
import org.maxgamer.quickshop.event.ShopUnloadEvent;
import org.maxgamer.quickshop.event.ShopUpdateEvent;
import org.maxgamer.quickshop.shade.io.papermc.lib.PaperLib;
import org.maxgamer.quickshop.shop.DisplayItem;
import org.maxgamer.quickshop.shop.InventoryPreview;
import org.maxgamer.quickshop.shop.RealDisplayItem;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.shop.ShopInfoStorage;
import org.maxgamer.quickshop.shop.ShopModerator;
import org.maxgamer.quickshop.shop.ShopType;
import org.maxgamer.quickshop.shop.VirtualDisplayItem;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.PriceLimiter;
import org.maxgamer.quickshop.util.Util;

public class ContainerShop
implements Shop {
    private static final String shopSignPrefix = "\u00a7d\u00a7o \u00a7r";
    private static final String shopSignPattern = "\u00a7d\u00a7o ";
    @NotNull
    private final Location location;
    private final QuickShop plugin;
    private final YamlConfiguration extra;
    private final UUID runtimeRandomUniqueId = UUID.randomUUID();
    @NotNull
    private ItemStack item;
    @Nullable
    private DisplayItem displayItem;
    private volatile boolean isLoaded = false;
    private volatile boolean isDeleted = false;
    private volatile boolean isLeftShop = false;
    private volatile boolean createBackup = false;
    private InventoryPreview inventoryPreview = null;
    private ShopModerator moderator;
    private double price;
    private ShopType shopType;
    private boolean unlimited;
    private volatile ContainerShop attachedShop;
    private volatile boolean isDisplayItemChanged = false;
    private volatile boolean dirty;

    private ContainerShop(@NotNull ContainerShop s) {
        Util.ensureThread(false);
        this.shopType = s.shopType;
        this.item = s.item.clone();
        this.location = s.location.clone();
        this.plugin = s.plugin;
        this.unlimited = s.unlimited;
        this.moderator = s.moderator.clone();
        this.price = s.price;
        this.isLoaded = s.isLoaded;
        this.isDeleted = s.isDeleted;
        this.createBackup = s.createBackup;
        this.extra = s.extra;
        this.dirty = true;
        this.inventoryPreview = null;
        this.initDisplayItem();
    }

    public ContainerShop(@NotNull QuickShop plugin, @NotNull Location location, double price, @NotNull ItemStack item, @NotNull ShopModerator moderator, boolean unlimited, @NotNull ShopType type, @NotNull YamlConfiguration extra) {
        ItemMeta meta;
        Util.ensureThread(false);
        this.location = location;
        this.price = price;
        this.moderator = moderator;
        this.item = item.clone();
        this.plugin = plugin;
        if (!plugin.isAllowStack()) {
            this.item.setAmount(1);
        }
        if (item.hasItemMeta() && (meta = item.getItemMeta()).hasDisplayName()) {
            Util.debugLog("Shop item display is: " + meta.getDisplayName());
            if (meta.getDisplayName().matches("\\{.*}")) {
                meta.setDisplayName(meta.getDisplayName());
                item.setItemMeta(meta);
                this.item.setItemMeta(meta);
            }
        }
        this.shopType = type;
        this.unlimited = unlimited;
        this.extra = extra;
        this.initDisplayItem();
        this.dirty = false;
    }

    private void initDisplayItem() {
        Util.ensureThread(false);
        if (this.plugin.isDisplay()) {
            switch (DisplayItem.getNowUsing()) {
                case UNKNOWN: {
                    Util.debugLog("Failed to create a ContainerShop displayItem, the type is unknown, fallback to RealDisplayItem");
                    this.displayItem = new RealDisplayItem(this);
                    break;
                }
                case REALITEM: {
                    this.displayItem = new RealDisplayItem(this);
                    break;
                }
                case VIRTUALITEM: {
                    this.displayItem = new VirtualDisplayItem(this);
                    break;
                }
                default: {
                    Util.debugLog("Warning: Failed to create a ContainerShop displayItem, the type we didn't know, fallback to RealDisplayItem");
                    this.displayItem = new RealDisplayItem(this);
                }
            }
        }
    }

    @Override
    public void add(@NotNull ItemStack item, int amount) {
        int stackSize;
        Util.ensureThread(false);
        if (this.unlimited) {
            return;
        }
        item = item.clone();
        int itemMaxStackSize = Util.getItemMaxStackSize(item.getType());
        Inventory inv = this.getInventory();
        for (int remains = amount; remains > 0; remains -= stackSize) {
            stackSize = Math.min(remains, itemMaxStackSize);
            item.setAmount(stackSize);
            Objects.requireNonNull(inv).addItem(new ItemStack[]{item});
        }
        this.setSignText();
    }

    @Override
    public boolean addStaff(@NotNull UUID player) {
        Util.ensureThread(false);
        this.setDirty();
        boolean result = this.moderator.addStaff(player);
        this.update();
        if (result) {
            Util.mainThreadRun(() -> this.plugin.getServer().getPluginManager().callEvent((Event)new ShopModeratorChangedEvent(this, this.moderator)));
        }
        return result;
    }

    @Override
    public void buy(@NotNull UUID buyer, @NotNull Inventory buyerInventory, @NotNull Location loc2Drop, int amount) {
        Util.ensureThread(false);
        if ((amount *= this.item.getAmount()) < 0) {
            this.sell(buyer, buyerInventory, loc2Drop, -amount);
        }
        ItemStack[] contents = buyerInventory.getContents();
        if (this.isUnlimited()) {
            for (int i = 0; amount > 0 && i < contents.length; ++i) {
                ItemStack stack = contents[i];
                if (stack == null || stack.getType() == Material.AIR || !this.matches(stack)) continue;
                int stackSize = Math.min(amount, stack.getAmount());
                stack.setAmount(stack.getAmount() - stackSize);
                amount -= stackSize;
            }
            buyerInventory.setContents(contents);
            this.setSignText();
            if (amount > 0) {
                this.plugin.getLogger().log(Level.WARNING, "Could not take all items from a players inventory on purchase! " + buyer + ", missing: " + amount + ", item: " + Util.getItemStackName(this.getItem()) + "!");
            }
        } else {
            Inventory chestInv = this.getInventory();
            for (int i = 0; amount > 0 && i < contents.length; ++i) {
                ItemStack item = contents[i];
                if (item == null || !this.matches(item)) continue;
                item = item.clone();
                int stackSize = Math.min(amount, item.getAmount());
                contents[i].setAmount(contents[i].getAmount() - stackSize);
                item.setAmount(stackSize);
                Objects.requireNonNull(chestInv).addItem(new ItemStack[]{item});
                amount -= stackSize;
            }
            buyerInventory.setContents(contents);
            this.setSignText();
            if (this.attachedShop != null) {
                this.attachedShop.setSignText();
            }
        }
    }

    @Override
    public void checkDisplay() {
        Util.ensureThread(false);
        if (!this.plugin.isDisplay() || !this.isLoaded || this.isDeleted()) {
            return;
        }
        this.updateAttachedShop();
        if (this.isLeftShop) {
            if (this.displayItem != null) {
                this.displayItem.remove();
            }
            if (this.attachedShop != null) {
                this.attachedShop.refresh();
            }
            return;
        }
        if (this.displayItem == null) {
            Util.debugLog("Warning: DisplayItem is null, this shouldn't happened...");
            StackTraceElement traceElements = Thread.currentThread().getStackTrace()[2];
            Util.debugLog("Call from: " + traceElements.getClassName() + "#" + traceElements.getMethodName() + "%" + traceElements.getLineNumber());
            return;
        }
        if (!this.displayItem.isSpawned()) {
            this.displayItem.spawn();
        } else if (this.displayItem.checkDisplayNeedRegen()) {
            this.displayItem.fixDisplayNeedRegen();
        } else if (this.displayItem.checkDisplayIsMoved()) {
            this.displayItem.fixDisplayMoved();
        }
        this.displayItem.removeDupe();
    }

    @Override
    public void clearStaffs() {
        this.setDirty();
        this.moderator.clearStaffs();
        Util.mainThreadRun(() -> this.plugin.getServer().getPluginManager().callEvent((Event)new ShopModeratorChangedEvent(this, this.moderator)));
        this.update();
    }

    @Override
    public boolean delStaff(@NotNull UUID player) {
        Util.ensureThread(false);
        this.setDirty();
        boolean result = this.moderator.delStaff(player);
        this.update();
        if (result) {
            Util.mainThreadRun(() -> this.plugin.getServer().getPluginManager().callEvent((Event)new ShopModeratorChangedEvent(this, this.moderator)));
        }
        return result;
    }

    @Override
    public void delete() {
        Util.ensureThread(false);
        this.delete(false);
    }

    @Override
    public void delete(boolean memoryOnly) {
        Util.ensureThread(false);
        ContainerShop neighbor = this.getAttachedShop();
        this.setDirty();
        ShopDeleteEvent shopDeleteEvent = new ShopDeleteEvent(this, memoryOnly);
        if (Util.fireCancellableEvent(shopDeleteEvent)) {
            Util.debugLog("Shop deletion was canceled because a plugin canceled it.");
            return;
        }
        this.isDeleted = true;
        if (this.isLoaded) {
            this.onUnload();
        }
        if (memoryOnly) {
            this.plugin.getShopManager().removeShop(this);
        } else {
            for (Sign s : this.getSigns()) {
                s.getBlock().setType(Material.AIR);
            }
            if (this.plugin.getConfig().getBoolean("shop.refund")) {
                this.plugin.getEconomy().deposit(this.getOwner(), this.plugin.getConfig().getDouble("shop.cost"), Objects.requireNonNull(this.getLocation().getWorld()), this.getCurrency());
            }
            this.plugin.getShopManager().removeShop(this);
            this.plugin.getDatabaseHelper().removeShop(this);
            this.plugin.getShopLoader().removeShopFromShopLoader(this);
        }
        if (neighbor != null) {
            neighbor.refresh();
        }
    }

    @Override
    public boolean isAttached(@NotNull Block b) {
        Util.ensureThread(false);
        return this.getLocation().getBlock().equals(Util.getAttached(b));
    }

    @Override
    public boolean matches(@Nullable ItemStack item) {
        return this.plugin.getItemMatcher().matches(this.item, item);
    }

    @Override
    public void onClick() {
        Util.ensureThread(false);
        ShopClickEvent event = new ShopClickEvent(this);
        if (Util.fireCancellableEvent(event)) {
            Util.debugLog("Ignore shop click, because some plugin cancel it.");
            return;
        }
        this.refresh();
        this.setSignText();
    }

    @NotNull
    public Material getMaterial() {
        return this.item.getType();
    }

    @Override
    public void onUnload() {
        Util.ensureThread(false);
        if (!this.isLoaded) {
            Util.debugLog("Dupe unload request, canceled.");
            return;
        }
        if (this.inventoryPreview != null) {
            this.inventoryPreview.close();
        }
        if (this.displayItem != null) {
            this.displayItem.remove();
        }
        this.update();
        this.isLoaded = false;
        this.plugin.getShopManager().getLoadedShops().remove(this);
        ShopUnloadEvent shopUnloadEvent = new ShopUnloadEvent(this);
        this.plugin.getServer().getPluginManager().callEvent((Event)shopUnloadEvent);
    }

    @Override
    @NotNull
    public String ownerName(boolean forceUsername) {
        OfflinePlayer player = this.plugin.getServer().getOfflinePlayer(this.getOwner());
        String name = player.getName();
        if (name == null || name.isEmpty()) {
            name = MsgUtil.getMessageOfflinePlayer("unknown-owner", player, new String[0]);
        }
        if (forceUsername) {
            return name;
        }
        if (this.isUnlimited()) {
            return MsgUtil.getMessageOfflinePlayer("admin-shop", player, new String[0]);
        }
        return name;
    }

    @Override
    @NotNull
    public String ownerName() {
        return this.ownerName(false);
    }

    @Override
    public void remove(@NotNull ItemStack item, int amount) {
        int stackSize;
        Util.ensureThread(false);
        if (this.unlimited) {
            return;
        }
        item = item.clone();
        int itemMaxStackSize = Util.getItemMaxStackSize(item.getType());
        Inventory inv = this.getInventory();
        for (int remains = amount; remains > 0; remains -= stackSize) {
            stackSize = Math.min(remains, itemMaxStackSize);
            item.setAmount(stackSize);
            Objects.requireNonNull(inv).removeItem(new ItemStack[]{item});
        }
        this.setSignText();
    }

    @Override
    public void sell(@NotNull UUID seller, @NotNull Inventory sellerInventory, @NotNull Location loc2Drop, int amount) {
        Util.ensureThread(false);
        amount = this.item.getAmount() * amount;
        if (amount < 0) {
            this.buy(seller, sellerInventory, loc2Drop, -amount);
        }
        ArrayList floor = new ArrayList(5);
        int itemMaxStackSize = Util.getItemMaxStackSize(this.item.getType());
        if (this.isUnlimited()) {
            ItemStack item = this.item.clone();
            while (amount > 0) {
                int stackSize = Math.min(amount, itemMaxStackSize);
                item.setAmount(stackSize);
                sellerInventory.addItem(new ItemStack[]{item});
                amount -= stackSize;
            }
        } else {
            ItemStack[] chestContents = Objects.requireNonNull(this.getInventory()).getContents();
            for (int i = 0; amount > 0 && i < chestContents.length; ++i) {
                ItemStack item = chestContents[i];
                if (item == null || item.getType() == Material.AIR || !this.matches(item)) continue;
                item = item.clone();
                int stackSize = Math.min(amount, item.getAmount());
                chestContents[i].setAmount(chestContents[i].getAmount() - stackSize);
                item.setAmount(stackSize);
                floor.addAll(sellerInventory.addItem(new ItemStack[]{item}).values());
                amount -= stackSize;
            }
            this.getInventory().setContents(chestContents);
            this.setSignText();
            if (this.attachedShop != null) {
                this.attachedShop.setSignText();
            }
        }
        if (loc2Drop != null) {
            for (ItemStack stack : floor) {
                loc2Drop.getWorld().dropItem(loc2Drop, stack);
            }
        }
    }

    public boolean inventoryAvailable() {
        if (this.isUnlimited()) {
            return true;
        }
        if (this.isSelling()) {
            return this.getRemainingStock() > 0;
        }
        if (this.isBuying()) {
            return this.getRemainingSpace() > 0;
        }
        return true;
    }

    @Override
    public String[] getSignText() {
        String noRemainingStringKey;
        String tradingStringKey;
        int shopRemaining;
        Util.ensureThread(false);
        String[] lines = new String[4];
        OfflinePlayer player = this.plugin.getServer().getOfflinePlayer(this.getOwner());
        String statusStringKey = this.inventoryAvailable() ? "signs.status-available" : "signs.status-unavailable";
        lines[0] = MsgUtil.getMessageOfflinePlayer("signs.header", null, this.ownerName(false), MsgUtil.getMessageOfflinePlayer(statusStringKey, null, new String[0]));
        switch (this.shopType) {
            case BUYING: {
                shopRemaining = this.getRemainingSpace();
                tradingStringKey = this.isStackingShop() ? "signs.stack-buying" : "signs.buying";
                noRemainingStringKey = "signs.out-of-space";
                break;
            }
            case SELLING: {
                shopRemaining = this.getRemainingStock();
                tradingStringKey = this.isStackingShop() ? "signs.stack-selling" : "signs.selling";
                noRemainingStringKey = "signs.out-of-stock";
                break;
            }
            default: {
                shopRemaining = 0;
                tradingStringKey = "MissingKey for shop type:" + (Object)((Object)this.shopType);
                noRemainingStringKey = "MissingKey for shop type:" + (Object)((Object)this.shopType);
            }
        }
        switch (shopRemaining) {
            case -1: {
                lines[1] = MsgUtil.getMessageOfflinePlayer(tradingStringKey, player, MsgUtil.getMessageOfflinePlayer("signs.unlimited", player, new String[0]));
                break;
            }
            case 0: {
                lines[1] = MsgUtil.getMessageOfflinePlayer(noRemainingStringKey, player, new String[0]);
                break;
            }
            default: {
                lines[1] = MsgUtil.getMessageOfflinePlayer(tradingStringKey, player, Integer.toString(shopRemaining));
            }
        }
        lines[2] = MsgUtil.getMessageOfflinePlayer("signs.item", player, Util.getItemStackName(this.getItem()));
        lines[3] = this.isStackingShop() ? MsgUtil.getMessageOfflinePlayer("signs.stack-price", player, Util.format(this.getPrice(), this), Integer.toString(this.item.getAmount()), Util.getItemStackName(this.item)) : MsgUtil.getMessageOfflinePlayer("signs.price", player, Util.format(this.getPrice(), this));
        lines[1] = shopSignPrefix + lines[1] + " ";
        return lines;
    }

    @Override
    public void setSignText(@NotNull String[] lines) {
        Util.ensureThread(false);
        List<Sign> signs = this.getSigns();
        for (Sign sign : signs) {
            DyeColor dyeColor;
            if (Arrays.equals(sign.getLines(), lines)) continue;
            for (int i = 0; i < lines.length; ++i) {
                sign.setLine(i, lines[i]);
            }
            if (this.plugin.getGameVersion().isSignTextDyeSupport() && (dyeColor = Util.getDyeColor()) != null) {
                sign.setColor(dyeColor);
            }
            if (this.plugin.getGameVersion().isSignGlowingSupport()) {
                boolean isGlowing = this.plugin.getConfig().getBoolean("shop.sign-glowing");
                sign.setGlowingText(isGlowing);
            }
            sign.update(true);
            this.plugin.getServer().getPluginManager().callEvent((Event)new ShopSignUpdateEvent(this, sign));
        }
    }

    @Override
    public void setSignText() {
        Util.ensureThread(false);
        if (!Util.isLoaded(this.location)) {
            return;
        }
        this.setSignText(this.getSignText());
    }

    @Override
    public synchronized void update() {
        Util.mainThreadRun(this::update0);
    }

    private void notifyDisplayItemChange() {
        this.isDisplayItemChanged = true;
        if (this.attachedShop != null && !this.attachedShop.isDisplayItemChanged) {
            this.attachedShop.notifyDisplayItemChange();
        }
    }

    private synchronized void update0() {
        Util.ensureThread(false);
        ShopUpdateEvent shopUpdateEvent = new ShopUpdateEvent(this);
        if (Util.fireCancellableEvent(shopUpdateEvent)) {
            Util.debugLog("The Shop update action was canceled by a plugin.");
            return;
        }
        int x = this.getLocation().getBlockX();
        int y = this.getLocation().getBlockY();
        int z = this.getLocation().getBlockZ();
        String world = Objects.requireNonNull(this.getLocation().getWorld()).getName();
        int unlimited = this.isUnlimited() ? 1 : 0;
        try {
            this.plugin.getDatabaseHelper().updateShop(ShopModerator.serialize(this.moderator.clone()), this.getItem(), unlimited, this.shopType.toID(), this.getPrice(), x, y, z, world, this.saveExtraToYaml());
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Could not update a shop in the database! Changes will revert after a reboot!", e);
        }
        this.dirty = false;
    }

    @Override
    public short getDurability() {
        return (short)((Damageable)this.item.getItemMeta()).getDamage();
    }

    @Override
    @NotNull
    public ItemStack getItem() {
        return this.item;
    }

    @Override
    public void setItem(@NotNull ItemStack item) {
        Util.ensureThread(false);
        ShopItemChangeEvent event = new ShopItemChangeEvent(this, this.item, item);
        if (Util.fireCancellableEvent(event)) {
            Util.debugLog("A plugin cancelled the item change event.");
            return;
        }
        this.item = item;
        this.notifyDisplayItemChange();
        this.update();
        this.refresh();
    }

    @Override
    public void refresh() {
        Util.ensureThread(false);
        if (this.inventoryPreview != null) {
            this.inventoryPreview.close();
            this.inventoryPreview = null;
        }
        if (this.displayItem != null) {
            this.displayItem.remove();
        }
        if (this.plugin.isDisplay()) {
            if (this.displayItem != null) {
                this.displayItem.remove();
            }
            this.updateAttachedShop();
            if (this.isDisplayItemChanged) {
                this.initDisplayItem();
                this.isDisplayItemChanged = false;
            }
            if (this.attachedShop != null && this.attachedShop.isDisplayItemChanged) {
                this.attachedShop.refresh();
            }
            if (!this.isLeftShop) {
                this.displayItem.spawn();
            }
        }
        this.setSignText();
    }

    @Override
    public void onLoad() {
        Util.ensureThread(false);
        if (this.isLoaded) {
            Util.debugLog("Dupe load request, canceled.");
            return;
        }
        ShopLoadEvent shopLoadEvent = new ShopLoadEvent(this);
        if (Util.fireCancellableEvent(shopLoadEvent)) {
            return;
        }
        this.isLoaded = true;
        this.plugin.getShopManager().getLoadedShops().add(this);
        this.plugin.getShopContainerWatcher().scheduleCheck(this);
        PriceLimiter.CheckResult priceRestriction = this.plugin.getShopManager().getPriceLimiter().check(this.item, this.price);
        if (priceRestriction.getStatus() != PriceLimiter.Status.PASS) {
            if (priceRestriction.getStatus() == PriceLimiter.Status.NOT_A_WHOLE_NUMBER) {
                this.setDirty();
                this.price = Math.floor(this.price);
                this.update();
            } else if (priceRestriction.getStatus() == PriceLimiter.Status.NOT_VALID) {
                this.setDirty();
                this.price = priceRestriction.getMin();
                this.update();
            }
            if (this.price < priceRestriction.getMin()) {
                this.setDirty();
                this.price = priceRestriction.getMin();
                this.update();
            } else if (this.price > priceRestriction.getMax()) {
                this.setDirty();
                this.price = priceRestriction.getMax();
                this.update();
            }
        }
        this.checkDisplay();
    }

    @Override
    @NotNull
    public Location getLocation() {
        return this.location;
    }

    @Override
    @NotNull
    public ShopModerator getModerator() {
        return this.moderator;
    }

    @Override
    public void setModerator(@NotNull ShopModerator shopModerator) {
        Util.ensureThread(false);
        this.setDirty();
        this.moderator = shopModerator;
        this.update();
        this.plugin.getServer().getPluginManager().callEvent((Event)new ShopModeratorChangedEvent(this, this.moderator));
    }

    @Override
    @NotNull
    public UUID getOwner() {
        return this.moderator.getOwner();
    }

    @Override
    public void setOwner(@NotNull UUID owner) {
        Util.ensureThread(false);
        this.moderator.setOwner(owner);
        this.setSignText();
        this.update();
        this.plugin.getServer().getPluginManager().callEvent((Event)new ShopModeratorChangedEvent(this, this.moderator));
    }

    @Override
    public double getPrice() {
        return this.price;
    }

    @Override
    public void setPrice(double price) {
        Util.ensureThread(false);
        ShopPriceChangeEvent event = new ShopPriceChangeEvent(this, this.price, price);
        if (Util.fireCancellableEvent(event)) {
            Util.debugLog("A plugin cancelled the price change event.");
            return;
        }
        this.setDirty();
        this.price = price;
        this.setSignText();
        this.update();
    }

    @Override
    public int getRemainingSpace() {
        Util.ensureThread(false);
        if (this.unlimited) {
            return -1;
        }
        return Util.countSpace(this.getInventory(), this.getItem());
    }

    @Override
    public int getRemainingStock() {
        Util.ensureThread(false);
        if (this.unlimited) {
            return -1;
        }
        return Util.countItems(this.getInventory(), this.getItem());
    }

    @Override
    @NotNull
    public ShopType getShopType() {
        return this.shopType;
    }

    @Override
    public void setShopType(@NotNull ShopType newShopType) {
        Util.ensureThread(false);
        if (this.shopType == newShopType) {
            return;
        }
        this.setDirty();
        if (Util.fireCancellableEvent(new ShopTypeChangeEvent(this, this.shopType, newShopType))) {
            Util.debugLog("Some addon cancelled shop type changes, target shop: " + this);
            return;
        }
        this.shopType = newShopType;
        this.setSignText();
        this.update();
    }

    @Override
    @NotNull
    public List<Sign> getSigns() {
        Util.ensureThread(false);
        ArrayList<Sign> signs = new ArrayList<Sign>(4);
        if (this.getLocation().getWorld() == null) {
            return Collections.emptyList();
        }
        Block[] blocks = new Block[]{this.location.getBlock().getRelative(BlockFace.EAST), this.location.getBlock().getRelative(BlockFace.NORTH), this.location.getBlock().getRelative(BlockFace.SOUTH), this.location.getBlock().getRelative(BlockFace.WEST)};
        for (Block b : blocks) {
            BlockState state;
            if (b == null || !((state = PaperLib.getBlockState(b, false).getState()) instanceof Sign) || !this.isAttached(b)) continue;
            Sign sign = (Sign)state;
            String[] lines = sign.getLines();
            if (lines[0].isEmpty() && lines[1].isEmpty() && lines[2].isEmpty() && lines[3].isEmpty()) {
                signs.add(sign);
                continue;
            }
            if (lines[1].startsWith(shopSignPattern)) {
                signs.add(sign);
                continue;
            }
            String header = lines[0];
            String adminShopHeader = MsgUtil.getMessage("signs.header", null, MsgUtil.getMessage("admin-shop", null, new String[0]));
            String signHeaderUsername = MsgUtil.getMessage("signs.header", null, this.ownerName(true));
            if (header.contains(adminShopHeader) || header.contains(signHeaderUsername)) {
                signs.add(sign);
                continue;
            }
            adminShopHeader = MsgUtil.getMessage("signs.header", null, MsgUtil.getMessage("admin-shop", null, new String[0]), "");
            signHeaderUsername = MsgUtil.getMessage("signs.header", null, this.ownerName(true), "");
            adminShopHeader = ChatColor.stripColor((String)adminShopHeader).trim();
            signHeaderUsername = ChatColor.stripColor((String)signHeaderUsername).trim();
            if (!header.contains(adminShopHeader) && !header.contains(signHeaderUsername)) continue;
            signs.add(sign);
        }
        return signs;
    }

    @Override
    @NotNull
    public List<UUID> getStaffs() {
        return new ArrayList<UUID>(this.moderator.getStaffs());
    }

    @Override
    public boolean isBuying() {
        return this.shopType == ShopType.BUYING;
    }

    @Override
    public boolean isLoaded() {
        return this.isLoaded;
    }

    @Override
    public boolean isSelling() {
        return this.shopType == ShopType.SELLING;
    }

    @Override
    public boolean isUnlimited() {
        return this.unlimited;
    }

    @Override
    public void setUnlimited(boolean unlimited) {
        Util.ensureThread(false);
        this.unlimited = unlimited;
        this.setSignText();
        this.update();
    }

    @Override
    public boolean isValid() {
        Util.ensureThread(false);
        if (this.isDeleted) {
            return false;
        }
        return Util.canBeShop(this.getLocation().getBlock());
    }

    @Override
    public boolean isDeleted() {
        return this.isDeleted;
    }

    @Override
    @Nullable
    public DisplayItem getDisplay() {
        return this.displayItem;
    }

    @Override
    public void setDirty() {
        this.dirty = true;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean isDirty) {
        this.dirty = isDirty;
    }

    @Override
    @NotNull
    public ContainerShop clone() {
        return new ContainerShop(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Shop ").append(this.location.getWorld() == null ? "unloaded world" : this.location.getWorld().getName()).append("(").append(this.location.getBlockX()).append(", ").append(this.location.getBlockY()).append(", ").append(this.location.getBlockZ()).append(")");
        sb.append(" Owner: ").append(this.ownerName(false)).append(" - ").append(this.getOwner());
        if (this.isUnlimited()) {
            sb.append(" Unlimited: true");
        }
        sb.append(" Price: ").append(this.getPrice());
        return sb.toString();
    }

    @Nullable
    public DisplayItem getDisplayItem() {
        return this.displayItem;
    }

    @NotNull
    public Map<Enchantment, Integer> getEnchants() {
        if (this.item.hasItemMeta() && this.item.getItemMeta().hasEnchants()) {
            return Objects.requireNonNull(this.item.getItemMeta()).getEnchants();
        }
        return Collections.emptyMap();
    }

    @Nullable
    public Inventory getInventory() {
        Util.ensureThread(false);
        BlockState state = PaperLib.getBlockState(this.location.getBlock(), false).getState();
        try {
            if (state.getType() == Material.ENDER_CHEST && this.plugin.getOpenInvPlugin() != null) {
                OpenInv openInv = (OpenInv)this.plugin.getOpenInvPlugin();
                return openInv.getSpecialEnderChest(Objects.requireNonNull(openInv.loadPlayer(this.plugin.getServer().getOfflinePlayer(this.moderator.getOwner()))), this.plugin.getServer().getOfflinePlayer(this.moderator.getOwner()).isOnline()).getBukkitInventory();
            }
        }
        catch (Exception e) {
            Util.debugLog(e.getMessage());
            return null;
        }
        try {
            InventoryHolder container = (InventoryHolder)state;
            return container.getInventory();
        }
        catch (Exception e) {
            if (!this.createBackup) {
                this.createBackup = Util.backupDatabase();
                if (this.createBackup) {
                    this.plugin.log("Deleting shop " + this + " request by invalid inventory.");
                    this.delete();
                    Util.debugLog("Inventory doesn't exist anymore: " + this + " shop was removed.");
                }
            } else {
                this.plugin.log("Deleting shop " + this + " request by invalid inventory.");
                this.delete();
                Util.debugLog("Inventory doesn't exist anymore: " + this + " shop was removed.");
            }
            return null;
        }
    }

    public boolean isDoubleShop() {
        Util.ensureThread(false);
        if (this.attachedShop == null) {
            return false;
        }
        if (this.attachedShop.matches(this.getItem())) {
            return this.getShopType() != this.attachedShop.getShopType();
        }
        return false;
    }

    @Override
    public void updateAttachedShop() {
        Util.ensureThread(false);
        Block attachedChest = Util.getSecondHalf(this.getLocation().getBlock());
        ContainerShop preValue = this.attachedShop;
        this.attachedShop = attachedChest == null ? null : (ContainerShop)this.plugin.getShopManager().getShop(attachedChest.getLocation());
        if (this.attachedShop != null && this.attachedShop.matches(this.getItem())) {
            this.updateLeftShop();
        } else {
            this.isLeftShop = false;
        }
        if (!Objects.equals(this.attachedShop, preValue)) {
            this.notifyDisplayItemChange();
        }
    }

    private void updateLeftShop() {
        if (this.attachedShop == null) {
            return;
        }
        boolean previousValue = this.isLeftShop;
        switch (((Chest)this.getLocation().getBlock().getBlockData()).getFacing()) {
            case WEST: {
                this.isLeftShop = this.getLocation().getZ() < this.attachedShop.getLocation().getZ();
                break;
            }
            case EAST: {
                this.isLeftShop = this.getLocation().getZ() > this.attachedShop.getLocation().getZ();
                break;
            }
            case NORTH: {
                this.isLeftShop = this.getLocation().getX() > this.attachedShop.getLocation().getX();
                break;
            }
            case SOUTH: {
                this.isLeftShop = this.getLocation().getX() < this.attachedShop.getLocation().getX();
                break;
            }
            default: {
                this.isLeftShop = false;
            }
        }
        if (this.isLeftShop != previousValue) {
            this.notifyDisplayItemChange();
        }
    }

    @Override
    public boolean isRealDouble() {
        Util.ensureThread(false);
        if (this.attachedShop == null) {
            return false;
        }
        return this.attachedShop.matches(this.getItem());
    }

    @Override
    public boolean isLeftShop() {
        return this.isLeftShop;
    }

    @Override
    public ContainerShop getAttachedShop() {
        return this.attachedShop;
    }

    public boolean isDoubleChestShop() {
        Util.ensureThread(false);
        return Util.isDoubleChest(this.getLocation().getBlock().getBlockData());
    }

    public void checkContainer() {
        Util.ensureThread(false);
        if (!this.isLoaded) {
            return;
        }
        if (!Util.isLoaded(this.getLocation())) {
            return;
        }
        if (!Util.canBeShop(this.getLocation().getBlock())) {
            Util.debugLog("Shop at " + this.getLocation() + "@" + this.getLocation().getBlock() + " container was missing, unload from memory...");
            this.onUnload();
            this.delete(true);
        }
    }

    @Override
    @NotNull
    public String saveExtraToYaml() {
        return this.extra.saveToString();
    }

    @Override
    @NotNull
    public ConfigurationSection getExtra(@NotNull Plugin plugin) {
        ConfigurationSection section = this.extra.getConfigurationSection(plugin.getName());
        if (section == null) {
            section = this.extra.createSection(plugin.getName());
        }
        return section;
    }

    @Override
    public void setExtra(@NotNull Plugin plugin, @NotNull ConfigurationSection data) {
        this.setDirty();
        this.update();
    }

    @Override
    public boolean isStackingShop() {
        return this.plugin.isAllowStack() && this.item.getAmount() > 1;
    }

    @Override
    @NotNull
    public UUID getRuntimeRandomUniqueId() {
        return this.runtimeRandomUniqueId;
    }

    @Override
    @Nullable
    public String getCurrency() {
        ConfigurationSection section = this.getExtra((Plugin)this.plugin);
        return section.getString("currency");
    }

    @Override
    public void setCurrency(@Nullable String currency) {
        ConfigurationSection section = this.getExtra((Plugin)this.plugin);
        section.set("currency", (Object)currency);
        this.setExtra((Plugin)this.plugin, section);
        this.setDirty();
        this.update();
    }

    @Override
    public void openPreview(@NotNull Player player) {
        if (this.inventoryPreview == null) {
            this.inventoryPreview = new InventoryPreview(this.plugin, this.getItem(), player);
        }
        this.inventoryPreview.show();
    }

    @Override
    public ShopInfoStorage saveToInfoStorage() {
        return new ShopInfoStorage(ShopModerator.serialize(this.getModerator()), this.getPrice(), Util.serialize(this.getItem()), this.isUnlimited() ? 1 : 0, this.getShopType().toID(), this.saveExtraToYaml());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainerShop)) {
            return false;
        }
        ContainerShop other = (ContainerShop)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getPrice(), other.getPrice()) != 0) {
            return false;
        }
        if (this.isUnlimited() != other.isUnlimited()) {
            return false;
        }
        Location this$location = this.getLocation();
        Location other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        YamlConfiguration this$extra = this.extra;
        YamlConfiguration other$extra = other.extra;
        if (this$extra == null ? other$extra != null : !this$extra.equals(other$extra)) {
            return false;
        }
        ItemStack this$item = this.getItem();
        ItemStack other$item = other.getItem();
        if (this$item == null ? other$item != null : !this$item.equals(other$item)) {
            return false;
        }
        DisplayItem this$displayItem = this.getDisplayItem();
        DisplayItem other$displayItem = other.getDisplayItem();
        if (this$displayItem == null ? other$displayItem != null : !this$displayItem.equals(other$displayItem)) {
            return false;
        }
        ShopModerator this$moderator = this.getModerator();
        ShopModerator other$moderator = other.getModerator();
        if (this$moderator == null ? other$moderator != null : !((Object)this$moderator).equals(other$moderator)) {
            return false;
        }
        ShopType this$shopType = this.getShopType();
        ShopType other$shopType = other.getShopType();
        return !(this$shopType == null ? other$shopType != null : !((Object)((Object)this$shopType)).equals((Object)other$shopType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContainerShop;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $price = Double.doubleToLongBits(this.getPrice());
        result = result * 59 + (int)($price >>> 32 ^ $price);
        result = result * 59 + (this.isUnlimited() ? 79 : 97);
        Location $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        YamlConfiguration $extra = this.extra;
        result = result * 59 + ($extra == null ? 43 : $extra.hashCode());
        ItemStack $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : $item.hashCode());
        DisplayItem $displayItem = this.getDisplayItem();
        result = result * 59 + ($displayItem == null ? 43 : $displayItem.hashCode());
        ShopModerator $moderator = this.getModerator();
        result = result * 59 + ($moderator == null ? 43 : ((Object)$moderator).hashCode());
        ShopType $shopType = this.getShopType();
        result = result * 59 + ($shopType == null ? 43 : ((Object)((Object)$shopType)).hashCode());
        return result;
    }
}

