/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.shop;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.shop.DisplayItem;
import org.maxgamer.quickshop.shop.RealDisplayItem;
import org.maxgamer.quickshop.shop.VirtualDisplayItem;

public enum DisplayType {
    UNKNOWN(-1),
    REALITEM(0),
    VIRTUALITEM(2);

    private static final Map<Integer, DisplayType> displayTypeMap;
    private final int id;

    private DisplayType(int id) {
        this.id = id;
    }

    @NotNull
    public static DisplayType fromID(int id) {
        return displayTypeMap.getOrDefault(id, UNKNOWN);
    }

    public static int toID(@NotNull DisplayType displayType) {
        return displayType.id;
    }

    public static DisplayType typeIs(@Nullable DisplayItem displayItem) {
        if (displayItem instanceof RealDisplayItem) {
            return REALITEM;
        }
        if (displayItem instanceof VirtualDisplayItem) {
            return VIRTUALITEM;
        }
        return UNKNOWN;
    }

    public int toID() {
        return this.id;
    }

    static {
        HashMap<Integer, DisplayType> map = new HashMap<Integer, DisplayType>(DisplayType.values().length);
        for (DisplayType type : DisplayType.values()) {
            map.put(type.id, type);
        }
        displayTypeMap = Collections.unmodifiableMap(map);
    }
}

