/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.shop;

import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.shop.ShopAction;

public class Info {
    private final Block last;
    private final Location loc;
    private final boolean dirty;
    private ShopAction action;
    private ItemStack item;
    private Shop shop;

    public Info(@NotNull Location loc, @NotNull ShopAction action, @Nullable ItemStack item, @Nullable Block last) {
        this.loc = loc;
        this.action = action;
        this.last = last;
        if (item != null) {
            this.item = item.clone();
        }
        this.dirty = true;
    }

    public Info(@NotNull Location loc, @NotNull ShopAction action, @Nullable ItemStack item, @Nullable Block last, @Nullable Shop shop) {
        this.loc = loc;
        this.action = action;
        this.last = last;
        if (item != null) {
            this.item = item.clone();
        }
        if (shop != null) {
            this.shop = shop.clone();
            this.dirty = shop.isDirty();
        } else {
            this.dirty = true;
        }
    }

    @NotNull
    public ShopAction getAction() {
        return this.action;
    }

    public void setAction(@NotNull ShopAction action) {
        this.action = action;
    }

    @NotNull
    public ItemStack getItem() {
        return this.item;
    }

    @NotNull
    public Location getLocation() {
        return this.loc;
    }

    @Nullable
    public Block getSignBlock() {
        return this.last;
    }

    boolean hasChanged(@NotNull Shop shop) {
        if (this.shop.isUnlimited() != shop.isUnlimited()) {
            return true;
        }
        if (this.shop.getShopType() != shop.getShopType()) {
            return true;
        }
        if (!this.shop.getOwner().equals(shop.getOwner())) {
            return true;
        }
        if (this.shop.getPrice() != shop.getPrice()) {
            return true;
        }
        if (!this.shop.getLocation().equals((Object)shop.getLocation())) {
            return true;
        }
        if (this.dirty != shop.isDirty()) {
            return false;
        }
        return !this.shop.matches(shop.getItem());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Info)) {
            return false;
        }
        Info other = (Info)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.dirty != other.dirty) {
            return false;
        }
        Block this$last = this.last;
        Block other$last = other.last;
        if (this$last == null ? other$last != null : !this$last.equals(other$last)) {
            return false;
        }
        Location this$loc = this.loc;
        Location other$loc = other.loc;
        if (this$loc == null ? other$loc != null : !this$loc.equals(other$loc)) {
            return false;
        }
        ShopAction this$action = this.getAction();
        ShopAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        ItemStack this$item = this.getItem();
        ItemStack other$item = other.getItem();
        if (this$item == null ? other$item != null : !this$item.equals(other$item)) {
            return false;
        }
        Shop this$shop = this.shop;
        Shop other$shop = other.shop;
        return !(this$shop == null ? other$shop != null : !this$shop.equals(other$shop));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Info;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.dirty ? 79 : 97);
        Block $last = this.last;
        result = result * 59 + ($last == null ? 43 : $last.hashCode());
        Location $loc = this.loc;
        result = result * 59 + ($loc == null ? 43 : $loc.hashCode());
        ShopAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        ItemStack $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : $item.hashCode());
        Shop $shop = this.shop;
        result = result * 59 + ($shop == null ? 43 : $shop.hashCode());
        return result;
    }

    public String toString() {
        return "Info(last=" + this.last + ", loc=" + this.loc + ", dirty=" + this.dirty + ", action=" + (Object)((Object)this.getAction()) + ", item=" + this.getItem() + ", shop=" + this.shop + ")";
    }
}

