/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.shop;

import java.util.ArrayList;
import java.util.Collections;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.event.ShopInventoryPreviewEvent;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.Util;
import org.maxgamer.quickshop.util.holder.QuickShopPreviewInventoryHolder;

public class InventoryPreview
implements Listener {
    private final ItemStack itemStack;
    private final Player player;
    private final QuickShop plugin = QuickShop.getInstance();
    @Nullable
    private Inventory inventory;

    public InventoryPreview(@NotNull QuickShop plugin, @NotNull ItemStack itemStack, @NotNull Player player) {
        Util.ensureThread(false);
        this.itemStack = itemStack.clone();
        this.player = player;
        ItemMeta itemMeta = itemStack.hasItemMeta() ? this.itemStack.getItemMeta() : plugin.getServer().getItemFactory().getItemMeta(itemStack.getType());
        if (itemMeta != null) {
            if (itemMeta.hasLore()) {
                itemMeta.getLore().add(plugin.getPreviewProtectionLore());
            } else {
                itemMeta.setLore(Collections.singletonList(plugin.getPreviewProtectionLore()));
            }
            this.itemStack.setItemMeta(itemMeta);
        }
    }

    @Deprecated
    public static boolean isPreviewItem(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (!stack.hasItemMeta() || !stack.getItemMeta().hasLore()) {
            return false;
        }
        for (String string : stack.getItemMeta().getLore()) {
            if (!QuickShop.instance.getPreviewProtectionLore().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void show() {
        Util.ensureThread(false);
        if (this.itemStack == null || this.player == null || this.player.isSleeping()) {
            return;
        }
        ShopInventoryPreviewEvent shopInventoryPreview = new ShopInventoryPreviewEvent(this.player, this.itemStack);
        if (Util.fireCancellableEvent(shopInventoryPreview)) {
            Util.debugLog("Inventory preview was canceled by a plugin.");
            return;
        }
        int size = 9;
        this.inventory = this.plugin.getServer().createInventory((InventoryHolder)new QuickShopPreviewInventoryHolder(), 9, MsgUtil.getMessage("menu.preview", (CommandSender)this.player, new String[0]));
        for (int i = 0; i < 9; ++i) {
            this.inventory.setItem(i, this.itemStack);
        }
        this.player.openInventory(this.inventory);
    }

    public void close() {
        Util.ensureThread(false);
        if (this.inventory == null) {
            return;
        }
        for (HumanEntity player : new ArrayList(this.inventory.getViewers())) {
            player.closeInventory();
        }
        this.inventory = null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InventoryPreview)) {
            return false;
        }
        InventoryPreview other = (InventoryPreview)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ItemStack this$itemStack = this.itemStack;
        ItemStack other$itemStack = other.itemStack;
        if (this$itemStack == null ? other$itemStack != null : !this$itemStack.equals(other$itemStack)) {
            return false;
        }
        Player this$player = this.player;
        Player other$player = other.player;
        if (this$player == null ? other$player != null : !this$player.equals(other$player)) {
            return false;
        }
        QuickShop this$plugin = this.plugin;
        QuickShop other$plugin = other.plugin;
        if (this$plugin == null ? other$plugin != null : !((Object)((Object)this$plugin)).equals((Object)other$plugin)) {
            return false;
        }
        Inventory this$inventory = this.inventory;
        Inventory other$inventory = other.inventory;
        return !(this$inventory == null ? other$inventory != null : !this$inventory.equals(other$inventory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InventoryPreview;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ItemStack $itemStack = this.itemStack;
        result = result * 59 + ($itemStack == null ? 43 : $itemStack.hashCode());
        Player $player = this.player;
        result = result * 59 + ($player == null ? 43 : $player.hashCode());
        QuickShop $plugin = this.plugin;
        result = result * 59 + ($plugin == null ? 43 : ((Object)((Object)$plugin)).hashCode());
        Inventory $inventory = this.inventory;
        result = result * 59 + ($inventory == null ? 43 : $inventory.hashCode());
        return result;
    }

    public String toString() {
        return "InventoryPreview(itemStack=" + this.itemStack + ", player=" + this.player + ", plugin=" + (Object)((Object)this.plugin) + ", inventory=" + this.inventory + ")";
    }
}

