/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.shop;

import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.event.ShopDisplayItemDespawnEvent;
import org.maxgamer.quickshop.event.ShopDisplayItemSpawnEvent;
import org.maxgamer.quickshop.shade.io.papermc.lib.PaperLib;
import org.maxgamer.quickshop.shop.ContainerShop;
import org.maxgamer.quickshop.shop.DisplayItem;
import org.maxgamer.quickshop.shop.DisplayType;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.Util;

public class RealDisplayItem
extends DisplayItem {
    @Nullable
    private Item item;

    RealDisplayItem(@NotNull Shop shop) {
        super(shop);
    }

    @Override
    public boolean checkDisplayIsMoved() {
        Util.ensureThread(false);
        if (this.item == null) {
            return false;
        }
        if (this.shop.isLeftShop()) {
            return false;
        }
        if (!Objects.requireNonNull(this.item.getLocation().getWorld()).equals(Objects.requireNonNull(this.getDisplayLocation()).getWorld())) {
            return true;
        }
        return this.item.getLocation().distance(this.getDisplayLocation()) > 0.6;
    }

    @Override
    public boolean checkDisplayNeedRegen() {
        Util.ensureThread(false);
        if (this.item == null) {
            return false;
        }
        return !this.item.isValid();
    }

    @Override
    public boolean checkIsShopEntity(@NotNull Entity entity) {
        Util.ensureThread(false);
        if (!(entity instanceof Item)) {
            return false;
        }
        return DisplayItem.checkIsGuardItemStack(((Item)entity).getItemStack());
    }

    @Override
    public void fixDisplayMoved() {
        Util.ensureThread(false);
        Location location = this.getDisplayLocation();
        if (this.item != null && location != null) {
            this.item.teleport(location);
            return;
        }
        this.fixDisplayMovedOld();
    }

    public void fixDisplayMovedOld() {
        Util.ensureThread(false);
        for (Entity entity : Objects.requireNonNull(this.shop.getLocation().getWorld()).getEntities()) {
            Item eItem;
            if (!(entity instanceof Item) || !(eItem = (Item)entity).getUniqueId().equals(Objects.requireNonNull(this.item).getUniqueId())) continue;
            if (this.shop.isLeftShop()) {
                return;
            }
            Util.debugLog("Fixing moved Item displayItem " + eItem.getUniqueId() + " at " + eItem.getLocation());
            PaperLib.teleportAsync(entity, Objects.requireNonNull(this.getDisplayLocation()), PlayerTeleportEvent.TeleportCause.UNKNOWN);
            return;
        }
    }

    @Override
    public void fixDisplayNeedRegen() {
        Util.ensureThread(false);
        this.respawn();
    }

    @Override
    public void remove() {
        Util.ensureThread(false);
        if (this.item == null) {
            Util.debugLog("Ignore the Item removing because the Item is already gone or it's a left shop.");
            return;
        }
        this.item.remove();
        this.item = null;
        this.guardedIstack = null;
        ShopDisplayItemDespawnEvent shopDisplayItemDespawnEvent = new ShopDisplayItemDespawnEvent(this.shop, this.originalItemStack, DisplayType.REALITEM);
        plugin.getServer().getPluginManager().callEvent((Event)shopDisplayItemDespawnEvent);
    }

    @Override
    public boolean removeDupe() {
        Util.ensureThread(false);
        if (this.shop.isLeftShop()) {
            return false;
        }
        if (this.item == null) {
            Util.debugLog("Warning: Trying to removeDupe for a null display shop.");
            return false;
        }
        boolean removed = false;
        ArrayList elist = new ArrayList(this.item.getNearbyEntities(1.5, 1.5, 1.5));
        if (this.shop.isRealDouble()) {
            elist.addAll(this.item.getWorld().getNearbyEntities(Objects.requireNonNull(this.getDoubleShopDisplayLocations(true)), 1.5, 1.5, 1.5));
            elist.addAll(this.item.getWorld().getNearbyEntities(Objects.requireNonNull(this.getDoubleShopDisplayLocations(false)), 1.5, 1.5, 1.5));
        }
        for (Entity entity : elist) {
            if (entity.getType() != EntityType.DROPPED_ITEM) continue;
            Item eItem = (Item)entity;
            UUID displayUUID = this.item.getUniqueId();
            if (eItem.getUniqueId().equals(displayUUID) || !DisplayItem.checkIsTargetShopDisplay(eItem.getItemStack(), this.shop)) continue;
            Util.debugLog("Removing a duped ItemEntity " + eItem.getUniqueId() + " at " + eItem.getLocation());
            entity.remove();
            removed = true;
        }
        return removed;
    }

    @Override
    public void respawn() {
        Util.ensureThread(false);
        this.remove();
        this.spawn();
    }

    @Override
    public void safeGuard(@NotNull Entity entity) {
        Util.ensureThread(false);
        if (!(entity instanceof Item)) {
            Util.debugLog("Failed to safeGuard " + entity.getLocation() + ", cause target not a Item");
            return;
        }
        Item item = (Item)entity;
        if (plugin.getConfig().getBoolean("shop.display-item-use-name")) {
            item.setCustomName(Util.getItemStackName(this.originalItemStack));
            item.setCustomNameVisible(true);
        } else {
            item.setCustomNameVisible(false);
        }
        item.setPickupDelay(Integer.MAX_VALUE);
        item.setSilent(true);
        item.setPortalCooldown(Integer.MAX_VALUE);
        item.setVelocity(new Vector(0.0, 0.1, 0.0));
    }

    @Override
    public void spawn() {
        Util.ensureThread(false);
        if (this.shop.isLeftShop()) {
            return;
        }
        if (this.shop.isDeleted() || !this.shop.isLoaded()) {
            return;
        }
        if (this.shop.getLocation().getWorld() == null) {
            Util.debugLog("Canceled the displayItem spawning because the location in the world is null.");
            return;
        }
        if (this.originalItemStack == null) {
            Util.debugLog("Canceled the displayItem spawning because the ItemStack is null.");
            return;
        }
        if (this.item != null && this.item.isValid()) {
            Util.debugLog("Warning: Spawning the Dropped Item for DisplayItem when there is already an existing Dropped Item, May cause a duplicated Dropped Item!");
            MsgUtil.debugStackTrace(Thread.currentThread().getStackTrace());
        }
        if (!Util.isDisplayAllowBlock(Objects.requireNonNull(this.getDisplayLocation()).getBlock().getType())) {
            Util.debugLog("Can't spawn the displayItem because there is not an AIR block above the shopblock.");
            return;
        }
        ShopDisplayItemSpawnEvent shopDisplayItemSpawnEvent = new ShopDisplayItemSpawnEvent(this.shop, this.originalItemStack, DisplayType.REALITEM);
        plugin.getServer().getPluginManager().callEvent((Event)shopDisplayItemSpawnEvent);
        if (shopDisplayItemSpawnEvent.isCancelled()) {
            Util.debugLog("Canceled the displayItem spawning because a plugin setCancelled the spawning event, usually this is a QuickShop Add on");
            return;
        }
        this.guardedIstack = DisplayItem.createGuardItemStack(this.originalItemStack, this.shop);
        this.item = this.shop.getLocation().getWorld().dropItem(this.getDisplayLocation(), this.guardedIstack);
        this.item.setItemStack(this.guardedIstack);
        this.safeGuard((Entity)this.item);
    }

    @Override
    @Nullable
    public Entity getDisplay() {
        return this.item;
    }

    @Nullable
    public Location getDoubleShopDisplayLocations(boolean thisItem) {
        Util.ensureThread(false);
        if (!this.shop.isRealDouble()) {
            return null;
        }
        if (thisItem) {
            return this.shop.getLocation().clone().add(0.5, 1.2, 0.5);
        }
        return this.shop.getAttachedShop().getLocation().clone().add(0.5, 1.2, 0.5);
    }

    @Override
    public boolean isSpawned() {
        Shop attachedShop;
        if (this.item == null) {
            return false;
        }
        if (this.shop.isLeftShop() && (attachedShop = this.shop.getAttachedShop()) instanceof ContainerShop) {
            ContainerShop shop = (ContainerShop)attachedShop;
            if (shop.getDisplayItem() == null) {
                return false;
            }
            return shop.getDisplayItem().isSpawned();
        }
        return this.item.isValid();
    }

    public String toString() {
        return "RealDisplayItem(item=" + this.item + ")";
    }
}

