/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.shop;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.database.WarpedResultSet;
import org.maxgamer.quickshop.file.newest.json.json.JsonConfiguration;
import org.maxgamer.quickshop.shop.ContainerShop;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.shop.ShopModerator;
import org.maxgamer.quickshop.shop.ShopType;
import org.maxgamer.quickshop.util.JsonUtil;
import org.maxgamer.quickshop.util.Timer;
import org.maxgamer.quickshop.util.Util;

public class ShopLoader {
    private final List<Long> loadTimes = new ArrayList<Long>();
    private final Map<Timer, Double> timeCostCache = new HashMap<Timer, Double>();
    private final QuickShop plugin;
    private final List<Shop> shopsInDatabase = new CopyOnWriteArrayList<Shop>();
    private final List<ShopRawDatabaseInfo> shopRawDatabaseInfoList = new CopyOnWriteArrayList<ShopRawDatabaseInfo>();
    private int errors;
    private int totalLoaded = 0;

    public ShopLoader(@NotNull QuickShop plugin) {
        this.plugin = plugin;
    }

    public void loadShops() {
        this.loadShops(null);
    }

    public void loadShops(@Nullable String worldName) {
        this.plugin.getLogger().info("Loading shops from the database...");
        int loadAfterChunkLoaded = 0;
        int loadAfterWorldLoaded = 0;
        ArrayList<ContainerShop> pendingLoadShops = new ArrayList<ContainerShop>();
        try (WarpedResultSet warpRS = this.plugin.getDatabaseHelper().selectAllShops();
             ResultSet rs = warpRS.getResultSet();){
            while (rs.next()) {
                ShopRawDatabaseInfo origin = new ShopRawDatabaseInfo(rs);
                this.shopRawDatabaseInfoList.add(origin);
                if (worldName != null && !origin.getWorld().equals(worldName)) continue;
                ShopDatabaseInfo shopDatabaseInfo = new ShopDatabaseInfo(origin);
                if (shopDatabaseInfo.getWorld() == null) {
                    ++loadAfterWorldLoaded;
                    continue;
                }
                ContainerShop shop = new ContainerShop(this.plugin, shopDatabaseInfo.getLocation(), shopDatabaseInfo.getPrice(), shopDatabaseInfo.getItem(), shopDatabaseInfo.getModerators(), shopDatabaseInfo.isUnlimited(), shopDatabaseInfo.getType(), shopDatabaseInfo.getExtra());
                if (shopDatabaseInfo.needUpdate.get()) {
                    shop.setDirty();
                }
                this.shopsInDatabase.add(shop);
                if (this.shopNullCheck(shop)) {
                    if (this.plugin.getConfig().getBoolean("debug.delete-corrupt-shops", false)) {
                        this.plugin.getLogger().warning("Deleting shop " + shop + " caused by corrupted.");
                        this.plugin.getDatabaseHelper().removeShop(origin.getWorld(), origin.getX(), origin.getY(), origin.getZ());
                        continue;
                    }
                    Util.debugLog("Trouble database loading debug: " + shopDatabaseInfo);
                    Util.debugLog("Somethings gone wrong, skipping the loading...");
                    continue;
                }
                if (!Util.isWorldLoaded(shop.getLocation())) {
                    ++loadAfterWorldLoaded;
                    continue;
                }
                this.plugin.getShopManager().loadShop(shopDatabaseInfo.getWorld().getName(), shop);
                if (Util.isLoaded(shop.getLocation())) {
                    if (!Util.canBeShop(shop.getLocation().getBlock())) {
                        Util.debugLog("Target block can't be a shop, removing it from the memory...");
                        this.plugin.getShopManager().removeShop(shop);
                        continue;
                    }
                    pendingLoadShops.add(shop);
                    continue;
                }
                ++loadAfterChunkLoaded;
            }
            for (Shop shop : pendingLoadShops) {
                shop.onLoad();
                shop.update();
            }
            this.plugin.getLogger().info("Successfully loaded " + this.totalLoaded + " shops!");
            this.plugin.getLogger().info(loadAfterChunkLoaded + " shops will load after chunk have loaded, " + loadAfterWorldLoaded + " shops will load after the world has loaded.");
        }
        catch (Exception e) {
            this.exceptionHandler(e, null);
        }
    }

    private void singleShopLoaded(@NotNull Timer singleShopLoadTimer) {
        ++this.totalLoaded;
        long singleShopLoadTime = singleShopLoadTimer.stopAndGetTimePassed();
        this.loadTimes.add(singleShopLoadTime);
        Util.debugLog("Loaded shop used time " + singleShopLoadTime + "ms");
    }

    private double calcTimeCost(@NotNull Timer timer) {
        this.timeCostCache.putIfAbsent(timer, Double.valueOf(timer.getPassedTime()));
        return (double)timer.getPassedTime() - this.timeCostCache.get(timer);
    }

    private boolean shopNullCheck(@Nullable Shop shop) {
        if (shop == null) {
            Util.debugLog("Shop object is null");
            return true;
        }
        if (shop.getItem() == null) {
            Util.debugLog("Shop itemStack is null");
            return true;
        }
        if (shop.getItem().getType() == Material.AIR) {
            Util.debugLog("Shop itemStack type can't be AIR");
            return true;
        }
        if (shop.getLocation() == null) {
            Util.debugLog("Shop location is null");
            return true;
        }
        if (shop.getOwner() == null) {
            Util.debugLog("Shop owner is null");
            return true;
        }
        if (this.plugin.getServer().getOfflinePlayer(shop.getOwner()).getName() == null) {
            Util.debugLog("Shop owner not exist on this server, did you have reset the playerdata?");
        }
        return false;
    }

    @NotNull
    private Long mean(Long[] m) {
        long sum = 0L;
        for (Long aM : m) {
            sum += aM.longValue();
        }
        if (m.length == 0) {
            return sum;
        }
        return sum / (long)m.length;
    }

    @NotNull
    private YamlConfiguration extraUpgrade(@NotNull String extraString) {
        if (!StringUtils.isEmpty((String)extraString) && !"QuickShop: {}".equalsIgnoreCase(extraString)) {
            Util.debugLog("Extra API -> Upgrading -> " + extraString.replaceAll("\n", ""));
        }
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        JsonConfiguration jsonConfiguration = new JsonConfiguration();
        try {
            jsonConfiguration.loadFromString(extraString);
        }
        catch (InvalidConfigurationException e) {
            this.plugin.getLogger().log(Level.WARNING, "Cannot upgrade extra data: " + extraString, e);
        }
        for (String key : jsonConfiguration.getKeys(true)) {
            yamlConfiguration.set(key, jsonConfiguration.get(key));
        }
        return yamlConfiguration;
    }

    @NotNull
    private YamlConfiguration deserializeExtra(@NotNull String extraString, @NotNull AtomicBoolean needUpdate) {
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        try {
            if (extraString.startsWith("{")) {
                yamlConfiguration = this.extraUpgrade(extraString);
                needUpdate.set(true);
            } else {
                yamlConfiguration.loadFromString(extraString);
            }
        }
        catch (InvalidConfigurationException e) {
            yamlConfiguration = this.extraUpgrade(extraString);
            needUpdate.set(true);
        }
        return yamlConfiguration;
    }

    private void exceptionHandler(@NotNull Exception ex, @Nullable Location shopLocation) {
        ++this.errors;
        Logger logger = this.plugin.getLogger();
        logger.warning("##########FAILED TO LOAD SHOP##########");
        logger.warning("  >> Error Info:");
        String err = ex.getMessage();
        if (err == null) {
            err = "null";
        }
        logger.warning(err);
        logger.warning("  >> Error Trace");
        ex.printStackTrace();
        logger.warning("  >> Target Location Info");
        logger.warning("Location: " + (shopLocation == null ? "NULL" : shopLocation.toString()));
        logger.warning("Block: " + (shopLocation == null ? "NULL" : shopLocation.getBlock().getType().name()));
        logger.warning("#######################################");
        if (this.errors > 10) {
            logger.severe("QuickShop detected too many errors when loading shops, you should backup your shop database and ask the developer for help");
        }
    }

    public synchronized void recoverFromFile(@NotNull String fileContent) {
        this.plugin.getLogger().info("Processing the shop data...");
        String[] shopsPlain = fileContent.split("\n");
        this.plugin.getLogger().info("Recovering shops...");
        Gson gson = JsonUtil.getGson();
        int total = shopsPlain.length;
        for (int i = 0; i < total; ++i) {
            String shopStr = shopsPlain[i].trim();
            boolean success = false;
            try {
                ShopRawDatabaseInfo shopDatabaseInfoOrigin = (ShopRawDatabaseInfo)gson.fromJson(shopStr, ShopRawDatabaseInfo.class);
                this.shopRawDatabaseInfoList.add(shopDatabaseInfoOrigin);
                ShopDatabaseInfo data = new ShopDatabaseInfo(shopDatabaseInfoOrigin);
                ContainerShop shop = new ContainerShop(this.plugin, data.getLocation(), data.getPrice(), data.getItem(), data.getModerators(), data.isUnlimited(), data.getType(), data.getExtra());
                this.shopsInDatabase.add(shop);
                if (this.shopNullCheck(shop)) continue;
                Util.mainThreadRun(() -> {
                    this.plugin.getDatabaseHelper().createShop(shop, null, null);
                    this.plugin.getShopManager().loadShop(data.getWorld().getName(), shop);
                    shop.update();
                });
                success = true;
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
            this.plugin.getLogger().info("Processed " + i + "/" + total + " - [" + success + "]");
        }
    }

    @NotNull
    public List<Shop> getShopsInDatabase() {
        return new ArrayList<Shop>(this.shopsInDatabase);
    }

    public void removeShopFromShopLoader(Shop shop) {
        if (this.shopsInDatabase.remove(shop)) {
            for (ShopRawDatabaseInfo rawDatabaseInfo : this.shopRawDatabaseInfoList) {
                if (!Objects.equals(shop.getLocation().getWorld().getName(), rawDatabaseInfo.getWorld()) || shop.getLocation().getBlockX() != rawDatabaseInfo.getX() || shop.getLocation().getBlockY() != rawDatabaseInfo.getY() || shop.getLocation().getBlockZ() != rawDatabaseInfo.getZ()) continue;
                this.shopRawDatabaseInfoList.remove(rawDatabaseInfo);
                break;
            }
        }
    }

    @NotNull
    public List<ShopRawDatabaseInfo> getOriginShopsInDatabase() {
        return new ArrayList<ShopRawDatabaseInfo>(this.shopRawDatabaseInfoList);
    }

    public static class ShopRawDatabaseInfo {
        private String item;
        private String moderators;
        private double price;
        private int type;
        private boolean unlimited;
        private String world;
        private int x;
        private int y;
        private int z;
        private String extra;

        ShopRawDatabaseInfo(ResultSet rs) throws SQLException {
            this.x = rs.getInt("x");
            this.y = rs.getInt("y");
            this.z = rs.getInt("z");
            this.world = rs.getString("world");
            this.item = rs.getString("itemConfig");
            this.moderators = rs.getString("owner");
            this.price = rs.getDouble("price");
            this.type = rs.getInt("type");
            this.unlimited = rs.getBoolean("unlimited");
            this.extra = rs.getString("extra");
            if (this.extra == null) {
                this.extra = "";
            }
        }

        ShopRawDatabaseInfo(int x, int y, int z, String world, String itemConfig, String owner, double price, int type, boolean unlimited, String extra) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.world = world;
            this.item = itemConfig;
            this.moderators = owner;
            this.price = price;
            this.type = type;
            this.unlimited = unlimited;
            this.extra = extra;
        }

        ShopRawDatabaseInfo() {
        }

        public String toString() {
            return JsonUtil.getGson().toJson((Object)this);
        }

        public String getItem() {
            return this.item;
        }

        public String getModerators() {
            return this.moderators;
        }

        public double getPrice() {
            return this.price;
        }

        public int getType() {
            return this.type;
        }

        public boolean isUnlimited() {
            return this.unlimited;
        }

        public String getWorld() {
            return this.world;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getZ() {
            return this.z;
        }

        public String getExtra() {
            return this.extra;
        }

        public void setItem(String item) {
            this.item = item;
        }

        public void setModerators(String moderators) {
            this.moderators = moderators;
        }

        public void setPrice(double price) {
            this.price = price;
        }

        public void setType(int type) {
            this.type = type;
        }

        public void setUnlimited(boolean unlimited) {
            this.unlimited = unlimited;
        }

        public void setWorld(String world) {
            this.world = world;
        }

        public void setX(int x) {
            this.x = x;
        }

        public void setY(int y) {
            this.y = y;
        }

        public void setZ(int z) {
            this.z = z;
        }

        public void setExtra(String extra) {
            this.extra = extra;
        }
    }

    public class ShopDatabaseInfo {
        private ItemStack item;
        private Location location;
        private ShopModerator moderators;
        private double price;
        private ShopType type;
        private boolean unlimited;
        private World world;
        private int x;
        private int y;
        private int z;
        private YamlConfiguration extra;
        private AtomicBoolean needUpdate = new AtomicBoolean(false);

        ShopDatabaseInfo(ShopRawDatabaseInfo origin) {
            try {
                this.x = origin.getX();
                this.y = origin.getY();
                this.z = origin.getZ();
                this.world = ShopLoader.this.plugin.getServer().getWorld(origin.getWorld());
                this.location = new Location(this.world, (double)this.x, (double)this.y, (double)this.z);
                this.price = origin.getPrice();
                this.unlimited = origin.isUnlimited();
                this.moderators = this.deserializeModerator(origin.getModerators(), this.needUpdate);
                this.type = ShopType.fromID(origin.getType());
                this.item = this.deserializeItem(origin.getItem());
                this.extra = ShopLoader.this.deserializeExtra(origin.getExtra(), this.needUpdate);
            }
            catch (Exception ex) {
                ShopLoader.this.exceptionHandler(ex, this.location);
            }
        }

        @Nullable
        private ItemStack deserializeItem(@NotNull String itemConfig) {
            try {
                return Util.deserialize(itemConfig);
            }
            catch (InvalidConfigurationException e) {
                ShopLoader.this.plugin.getLogger().log(Level.WARNING, "Failed load shop data, because target config can't deserialize the ItemStack", e);
                Util.debugLog("Failed to load data to the ItemStack: " + itemConfig);
                return null;
            }
        }

        @Nullable
        private ShopModerator deserializeModerator(@NotNull String moderatorJson, AtomicBoolean needUpdate) {
            ShopModerator shopModerator;
            if (Util.isUUID(moderatorJson)) {
                Util.debugLog("Updating old shop data... for " + moderatorJson);
                shopModerator = new ShopModerator(UUID.fromString(moderatorJson));
                needUpdate.set(true);
            } else {
                try {
                    shopModerator = ShopModerator.deserialize(moderatorJson);
                }
                catch (JsonSyntaxException ex) {
                    Util.debugLog("Updating old shop data... for " + moderatorJson);
                    moderatorJson = ShopLoader.this.plugin.getServer().getOfflinePlayer(moderatorJson).getUniqueId().toString();
                    shopModerator = new ShopModerator(UUID.fromString(moderatorJson));
                    needUpdate.set(true);
                }
            }
            return shopModerator;
        }

        public ItemStack getItem() {
            return this.item;
        }

        public Location getLocation() {
            return this.location;
        }

        public ShopModerator getModerators() {
            return this.moderators;
        }

        public double getPrice() {
            return this.price;
        }

        public ShopType getType() {
            return this.type;
        }

        public boolean isUnlimited() {
            return this.unlimited;
        }

        public World getWorld() {
            return this.world;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getZ() {
            return this.z;
        }

        public YamlConfiguration getExtra() {
            return this.extra;
        }

        public AtomicBoolean getNeedUpdate() {
            return this.needUpdate;
        }

        public void setItem(ItemStack item) {
            this.item = item;
        }

        public void setLocation(Location location) {
            this.location = location;
        }

        public void setModerators(ShopModerator moderators) {
            this.moderators = moderators;
        }

        public void setPrice(double price) {
            this.price = price;
        }

        public void setType(ShopType type) {
            this.type = type;
        }

        public void setUnlimited(boolean unlimited) {
            this.unlimited = unlimited;
        }

        public void setWorld(World world) {
            this.world = world;
        }

        public void setX(int x) {
            this.x = x;
        }

        public void setY(int y) {
            this.y = y;
        }

        public void setZ(int z) {
            this.z = z;
        }

        public void setExtra(YamlConfiguration extra) {
            this.extra = extra;
        }

        public void setNeedUpdate(AtomicBoolean needUpdate) {
            this.needUpdate = needUpdate;
        }
    }
}

