/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.shop;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.economy.Economy;
import org.maxgamer.quickshop.economy.EconomyTransaction;
import org.maxgamer.quickshop.economy.Trader;
import org.maxgamer.quickshop.event.ShopCreateEvent;
import org.maxgamer.quickshop.event.ShopPreCreateEvent;
import org.maxgamer.quickshop.event.ShopPurchaseEvent;
import org.maxgamer.quickshop.event.ShopSuccessPurchaseEvent;
import org.maxgamer.quickshop.event.ShopTaxEvent;
import org.maxgamer.quickshop.shade.io.papermc.lib.PaperLib;
import org.maxgamer.quickshop.shop.ContainerShop;
import org.maxgamer.quickshop.shop.Info;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.shop.ShopAction;
import org.maxgamer.quickshop.shop.ShopChunk;
import org.maxgamer.quickshop.shop.ShopModerator;
import org.maxgamer.quickshop.shop.ShopType;
import org.maxgamer.quickshop.util.CalculateUtil;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.PriceLimiter;
import org.maxgamer.quickshop.util.Util;
import org.maxgamer.quickshop.util.holder.Result;

public class ShopManager {
    private final Map<String, Map<ShopChunk, Map<Location, Shop>>> shops = Maps.newConcurrentMap();
    private final Set<Shop> loadedShops = Sets.newConcurrentHashSet();
    private final Map<UUID, Info> actions = Maps.newConcurrentMap();
    private final QuickShop plugin;
    @Nullable
    private final Trader cacheTaxAccount;
    private final Trader cacheUnlimitedShopAccount;
    private final PriceLimiter priceLimiter;
    private final boolean useFastShopSearchAlgorithm;
    private final boolean useOldCanBuildAlgorithm;
    private final boolean autoSign;
    private final Cache<UUID, Shop> shopRuntimeUUIDCaching = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maximumSize(50L).weakValues().initialCapacity(50).build();

    public ShopManager(@NotNull QuickShop plugin) {
        Util.ensureThread(false);
        this.plugin = plugin;
        this.useFastShopSearchAlgorithm = plugin.getConfig().getBoolean("shop.use-fast-shop-search-algorithm", false);
        Util.debugLog("Loading caching tax account...");
        String taxAccount = plugin.getConfig().getString("tax-account", "tax");
        this.cacheTaxAccount = !taxAccount.isEmpty() ? (Util.isUUID(taxAccount) ? new Trader(taxAccount, plugin.getServer().getOfflinePlayer(UUID.fromString(taxAccount))) : new Trader(taxAccount, plugin.getServer().getOfflinePlayer(taxAccount))) : null;
        String uAccount = plugin.getConfig().getString("unlimited-shop-owner-change-account");
        this.cacheUnlimitedShopAccount = Util.isUUID(uAccount) ? new Trader(uAccount, Bukkit.getOfflinePlayer((UUID)UUID.fromString(uAccount))) : new Trader(uAccount, Bukkit.getOfflinePlayer((String)uAccount));
        this.priceLimiter = new PriceLimiter(plugin.getConfig().getDouble("shop.minimum-price"), plugin.getConfig().getInt("shop.maximum-price"), plugin.getConfig().getBoolean("shop.allow-free-shop"), plugin.getConfig().getBoolean("whole-number-prices-only"));
        this.useOldCanBuildAlgorithm = plugin.getConfig().getBoolean("limits.old-algorithm");
        this.autoSign = plugin.getConfig().getBoolean("shop.auto-sign");
    }

    public boolean canBuildShop(@NotNull Player p, @NotNull Block b, @NotNull BlockFace bf) {
        ShopPreCreateEvent spce;
        Util.ensureThread(false);
        if (this.plugin.isLimit()) {
            int owned = 0;
            if (this.useOldCanBuildAlgorithm) {
                owned = this.getPlayerAllShops(p.getUniqueId()).size();
            } else {
                for (Shop shop : this.getPlayerAllShops(p.getUniqueId())) {
                    if (shop.isUnlimited()) continue;
                    ++owned;
                }
            }
            int max = this.plugin.getShopLimit(p);
            if (owned + 1 > max) {
                MsgUtil.sendMessage((CommandSender)p, "reached-maximum-can-create", String.valueOf(owned), String.valueOf(max));
                return false;
            }
        }
        return !Util.fireCancellableEvent(spce = new ShopPreCreateEvent(p, b.getLocation()));
    }

    @NotNull
    public Map<String, Map<ShopChunk, Map<Location, Shop>>> getShops() {
        return this.shops;
    }

    @NotNull
    public Iterator<Shop> getShopIterator() {
        return new ShopIterator();
    }

    public void clear() {
        Util.ensureThread(false);
        if (this.plugin.isDisplay()) {
            for (World world : this.plugin.getServer().getWorlds()) {
                for (Chunk chunk : world.getLoadedChunks()) {
                    Map<Location, Shop> inChunk = this.getShops(chunk);
                    if (inChunk == null || inChunk.isEmpty()) continue;
                    for (Shop shop : inChunk.values()) {
                        if (!shop.isLoaded()) continue;
                        shop.onUnload();
                    }
                }
            }
        }
        this.actions.clear();
        this.shops.clear();
    }

    @Nullable
    public Map<Location, Shop> getShops(@NotNull Chunk c) {
        return this.getShops(c.getWorld().getName(), c.getX(), c.getZ());
    }

    @Nullable
    public Map<Location, Shop> getShops(@NotNull String world, int chunkX, int chunkZ) {
        Map<ShopChunk, Map<Location, Shop>> inWorld = this.getShops(world);
        if (inWorld == null) {
            return null;
        }
        return inWorld.get(new ShopChunk(world, chunkX, chunkZ));
    }

    @Nullable
    public Map<ShopChunk, Map<Location, Shop>> getShops(@NotNull String world) {
        return this.shops.get(world);
    }

    private void processWaterLoggedSign(@NotNull Block container, @NotNull Block signBlock) {
        boolean signIsWatered = signBlock.getType() == Material.WATER;
        signBlock.setType(Util.getSignMaterial());
        BlockState signBlockState = signBlock.getState();
        BlockData signBlockData = signBlockState.getBlockData();
        if (signIsWatered && signBlockData instanceof Waterlogged) {
            Waterlogged waterable = (Waterlogged)signBlockData;
            waterable.setWaterlogged(true);
        }
        if (signBlockData instanceof WallSign) {
            WallSign wallSignBlockData = (WallSign)signBlockData;
            BlockFace bf = container.getFace(signBlock);
            if (bf != null) {
                wallSignBlockData.setFacing(bf);
                signBlockState.setBlockData((BlockData)wallSignBlockData);
            }
        } else {
            this.plugin.getLogger().warning("Sign material " + signBlockState.getType().name() + " not a WallSign, make sure you using correct sign material.");
        }
        signBlockState.update(true);
    }

    public void createShop(@NotNull Shop shop, @NotNull Info info) {
        Util.ensureThread(false);
        Player player = this.plugin.getServer().getPlayer(shop.getOwner());
        if (player == null) {
            throw new IllegalStateException("The owner creating the shop is offline or not exist");
        }
        if (info.getSignBlock() != null && this.autoSign) {
            if (Util.isAir(info.getSignBlock().getType()) || info.getSignBlock().getType() == Material.WATER) {
                this.processWaterLoggedSign(shop.getLocation().getBlock(), info.getSignBlock());
            } else if (!this.plugin.getConfig().getBoolean("shop.allow-shop-without-space-for-sign")) {
                MsgUtil.sendMessage((CommandSender)player, "failed-to-put-sign", new String[0]);
                Util.debugLog("Sign cannot placed cause no enough space(Not air block)");
                return;
            }
        }
        shop.onLoad();
        shop.setSignText();
        this.addShop(shop.getLocation().getWorld().getName(), shop);
        this.plugin.getDatabaseHelper().createShop(shop, null, e -> Util.mainThreadRun(() -> {
            shop.delete(true);
            this.plugin.getLogger().log(Level.WARNING, "Shop create failed, trying to auto fix the database...", (Throwable)e);
            boolean backupSuccess = Util.backupDatabase();
            if (backupSuccess) {
                this.plugin.getDatabaseHelper().removeShop(shop);
            } else {
                this.plugin.getLogger().warning("Failed to backup the database, all changes will revert after a reboot.");
            }
            this.plugin.getDatabaseHelper().createShop(shop, null, e2 -> {
                this.plugin.getLogger().log(Level.SEVERE, "Shop create failed, auto fix failed, the changes may won't commit to database.", (Throwable)e2);
                MsgUtil.sendMessage((CommandSender)player, "shop-creation-failed", new String[0]);
                Util.mainThreadRun(() -> {
                    shop.onUnload();
                    this.removeShop(shop);
                    shop.delete();
                });
            });
        }));
    }

    @Nullable
    public String format(double d, @NotNull World world, @Nullable String currency) {
        return this.plugin.getEconomy().format(d, world, currency);
    }

    @Nullable
    public Shop getShop(@NotNull Location loc) {
        return this.getShop(loc, false);
    }

    @Nullable
    public Shop getShop(@NotNull Location loc, boolean skipShopableChecking) {
        if (!skipShopableChecking && !Util.isShoppables(loc.getBlock().getType())) {
            return null;
        }
        Map<Location, Shop> inChunk = this.getShops(loc.getChunk());
        if (inChunk == null) {
            return null;
        }
        loc = loc.clone();
        loc.setX((double)loc.getBlockX());
        loc.setY((double)loc.getBlockY());
        loc.setZ((double)loc.getBlockZ());
        return inChunk.get(loc);
    }

    @Nullable
    public Shop getShopIncludeAttached(@Nullable Location loc) {
        return this.getShopIncludeAttached(loc, true);
    }

    @Nullable
    public Shop getShopIncludeAttached(@Nullable Location loc, boolean useCache) {
        if (loc == null) {
            Util.debugLog("Location is null.");
            return null;
        }
        if (this.useFastShopSearchAlgorithm) {
            return this.getShopIncludeAttached_Fast(loc, false, useCache);
        }
        return this.getShopIncludeAttached_Classic(loc);
    }

    @Nullable
    public Shop getShopIncludeAttached_Classic(@NotNull Location loc) {
        Shop shop;
        @Nullable Map<Location, Shop> inChunk = this.getShops(loc.getChunk());
        if (inChunk != null && (shop = inChunk.get(loc)) != null) {
            return shop;
        }
        @Nullable Block secondHalfShop = Util.getSecondHalf(loc.getBlock());
        if (secondHalfShop != null && (inChunk = this.getShops(secondHalfShop.getChunk())) != null && (shop = inChunk.get(secondHalfShop.getLocation())) != null) {
            return shop;
        }
        Block block = loc.getBlock();
        BlockState state = PaperLib.getBlockState(loc.getBlock(), false).getState();
        if (state instanceof Sign) {
            @Nullable Block attachedBlock = Util.getAttached(block);
            if (attachedBlock == null) {
                return null;
            }
            inChunk = this.getShops(attachedBlock.getChunk());
            if (inChunk != null) {
                shop = inChunk.get(attachedBlock.getLocation());
                return shop;
            }
        }
        return null;
    }

    public void bakeShopRuntimeRandomUniqueIdCache(@NotNull Shop shop) {
        this.shopRuntimeUUIDCaching.put(shop.getRuntimeRandomUniqueId(), shop);
    }

    @Nullable
    public Shop getShopFromRuntimeRandomUniqueId(@NotNull UUID runtimeRandomUniqueId) {
        return this.getShopFromRuntimeRandomUniqueId(runtimeRandomUniqueId, false);
    }

    @Nullable
    public Shop getShopFromRuntimeRandomUniqueId(@NotNull UUID runtimeRandomUniqueId, boolean includeInvalid) {
        Shop shop = this.shopRuntimeUUIDCaching.getIfPresent(runtimeRandomUniqueId);
        if (shop == null) {
            for (Shop shopWithoutCache : this.getLoadedShops()) {
                if (!shopWithoutCache.getRuntimeRandomUniqueId().equals(runtimeRandomUniqueId)) continue;
                return shopWithoutCache;
            }
            return null;
        }
        if (includeInvalid) {
            return shop;
        }
        if (shop.isValid()) {
            return shop;
        }
        return null;
    }

    public void handleChat(@NotNull Player p, @NotNull String msg) {
        this.handleChat(p, msg, false);
    }

    public void handleChat(@NotNull Player p, @NotNull String msg, boolean bypassProtectionChecks) {
        if (!this.plugin.getShopManager().getActions().containsKey(p.getUniqueId())) {
            return;
        }
        String message = ChatColor.stripColor((String)msg);
        Util.mainThreadRun(() -> {
            Map<UUID, Info> actions = this.getActions();
            Info info = actions.remove(p.getUniqueId());
            if (info == null) {
                return;
            }
            if (info.getLocation().getWorld() != p.getLocation().getWorld() || info.getLocation().distanceSquared(p.getLocation()) > 25.0) {
                MsgUtil.sendMessage((CommandSender)p, "not-looking-at-shop", new String[0]);
                return;
            }
            if (info.getAction() == ShopAction.CREATE) {
                this.actionCreate(p, info, message, bypassProtectionChecks);
            }
            if (info.getAction() == ShopAction.BUY) {
                this.actionTrade(p, info, message);
            }
        });
    }

    public void loadShop(@NotNull String world, @NotNull Shop shop) {
        this.addShop(world, shop);
    }

    public void addShop(@NotNull String world, @NotNull Shop shop) {
        Map inWorld = this.getShops().computeIfAbsent(world, k -> new MapMaker().initialCapacity(3).makeMap());
        int x = (int)Math.floor((double)shop.getLocation().getBlockX() / 16.0);
        int z = (int)Math.floor((double)shop.getLocation().getBlockZ() / 16.0);
        ShopChunk shopChunk = new ShopChunk(world, x, z);
        Map inChunk = inWorld.computeIfAbsent(shopChunk, k -> new MapMaker().initialCapacity(1).makeMap());
        inChunk.put(shop.getLocation(), shop);
    }

    public void removeShop(@NotNull Shop shop) {
        int z;
        int x;
        ShopChunk shopChunk;
        Location loc = shop.getLocation();
        String world = Objects.requireNonNull(loc.getWorld()).getName();
        Map<ShopChunk, Map<Location, Shop>> inWorld = this.getShops().get(world);
        Map<Location, Shop> inChunk = inWorld.get(shopChunk = new ShopChunk(world, x = (int)Math.floor((double)loc.getBlockX() / 16.0), z = (int)Math.floor((double)loc.getBlockZ() / 16.0)));
        if (inChunk == null) {
            return;
        }
        inChunk.remove(loc);
    }

    @NotNull
    public Map<UUID, Info> getActions() {
        return this.actions;
    }

    @NotNull
    public Set<Shop> getLoadedShops() {
        return this.loadedShops;
    }

    @NotNull
    public List<Shop> getPlayerAllShops(@NotNull UUID playerUUID) {
        ArrayList<Shop> playerShops = new ArrayList<Shop>(10);
        for (Shop shop : this.getAllShops()) {
            if (!shop.getOwner().equals(playerUUID)) continue;
            playerShops.add(shop);
        }
        return playerShops;
    }

    @NotNull
    public List<Shop> getAllShops() {
        ArrayList<Shop> shops = new ArrayList<Shop>();
        for (Map<ShopChunk, Map<Location, Shop>> shopMapData : this.getShops().values()) {
            for (Map<Location, Shop> shopData : shopMapData.values()) {
                shops.addAll(shopData.values());
            }
        }
        return shops;
    }

    @NotNull
    public List<Shop> getShopsInWorld(@NotNull World world) {
        ArrayList<Shop> worldShops = new ArrayList<Shop>();
        for (Shop shop : this.getAllShops()) {
            if (!Objects.equals(shop.getLocation().getWorld(), world)) continue;
            worldShops.add(shop);
        }
        return worldShops;
    }

    public void actionBuy(@NotNull UUID buyer, @NotNull Inventory buyerInventory, @NotNull Economy eco, @NotNull Info info, @NotNull Shop shop, int amount) {
        Util.ensureThread(false);
        if (this.shopIsNotValid(buyer, info, shop)) {
            return;
        }
        int space = shop.getRemainingSpace();
        if (space == -1) {
            space = 10000;
        }
        if (space < amount) {
            MsgUtil.sendMessage(buyer, "shop-has-no-space", Integer.toString(space), Util.getItemStackName(shop.getItem()));
            return;
        }
        int count = Util.countItems(buyerInventory, shop.getItem());
        if (amount > count) {
            MsgUtil.sendMessage(buyer, "you-dont-have-that-many-items", Integer.toString(count), Util.getItemStackName(shop.getItem()));
            return;
        }
        if (amount < 1) {
            MsgUtil.sendMessage(buyer, "negative-amount", new String[0]);
            return;
        }
        double taxModifier = this.getTax(shop, buyer);
        double total = CalculateUtil.multiply(amount, shop.getPrice());
        ShopPurchaseEvent e = new ShopPurchaseEvent(shop, buyer, buyerInventory, amount, total);
        if (Util.fireCancellableEvent(e)) {
            return;
        }
        total = e.getTotal();
        EconomyTransaction.EconomyTransactionBuilder builder = EconomyTransaction.builder().core(eco).amount(total).taxModifier(taxModifier).taxAccount(this.cacheTaxAccount).currency(shop.getCurrency()).world(shop.getLocation().getWorld()).to(buyer);
        EconomyTransaction transaction = !shop.isUnlimited() || this.plugin.getConfig().getBoolean("shop.pay-unlimited-shop-owners") && shop.isUnlimited() ? builder.from(shop.getOwner()).build() : builder.from(null).build();
        if (!transaction.failSafeCommit()) {
            if (transaction.getSteps() == EconomyTransaction.TransactionSteps.CHECK) {
                MsgUtil.sendMessage(buyer, "the-owner-cant-afford-to-buy-from-you", Objects.requireNonNull(this.format(total, shop.getLocation().getWorld(), shop.getCurrency())), Objects.requireNonNull(this.format(eco.getBalance(shop.getOwner(), shop.getLocation().getWorld(), shop.getCurrency()), shop.getLocation().getWorld(), shop.getCurrency())));
            } else {
                MsgUtil.sendMessage(buyer, "purchase-failed", new String[0]);
                this.plugin.getLogger().severe("EconomyTransaction Failed, last error:" + transaction.getLastError());
                QuickShop.getInstance().log("EconomyTransaction Failed, last error:" + transaction.getLastError());
            }
            return;
        }
        Player player = this.plugin.getServer().getPlayer(buyer);
        String msg = MsgUtil.getMessage(buyer, "player-sold-to-your-store", player != null ? player.getName() : buyer.toString(), String.valueOf(amount), Util.getItemStackName(shop.getItem()));
        if (space == amount) {
            msg = msg + "\n" + MsgUtil.getMessage(buyer, "shop-out-of-space", Integer.toString(shop.getLocation().getBlockX()), Integer.toString(shop.getLocation().getBlockY()), Integer.toString(shop.getLocation().getBlockZ()));
        }
        MsgUtil.TransactionMessage transactionMessage = new MsgUtil.TransactionMessage(msg, Util.serialize(shop.getItem()), null);
        if (this.plugin.getConfig().getBoolean("shop.sending-stock-message-to-staffs")) {
            for (UUID staff : shop.getModerator().getStaffs()) {
                MsgUtil.send(shop, staff, transactionMessage);
            }
        }
        MsgUtil.send(shop, shop.getOwner(), transactionMessage);
        shop.buy(buyer, buyerInventory, player != null ? player.getLocation() : shop.getLocation(), amount);
        MsgUtil.sendSellSuccess(buyer, shop, amount);
        ShopSuccessPurchaseEvent se = new ShopSuccessPurchaseEvent(shop, buyer, buyerInventory, amount, total, taxModifier);
        this.plugin.getServer().getPluginManager().callEvent((Event)se);
        shop.setSignText();
    }

    @Deprecated
    public void actionBuy(@NotNull Player p, @NotNull Economy eco, @NotNull Info info, @NotNull Shop shop, int amount) {
        Util.ensureThread(false);
        this.actionBuy(p.getUniqueId(), (Inventory)p.getInventory(), eco, info, shop, amount);
    }

    @Deprecated
    public double getTax(@NotNull Shop shop, @NotNull Player p) {
        return this.getTax(shop, p.getUniqueId());
    }

    public double getTax(@NotNull Shop shop, @NotNull UUID p) {
        Util.ensureThread(false);
        double tax = this.plugin.getConfig().getDouble("tax");
        Player player = this.plugin.getServer().getPlayer(p);
        if (player != null) {
            if (QuickShop.getPermissionManager().hasPermission((CommandSender)player, "quickshop.tax")) {
                tax = 0.0;
                Util.debugLog("Disable the Tax for player " + player + " cause they have permission quickshop.tax");
            }
            if (shop.isUnlimited() && QuickShop.getPermissionManager().hasPermission((CommandSender)player, "quickshop.tax.bypassunlimited")) {
                tax = 0.0;
                Util.debugLog("Disable the Tax for player " + player + " cause they have permission quickshop.tax.bypassunlimited and shop is unlimited.");
            }
        }
        if (tax >= 1.0) {
            this.plugin.getLogger().warning("Disable tax due to is invalid, it should be in 0.0-1.0 (current value is " + tax + ")");
            tax = 0.0;
        }
        if (tax < 0.0) {
            tax = 0.0;
        }
        if (shop.getModerator().isModerator(p)) {
            tax = 0.0;
        }
        ShopTaxEvent taxEvent = new ShopTaxEvent(shop, tax, p);
        taxEvent.callEvent();
        return taxEvent.getTax();
    }

    public void actionCreate(@NotNull Player p, @NotNull Info info, @NotNull String message, boolean bypassProtectionChecks) {
        ContainerShop nextTo;
        EconomyTransaction economyTransaction;
        Result result;
        double price;
        Result result2;
        Util.ensureThread(false);
        if (this.plugin.getEconomy() == null) {
            MsgUtil.sendDirectMessage((CommandSender)p, "Error: Economy system not loaded, type /qs main command to get details.");
            return;
        }
        if (this.plugin.isAllowStack() && !p.hasPermission("quickshop.create.stacks")) {
            Util.debugLog("Player " + p + " no permission to create stacks shop, forcing creating single item shop");
            info.getItem().setAmount(1);
        }
        Util.debugLog("Calling for protection check...");
        if (!bypassProtectionChecks && !(result2 = this.plugin.getPermissionChecker().canBuild(p, info.getLocation())).isSuccess()) {
            MsgUtil.sendMessage((CommandSender)p, "3rd-plugin-build-check-failed", result2.getMessage());
            Util.debugLog("Failed to create shop because protection check failed, found:" + result2.getMessage());
            return;
        }
        if (this.plugin.getShopManager().getShop(info.getLocation()) != null) {
            MsgUtil.sendMessage((CommandSender)p, "shop-already-owned", new String[0]);
            return;
        }
        if (Util.isDoubleChest(info.getLocation().getBlock().getBlockData()) && !QuickShop.getPermissionManager().hasPermission((CommandSender)p, "quickshop.create.double")) {
            MsgUtil.sendMessage((CommandSender)p, "no-double-chests", new String[0]);
            return;
        }
        if (!Util.canBeShop(info.getLocation().getBlock())) {
            MsgUtil.sendMessage((CommandSender)p, "chest-was-removed", new String[0]);
            return;
        }
        if (info.getLocation().getBlock().getType() == Material.ENDER_CHEST && !QuickShop.getPermissionManager().hasPermission((CommandSender)p, "quickshop.create.enderchest")) {
            return;
        }
        if (this.autoSign) {
            if (info.getSignBlock() == null) {
                if (!this.plugin.getConfig().getBoolean("shop.allow-shop-without-space-for-sign")) {
                    MsgUtil.sendMessage((CommandSender)p, "failed-to-put-sign", new String[0]);
                    return;
                }
            } else {
                Material signType = info.getSignBlock().getType();
                if (signType != Material.WATER && !Util.isAir(signType) && !this.plugin.getConfig().getBoolean("shop.allow-shop-without-space-for-sign")) {
                    MsgUtil.sendMessage((CommandSender)p, "failed-to-put-sign", new String[0]);
                    return;
                }
            }
        }
        try {
            price = Double.parseDouble(message);
            if (Double.isInfinite(price)) {
                MsgUtil.sendMessage((CommandSender)p, "exceeded-maximum", message);
                return;
            }
            String strFormat = new DecimalFormat("#.#########").format(Math.abs(price)).replace(",", ".");
            String[] processedDouble = strFormat.split("\\.");
            if (processedDouble.length > 1) {
                int maximumDigitsLimit = this.plugin.getConfig().getInt("maximum-digits-in-price", -1);
                if (processedDouble[1].length() > maximumDigitsLimit && maximumDigitsLimit != -1) {
                    MsgUtil.sendMessage((CommandSender)p, "digits-reach-the-limit", String.valueOf(maximumDigitsLimit));
                    return;
                }
            }
        }
        catch (NumberFormatException ex) {
            Util.debugLog(ex.getMessage());
            MsgUtil.sendMessage((CommandSender)p, "not-a-number", message);
            return;
        }
        boolean decFormat = this.plugin.getConfig().getBoolean("use-decimal-format");
        PriceLimiter.CheckResult priceCheckResult = this.priceLimiter.check(info.getItem(), price);
        switch (priceCheckResult.getStatus()) {
            case REACHED_PRICE_MIN_LIMIT: {
                MsgUtil.sendMessage((CommandSender)p, "price-too-cheap", decFormat ? MsgUtil.decimalFormat(this.priceLimiter.getMaxPrice()) : Double.toString(this.priceLimiter.getMinPrice()));
                return;
            }
            case REACHED_PRICE_MAX_LIMIT: {
                MsgUtil.sendMessage((CommandSender)p, "price-too-high", decFormat ? MsgUtil.decimalFormat(this.priceLimiter.getMaxPrice()) : Double.toString(this.priceLimiter.getMinPrice()));
                return;
            }
            case PRICE_RESTRICTED: {
                MsgUtil.sendMessage((CommandSender)p, "restricted-prices", Util.getItemStackName(info.getItem()), String.valueOf(priceCheckResult.getMin()), String.valueOf(priceCheckResult.getMax()));
                return;
            }
            case NOT_VALID: {
                MsgUtil.sendMessage((CommandSender)p, "not-a-number", message);
                return;
            }
            case NOT_A_WHOLE_NUMBER: {
                MsgUtil.sendMessage((CommandSender)p, "not-a-integer", message);
                return;
            }
        }
        if (!this.plugin.isAllowStack()) {
            info.getItem().setAmount(1);
        }
        ContainerShop shop = new ContainerShop(this.plugin, info.getLocation(), price, info.getItem(), new ShopModerator(p.getUniqueId()), false, ShopType.SELLING, new YamlConfiguration());
        if (!bypassProtectionChecks && !(result = this.plugin.getIntegrationHelper().callIntegrationsCanCreate(p, info.getLocation())).isSuccess()) {
            MsgUtil.sendMessage((CommandSender)p, "integrations-check-failed-create", result.getMessage());
            Util.debugLog("Cancelled by integrations: " + result);
            return;
        }
        ShopCreateEvent shopCreateEvent = new ShopCreateEvent(shop, p.getUniqueId());
        if (Util.fireCancellableEvent(shopCreateEvent)) {
            Util.debugLog("Cancelled by plugin");
            return;
        }
        double createCost = this.plugin.getConfig().getDouble("shop.cost");
        if (QuickShop.getPermissionManager().hasPermission((CommandSender)p, "quickshop.bypasscreatefee")) {
            createCost = 0.0;
        }
        if (createCost > 0.0 && !(economyTransaction = EconomyTransaction.builder().taxAccount(this.cacheTaxAccount).taxModifier(0.0).core(this.plugin.getEconomy()).from(p.getUniqueId()).to(null).amount(createCost).currency(this.plugin.getCurrency()).world(shop.getLocation().getWorld()).build()).failSafeCommit()) {
            if (economyTransaction.getSteps() == EconomyTransaction.TransactionSteps.CHECK) {
                MsgUtil.sendMessage((CommandSender)p, "you-cant-afford-a-new-shop", Objects.requireNonNull(this.format(createCost, shop.getLocation().getWorld(), shop.getCurrency())));
            } else {
                MsgUtil.sendMessage((CommandSender)p, "purchase-failed", new String[0]);
                this.plugin.getLogger().severe("EconomyTransaction Failed, last error:" + economyTransaction.getLastError());
                this.plugin.log("EconomyTransaction Failed, last error:" + economyTransaction.getLastError());
            }
            return;
        }
        this.createShop(shop, info);
        if (!this.plugin.getConfig().getBoolean("shop.lock")) {
            MsgUtil.sendMessage((CommandSender)p, "shops-arent-locked", new String[0]);
        }
        if (shop.isDoubleShop() && ((Shop)Objects.requireNonNull(nextTo = shop.getAttachedShop())).getPrice() > shop.getPrice()) {
            MsgUtil.sendMessage((CommandSender)p, "buying-more-than-selling", new String[0]);
        }
        if (shop.isRealDouble()) {
            shop.getAttachedShop().refresh();
        }
        shop.refresh();
    }

    @Deprecated
    public void actionSell(@NotNull Player p, @NotNull Economy eco, @NotNull Info info, @NotNull Shop shop, int amount) {
        Util.ensureThread(false);
        this.actionSell(p.getUniqueId(), (Inventory)p.getInventory(), eco, info, shop, amount);
    }

    public void actionSell(@NotNull UUID seller, @NotNull Inventory sellerInventory, @NotNull Economy eco, @NotNull Info info, @NotNull Shop shop, int amount) {
        Util.ensureThread(false);
        if (this.shopIsNotValid(seller, info, shop)) {
            return;
        }
        int stock = shop.getRemainingStock();
        if (stock == -1) {
            stock = 10000;
        }
        if (stock < amount) {
            MsgUtil.sendMessage(seller, "shop-stock-too-low", Integer.toString(stock), Util.getItemStackName(shop.getItem()));
            return;
        }
        if (amount < 1) {
            MsgUtil.sendMessage(seller, "negative-amount", new String[0]);
            return;
        }
        int pSpace = Util.countSpace(sellerInventory, shop.getItem());
        if (amount > pSpace) {
            MsgUtil.sendMessage(seller, "not-enough-space", String.valueOf(pSpace));
            return;
        }
        double taxModifier = this.getTax(shop, seller);
        double total = CalculateUtil.multiply(amount, shop.getPrice());
        ShopPurchaseEvent e = new ShopPurchaseEvent(shop, seller, sellerInventory, amount, total);
        if (Util.fireCancellableEvent(e)) {
            return;
        }
        total = e.getTotal();
        EconomyTransaction.EconomyTransactionBuilder builder = EconomyTransaction.builder().allowLoan(this.plugin.getConfig().getBoolean("shop.allow-economy-loan", false)).core(eco).from(seller).amount(total).taxModifier(taxModifier).taxAccount(this.cacheTaxAccount).world(shop.getLocation().getWorld()).currency(shop.getCurrency());
        EconomyTransaction transaction = !shop.isUnlimited() || this.plugin.getConfig().getBoolean("shop.pay-unlimited-shop-owners") && shop.isUnlimited() ? builder.to(shop.getOwner()).build() : builder.to(null).build();
        if (!transaction.failSafeCommit()) {
            if (transaction.getSteps() == EconomyTransaction.TransactionSteps.CHECK) {
                MsgUtil.sendMessage(seller, "you-cant-afford-to-buy", Objects.requireNonNull(this.format(total, shop.getLocation().getWorld(), shop.getCurrency())), Objects.requireNonNull(this.format(eco.getBalance(seller, shop.getLocation().getWorld(), shop.getCurrency()), shop.getLocation().getWorld(), shop.getCurrency())));
            } else {
                MsgUtil.sendMessage(seller, "purchase-failed", new String[0]);
                this.plugin.getLogger().severe("EconomyTransaction Failed, last error:" + transaction.getLastError());
                QuickShop.getInstance().log("EconomyTransaction Failed, last error:" + transaction.getLastError());
            }
            return;
        }
        Player player = this.plugin.getServer().getPlayer(seller);
        String msg = this.plugin.getConfig().getBoolean("show-tax") ? MsgUtil.getMessage(seller, "player-bought-from-your-store-tax", player != null ? player.getName() : seller.toString(), Integer.toString(amount * shop.getItem().getAmount()), Util.getItemStackName(shop.getItem()), Double.toString(total), Util.format(CalculateUtil.multiply(taxModifier, total), shop)) : MsgUtil.getMessage(seller, "player-bought-from-your-store", player != null ? player.getName() : seller.toString(), Integer.toString(amount * shop.getItem().getAmount()), Util.getItemStackName(shop.getItem()), Double.toString(total));
        if (stock == amount) {
            msg = msg + "\n" + MsgUtil.getMessage(seller, "shop-out-of-stock", Integer.toString(shop.getLocation().getBlockX()), Integer.toString(shop.getLocation().getBlockY()), Integer.toString(shop.getLocation().getBlockZ()), Util.getItemStackName(shop.getItem()));
        }
        MsgUtil.TransactionMessage transactionMessage = new MsgUtil.TransactionMessage(msg, Util.serialize(shop.getItem()), null);
        MsgUtil.send(shop, shop.getOwner(), transactionMessage);
        if (this.plugin.getConfig().getBoolean("shop.sending-stock-message-to-staffs")) {
            for (UUID staff : shop.getModerator().getStaffs()) {
                MsgUtil.send(shop, staff, transactionMessage);
            }
        }
        shop.sell(seller, sellerInventory, player != null ? player.getLocation() : shop.getLocation(), amount);
        MsgUtil.sendPurchaseSuccess(seller, shop, amount);
        ShopSuccessPurchaseEvent se = new ShopSuccessPurchaseEvent(shop, seller, sellerInventory, amount, total, taxModifier);
        this.plugin.getServer().getPluginManager().callEvent((Event)se);
    }

    public boolean shopIsNotValid(@NotNull UUID uuid, @NotNull Info info, @NotNull Shop shop) {
        Player player = this.plugin.getServer().getPlayer(uuid);
        return this.shopIsNotValid(player, info, shop);
    }

    private boolean shopIsNotValid(@Nullable Player p, @NotNull Info info, @NotNull Shop shop) {
        if (this.plugin.getEconomy() == null) {
            MsgUtil.sendDirectMessage((CommandSender)p, "Error: Economy system not loaded, type /qs main command to get details.");
            return true;
        }
        if (!Util.canBeShop(info.getLocation().getBlock())) {
            MsgUtil.sendMessage((CommandSender)p, "chest-was-removed", new String[0]);
            return true;
        }
        if (info.hasChanged(shop)) {
            MsgUtil.sendMessage((CommandSender)p, "shop-has-changed", new String[0]);
            return true;
        }
        return false;
    }

    private void actionTrade(@NotNull Player p, @NotNull Info info, @NotNull String message) {
        Util.ensureThread(false);
        if (this.plugin.getEconomy() == null) {
            MsgUtil.sendDirectMessage((CommandSender)p, "Error: Economy system not loaded, type /qs main command to get details.");
            return;
        }
        Result result = this.plugin.getIntegrationHelper().callIntegrationsCanTrade(p, info.getLocation());
        if (!result.isSuccess()) {
            MsgUtil.sendMessage((CommandSender)p, "integrations-check-failed-trade", result.getMessage());
            Util.debugLog("Cancel by integrations.");
            return;
        }
        Economy eco = this.plugin.getEconomy();
        Shop shop = this.plugin.getShopManager().getShop(info.getLocation());
        if (shop == null || !Util.canBeShop(info.getLocation().getBlock())) {
            MsgUtil.sendMessage((CommandSender)p, "chest-was-removed", new String[0]);
            return;
        }
        if (p.getGameMode() == GameMode.CREATIVE && this.plugin.getConfig().getBoolean("shop.disable-creative-mode-trading")) {
            MsgUtil.sendMessage((CommandSender)p, "trading-in-creative-mode-is-disabled", new String[0]);
            return;
        }
        if (info.hasChanged(shop)) {
            MsgUtil.sendMessage((CommandSender)p, "shop-has-changed", new String[0]);
            return;
        }
        if (shop.isBuying()) {
            int amount;
            if (StringUtils.isNumeric((String)message)) {
                amount = Integer.parseInt(message);
            } else if (message.equalsIgnoreCase(this.plugin.getConfig().getString("shop.word-for-trade-all-items", "all"))) {
                int shopHaveSpaces = Util.countSpace(((ContainerShop)shop).getInventory(), shop.getItem());
                int invHaveItems = Util.countItems((Inventory)p.getInventory(), shop.getItem());
                double ownerBalance = eco.getBalance(shop.getOwner(), shop.getLocation().getWorld(), shop.getCurrency());
                int ownerCanAfford = shop.getPrice() != 0.0 ? (int)(ownerBalance / shop.getPrice()) : Integer.MAX_VALUE;
                if (!shop.isUnlimited()) {
                    amount = Math.min(shopHaveSpaces, invHaveItems);
                    amount = Math.min(amount, ownerCanAfford);
                } else {
                    amount = Util.countItems((Inventory)p.getInventory(), shop.getItem());
                    if (this.plugin.getConfig().getBoolean("shop.pay-unlimited-shop-owners")) {
                        amount = Math.min(amount, ownerCanAfford);
                    }
                }
                if (amount < 1) {
                    if (shopHaveSpaces == 0) {
                        MsgUtil.sendMessage((CommandSender)p, "shop-has-no-space", Integer.toString(shopHaveSpaces), Util.getItemStackName(shop.getItem()));
                        return;
                    }
                    if (ownerCanAfford == 0 && (!shop.isUnlimited() || this.plugin.getConfig().getBoolean("shop.pay-unlimited-shop-owners"))) {
                        MsgUtil.sendMessage((CommandSender)p, "the-owner-cant-afford-to-buy-from-you", Objects.requireNonNull(this.format(shop.getPrice(), shop.getLocation().getWorld(), shop.getCurrency())), Objects.requireNonNull(this.format(ownerBalance, shop.getLocation().getWorld(), shop.getCurrency())));
                        return;
                    }
                    MsgUtil.sendMessage((CommandSender)p, "you-dont-have-that-many-items", Integer.toString(amount), Util.getItemStackName(shop.getItem()));
                    return;
                }
            } else {
                MsgUtil.sendMessage((CommandSender)p, "not-a-integer", message);
                Util.debugLog("Receive the chat " + message + " and it format failed: " + message);
                return;
            }
            this.actionBuy(p.getUniqueId(), (Inventory)p.getInventory(), eco, info, shop, amount);
        } else if (shop.isSelling()) {
            int amount;
            if (StringUtils.isNumeric((String)message)) {
                amount = Integer.parseInt(message);
            } else if (message.equalsIgnoreCase(this.plugin.getConfig().getString("shop.word-for-trade-all-items", "all"))) {
                int shopHaveItems = Util.countItems(((ContainerShop)shop).getInventory(), shop.getItem());
                int invHaveSpaces = Util.countSpace((Inventory)p.getInventory(), shop.getItem());
                amount = !shop.isUnlimited() ? Math.min(shopHaveItems, invHaveSpaces) : Util.countSpace((Inventory)p.getInventory(), shop.getItem());
                double price = shop.getPrice();
                double balance = eco.getBalance(p.getUniqueId(), shop.getLocation().getWorld(), shop.getCurrency());
                if ((amount = Math.min(amount, (int)Math.floor(balance / price))) < 1) {
                    if (!shop.isUnlimited() && shopHaveItems < 1) {
                        MsgUtil.sendMessage((CommandSender)p, "shop-stock-too-low", Integer.toString(shop.getRemainingStock()), Util.getItemStackName(shop.getItem()));
                    } else {
                        if (invHaveSpaces <= 0) {
                            MsgUtil.sendMessage((CommandSender)p, "not-enough-space", String.valueOf(invHaveSpaces));
                            return;
                        }
                        MsgUtil.sendMessage((CommandSender)p, "you-cant-afford-to-buy", Objects.requireNonNull(this.format(price, shop.getLocation().getWorld(), shop.getCurrency())), Objects.requireNonNull(this.format(balance, shop.getLocation().getWorld(), shop.getCurrency())));
                    }
                    return;
                }
            } else {
                MsgUtil.sendMessage((CommandSender)p, "not-a-integer", message);
                Util.debugLog("Receive the chat " + message + " and it format failed: " + message);
                return;
            }
            this.actionSell(p.getUniqueId(), (Inventory)p.getInventory(), eco, info, shop, amount);
        } else {
            MsgUtil.sendMessage((CommandSender)p, "shop-purchase-cancelled", new String[0]);
            this.plugin.getLogger().warning("Shop data broken? Loc:" + shop.getLocation());
        }
    }

    @Nullable
    private Shop getShopIncludeAttached_Fast(@NotNull Location loc, boolean fromAttach, boolean writeCache) {
        Shop shop = this.getShop(loc);
        if (shop == null) {
            Block block = loc.getBlock();
            if (!Util.isShoppables(block.getType())) {
                return null;
            }
            Block currentBlock = loc.getBlock();
            if (!fromAttach) {
                if (Util.isWallSign(currentBlock.getType())) {
                    Block attached = Util.getAttached(currentBlock);
                    if (attached != null) {
                        shop = this.getShopIncludeAttached_Fast(attached.getLocation(), true, writeCache);
                    }
                } else {
                    BlockState state = PaperLib.getBlockState(currentBlock, false).getState();
                    if (!(state instanceof Container)) {
                        return null;
                    }
                    @Nullable Block half = Util.getSecondHalf(currentBlock);
                    if (half != null) {
                        shop = this.getShop(half.getLocation());
                    }
                }
            }
        }
        if (this.plugin.getShopCache() != null && writeCache) {
            this.plugin.getShopCache().setCache(loc, shop);
        }
        return shop;
    }

    public void migrateOwnerToUnlimitedShopOwner(Shop shop) {
        shop.setOwner(this.cacheUnlimitedShopAccount.getUniqueId());
        shop.setSignText();
    }

    @Nullable
    public Trader getCacheTaxAccount() {
        return this.cacheTaxAccount;
    }

    public Trader getCacheUnlimitedShopAccount() {
        return this.cacheUnlimitedShopAccount;
    }

    public PriceLimiter getPriceLimiter() {
        return this.priceLimiter;
    }

    public class ShopIterator
    implements Iterator<Shop> {
        private final Iterator<Map<ShopChunk, Map<Location, Shop>>> worlds;
        private Iterator<Map<Location, Shop>> chunks;
        private Iterator<Shop> shops;

        public ShopIterator() {
            this.worlds = ShopManager.this.getShops().values().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.shops == null || !this.shops.hasNext()) {
                if (this.chunks == null || !this.chunks.hasNext()) {
                    if (!this.worlds.hasNext()) {
                        return false;
                    }
                    this.chunks = this.worlds.next().values().iterator();
                    return this.hasNext();
                }
                this.shops = this.chunks.next().values().iterator();
                return this.hasNext();
            }
            return true;
        }

        @Override
        @NotNull
        public Shop next() {
            if (this.shops == null || !this.shops.hasNext()) {
                if (this.chunks == null || !this.chunks.hasNext()) {
                    if (!this.worlds.hasNext()) {
                        throw new NoSuchElementException("No more shops to iterate over!");
                    }
                    this.chunks = this.worlds.next().values().iterator();
                }
                this.shops = this.chunks.next().values().iterator();
            }
            if (!this.shops.hasNext()) {
                return this.next();
            }
            return this.shops.next();
        }
    }
}

