/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.util;

import java.util.EnumMap;
import org.bukkit.configuration.ConfigurationSection;
import org.maxgamer.quickshop.QuickShop;

public class InteractUtil {
    private static final EnumMap<Action, Boolean> sneakingActionMap = new EnumMap(Action.class);
    private static Mode mode;
    private static boolean init;

    public static void init(ConfigurationSection configuration) {
        mode = Mode.getMode(configuration.getInt("shop.interact.interact-mode", 0));
        sneakingActionMap.put(Action.CREATE, configuration.getBoolean("shop.interact.sneak-to-create"));
        sneakingActionMap.put(Action.TRADE, configuration.getBoolean("shop.interact.sneak-to-trade"));
        sneakingActionMap.put(Action.CONTROL, configuration.getBoolean("shop.interact.sneak-to-control"));
        init = true;
    }

    public static boolean check(Action action, boolean isSneaking) {
        if (!init) {
            InteractUtil.init((ConfigurationSection)QuickShop.getInstance().getConfig());
        }
        boolean sneakAllowed = sneakingActionMap.get((Object)action);
        switch (mode) {
            case ONLY: {
                return sneakAllowed == isSneaking;
            }
            case BOTH: {
                return sneakAllowed || !isSneaking;
            }
            case REVERSED: {
                return !isSneaking || !sneakAllowed;
            }
        }
        return true;
    }

    public static enum Mode {
        ONLY,
        BOTH,
        REVERSED;


        public static Mode getMode(int mode) {
            return Mode.values().length > mode ? Mode.values()[mode] : ONLY;
        }
    }

    public static enum Action {
        CREATE,
        TRADE,
        CONTROL;

    }
}

