/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.util;

import com.google.common.collect.Maps;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import me.clip.placeholderapi.PlaceholderAPI;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.ServiceInjector;
import org.maxgamer.quickshop.database.WarpedResultSet;
import org.maxgamer.quickshop.event.ShopControlPanelOpenEvent;
import org.maxgamer.quickshop.file.HumanReadableJsonConfiguration;
import org.maxgamer.quickshop.file.newest.json.json.JsonConfiguration;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.util.ChatSheetPrinter;
import org.maxgamer.quickshop.util.InteractUtil;
import org.maxgamer.quickshop.util.JsonUtil;
import org.maxgamer.quickshop.util.RomanNumber;
import org.maxgamer.quickshop.util.Util;
import org.maxgamer.quickshop.util.language.game.GameLanguage;
import org.maxgamer.quickshop.util.language.game.MojangGameLanguageImpl;

public class MsgUtil {
    private static final String invaildMsg = "Invaild message";
    private static final Map<UUID, List<TransactionMessage>> outGoingPlayerMessages = Maps.newConcurrentMap();
    private static final DecimalFormat decimalFormat = MsgUtil.processFormat();
    public static GameLanguage gameLanguage;
    private static QuickShop plugin;
    private static YamlConfiguration enchi18n;
    private static boolean inited;
    private static YamlConfiguration itemi18n;
    private static JsonConfiguration messagei18n;
    private static YamlConfiguration potioni18n;
    private static JsonConfiguration builtInLang;
    private static JsonConfiguration builtInOriginalLang;

    private static DecimalFormat processFormat() {
        try {
            return new DecimalFormat(Objects.requireNonNull(QuickShop.getInstance().getConfig().getString("decimal-format")));
        }
        catch (Exception e) {
            QuickShop.getInstance().getLogger().log(Level.WARNING, "Error when processing decimal format, using system default: " + e.getMessage());
            return new DecimalFormat();
        }
    }

    public static void clean() {
        plugin.getLogger().info("Cleaning purchase messages from the database that are over a week old...");
        plugin.getDatabaseHelper().cleanMessage(System.currentTimeMillis() - 604800000L);
    }

    public static boolean flush(@NotNull OfflinePlayer p) {
        UUID pName;
        List<TransactionMessage> msgs;
        Player player = p.getPlayer();
        if (player != null && (msgs = outGoingPlayerMessages.get(pName = p.getUniqueId())) != null) {
            for (TransactionMessage msg : msgs) {
                if (p.getPlayer() == null) continue;
                Util.debugLog("Accepted the msg for player " + p.getName() + " : " + msg);
                if (msg.getHoverItem() == null) continue;
                try {
                    ItemStack data = Util.deserialize(msg.getHoverItem());
                    if (data == null) {
                        MsgUtil.sendDirectMessage((CommandSender)p.getPlayer(), msg.getMessage());
                        continue;
                    }
                    plugin.getQuickChat().sendItemHologramChat(player, msg.getMessage(), data);
                }
                catch (InvalidConfigurationException e) {
                    MsgUtil.sendDirectMessage((CommandSender)p.getPlayer(), msg.getMessage());
                }
            }
            plugin.getDatabaseHelper().cleanMessageForPlayer(pName);
            msgs.clear();
            return true;
        }
        return false;
    }

    public static String getItemi18n(@NotNull String itemBukkitName) {
        if (itemBukkitName.isEmpty()) {
            return "Item is empty";
        }
        String itemnameI18n = itemi18n.getString("itemi18n." + itemBukkitName);
        if (itemnameI18n != null && !itemnameI18n.isEmpty()) {
            return itemnameI18n;
        }
        Material material = Material.matchMaterial((String)itemBukkitName);
        if (material == null) {
            return "Material not exist";
        }
        return Util.prettifyText(material.name());
    }

    public static String getMessageOfflinePlayer(@NotNull String loc, @Nullable OfflinePlayer player, String ... args) {
        try {
            String raw = messagei18n.getString(loc);
            if (raw == null) {
                Util.debugLog("Missing language key: " + loc);
                return "Invaild message: " + loc;
            }
            String filled = MsgUtil.fillArgs(raw, args);
            if (player != null && plugin.getConfig().getBoolean("plugin.PlaceHolderAPI") && plugin.getPlaceHolderAPI() != null && plugin.getPlaceHolderAPI().isEnabled()) {
                filled = PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)filled);
                Util.debugLog("Processed message " + filled + " by PlaceHolderAPI.");
            }
            return filled;
        }
        catch (Exception th) {
            plugin.getSentryErrorReporter().ignoreThrow();
            plugin.getLogger().log(Level.WARNING, "Failed to process messages", th);
            return "Cannot load language key: " + loc + " because something not right, check the console for details.";
        }
    }

    public static String fillArgs(@Nullable String raw, String ... args) {
        if (StringUtils.isEmpty((String)raw)) {
            return "";
        }
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                raw = StringUtils.replace((String)raw, (String)("{" + i + "}"), (String)(args[i] == null ? "" : args[i]));
            }
        }
        return raw;
    }

    public static void loadGameLanguage(@NotNull String languageCode) {
        gameLanguage = ServiceInjector.getGameLanguage(new MojangGameLanguageImpl(plugin, languageCode));
    }

    public static void loadI18nFile() throws InvalidConfigurationException {
        String messageCodeInFile;
        plugin = QuickShop.getInstance();
        plugin.getLogger().info("Loading plugin translations files...");
        MsgUtil.loadGameLanguage(plugin.getConfig().getString("game-language", "default"));
        String languageCode = plugin.getConfig().getString("language", "en-US").replace("_", "-");
        File extractedMessageFile = new File(plugin.getDataFolder(), "messages.json");
        String buildInMessageFilePath = "lang/" + languageCode + "/messages.json";
        if (plugin.getResource(buildInMessageFilePath) == null) {
            buildInMessageFilePath = "lang-original/messages.json";
        }
        if (!extractedMessageFile.exists()) {
            try {
                Files.copy(Objects.requireNonNull(plugin.getResource(buildInMessageFilePath)), extractedMessageFile.toPath(), new CopyOption[0]);
            }
            catch (IOException ioException) {
                plugin.getLogger().log(Level.WARNING, "Cannot extract the messages.json file", ioException);
            }
        }
        HumanReadableJsonConfiguration messageFile = HumanReadableJsonConfiguration.loadConfiguration(extractedMessageFile);
        File oldMsgFile = new File(plugin.getDataFolder(), "messages.yml");
        if (oldMsgFile.exists()) {
            plugin.getLogger().info("Converting the old format message.yml to message.json...");
            plugin.getLanguage().saveFile(languageCode, "messages", "messages.json");
            YamlConfiguration oldMsgI18n = YamlConfiguration.loadConfiguration((File)oldMsgFile);
            for (String key : oldMsgI18n.getKeys(true)) {
                messageFile.set(key, oldMsgI18n.get(key));
            }
            try {
                messageFile.save(extractedMessageFile);
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
            try {
                Files.move(oldMsgFile.toPath(), new File(plugin.getDataFolder(), "messages.yml.bak").toPath(), new CopyOption[0]);
            }
            catch (IOException ioException) {
                // empty catch block
            }
            if (oldMsgFile.exists()) {
                oldMsgFile.delete();
            }
            plugin.getLogger().info("Successfully converted, Continue loading...");
        } else {
            Util.debugLog("Loading language file from exist file...");
            if (!extractedMessageFile.exists()) {
                plugin.getLanguage().saveFile(languageCode, "messages", "messages.json");
                messageFile.loadFromString(Util.readToString(new File(plugin.getDataFolder(), "messages.json").getAbsolutePath()));
                messageFile.set("language-name", languageCode);
            }
        }
        File buildInLangFile = new File(Util.getCacheFolder(), "bulitin-messages.json");
        messagei18n = messageFile;
        try {
            if (buildInLangFile.exists()) {
                buildInLangFile.delete();
            }
            Files.copy(Objects.requireNonNull(plugin.getResource(buildInMessageFilePath)), buildInLangFile.toPath(), new CopyOption[0]);
        }
        catch (IOException ioException) {
            Util.debugLog("Cannot load default built-in language file: " + ioException.getMessage());
        }
        builtInLang = HumanReadableJsonConfiguration.loadConfiguration(buildInLangFile);
        try (InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(plugin.getResource("lang-original/messages.json")));){
            builtInOriginalLang = HumanReadableJsonConfiguration.loadConfiguration(inputStreamReader);
        }
        catch (IOException | NullPointerException exception) {
            plugin.getLogger().log(Level.WARNING, "Cannot to load built-in original messages, some phrases may missing when upgrading", exception);
        }
        if (StringUtils.isEmpty((String)messagei18n.getString("language-name"))) {
            MsgUtil.setAndUpdate("language-name");
        }
        if (!Objects.equals(messageCodeInFile = messagei18n.getString("language-name"), languageCode)) {
            String backupFileName = "messages-bak-" + UUID.randomUUID() + ".json";
            Util.debugLog("Language name " + messageCodeInFile + " not matched with " + languageCode + ", replacing with build-in files and renaming current file to " + backupFileName);
            plugin.getLogger().warning("Language name " + messageCodeInFile + " not matched with " + languageCode + ", replacing with build-in files and renaming current file to " + backupFileName);
            File pending = new File(plugin.getDataFolder(), "messages.json");
            try {
                Files.move(pending.toPath(), new File(plugin.getDataFolder(), backupFileName).toPath(), new CopyOption[0]);
                plugin.getLanguage().saveFile(languageCode, "messages", "messages.json");
                messagei18n.loadFromString(Util.readToString(new File(plugin.getDataFolder(), "messages.json").getAbsolutePath()));
                messagei18n.set("language-name", languageCode);
            }
            catch (IOException e) {
                plugin.getLogger().log(Level.SEVERE, "Failed to backup and save language file", e);
            }
        }
        int ver = 0;
        String strVer = messagei18n.getString("language-version");
        if (StringUtils.isNumeric((String)strVer) && !StringUtils.isEmpty((String)strVer)) {
            ver = Integer.parseInt(strVer);
        }
        if (ver == 0) {
            messagei18n.set("language-version", 1);
        } else {
            messagei18n.set("language-version", ver);
        }
        MsgUtil.updateMessages(messagei18n.getInt("language-version"));
        messagei18n.loadFromString(Util.parseColours(messagei18n.saveToString()));
        if (!inited) {
            plugin.getLogger().info(MsgUtil.getMessage("translation-author", null, new String[0]));
            plugin.getLogger().info(MsgUtil.getMessage("translation-contributors", null, new String[0]));
            plugin.getLogger().info(MsgUtil.getMessage("translation-country", null, new String[0]));
            inited = true;
        }
        try {
            messagei18n.save(extractedMessageFile);
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    public static void loadEnchi18n() {
        Enchantment[] enchsi18n;
        plugin.getLogger().info("Loading enchantments translations...");
        File enchi18nFile = new File(plugin.getDataFolder(), "enchi18n.yml");
        if (!enchi18nFile.exists()) {
            plugin.getLogger().info("Creating enchi18n.yml");
            plugin.saveResource("enchi18n.yml", false);
        }
        enchi18n = YamlConfiguration.loadConfiguration((File)enchi18nFile);
        enchi18n.options().copyDefaults(false);
        YamlConfiguration enchi18nYAML = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Objects.requireNonNull(plugin.getResource("enchi18n.yml"))));
        enchi18n.setDefaults((Configuration)enchi18nYAML);
        Util.parseColours(enchi18n);
        for (Enchantment ench : enchsi18n = Enchantment.values()) {
            String enchi18nString = enchi18n.getString("enchi18n." + ench.getKey().getKey().trim());
            if (enchi18nString != null && !enchi18nString.isEmpty()) continue;
            String enchName = gameLanguage.getEnchantment(ench);
            enchi18n.set("enchi18n." + ench.getKey().getKey(), (Object)enchName);
            plugin.getLogger().info("Found new ench [" + enchName + "] , adding it to the config...");
        }
        try {
            enchi18n.save(enchi18nFile);
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.WARNING, "Could not load/save transaction enchname from enchi18n.yml. Skipping...", e);
        }
    }

    public static void loadItemi18n() {
        Material[] itemsi18n;
        plugin.getLogger().info("Loading items translations...");
        File itemi18nFile = new File(plugin.getDataFolder(), "itemi18n.yml");
        if (!itemi18nFile.exists()) {
            plugin.getLogger().info("Creating itemi18n.yml");
            plugin.saveResource("itemi18n.yml", false);
        }
        itemi18n = YamlConfiguration.loadConfiguration((File)itemi18nFile);
        itemi18n.options().copyDefaults(false);
        YamlConfiguration itemi18nYAML = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Objects.requireNonNull(plugin.getResource("itemi18n.yml"))));
        itemi18n.setDefaults((Configuration)itemi18nYAML);
        Util.parseColours(itemi18n);
        for (Material material : itemsi18n = Material.values()) {
            String itemi18nString = itemi18n.getString("itemi18n." + material.name());
            if (itemi18nString != null && !itemi18nString.isEmpty()) continue;
            String itemName = gameLanguage.getItem(material);
            itemi18n.set("itemi18n." + material.name(), (Object)itemName);
            plugin.getLogger().info("Found new items/blocks [" + itemName + "] , adding it to the config...");
        }
        try {
            itemi18n.save(itemi18nFile);
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.WARNING, "Could not load/save transaction itemname from itemi18n.yml. Skipping...", e);
        }
    }

    public static void loadPotioni18n() {
        plugin.getLogger().info("Loading potions translations...");
        File potioni18nFile = new File(plugin.getDataFolder(), "potioni18n.yml");
        if (!potioni18nFile.exists()) {
            plugin.getLogger().info("Creating potioni18n.yml");
            plugin.saveResource("potioni18n.yml", false);
        }
        potioni18n = YamlConfiguration.loadConfiguration((File)potioni18nFile);
        potioni18n.options().copyDefaults(false);
        YamlConfiguration potioni18nYAML = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Objects.requireNonNull(plugin.getResource("potioni18n.yml"))));
        potioni18n.setDefaults((Configuration)potioni18nYAML);
        Util.parseColours(potioni18n);
        for (PotionEffectType potion : PotionEffectType.values()) {
            String potionI18n;
            if (potion == null || (potionI18n = potioni18n.getString("potioni18n." + potion.getName())) != null && !potionI18n.isEmpty()) continue;
            String potionName = gameLanguage.getPotion(potion);
            plugin.getLogger().info("Found new potion [" + potionName + "] , adding it to the config...");
            potioni18n.set("potioni18n." + potion.getName(), (Object)potionName);
        }
        try {
            potioni18n.save(potioni18nFile);
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.WARNING, "Could not load/save transaction potionname from potioni18n.yml. Skipping...", e);
        }
    }

    public static void loadTransactionMessages() {
        outGoingPlayerMessages.clear();
        try (WarpedResultSet warpRS = plugin.getDatabaseHelper().selectAllMessages();
             ResultSet rs = warpRS.getResultSet();){
            while (rs.next()) {
                String owner = rs.getString("owner");
                UUID ownerUUID = Util.isUUID(owner) ? UUID.fromString(owner) : Bukkit.getOfflinePlayer((String)owner).getUniqueId();
                String message = rs.getString("message");
                List msgs = outGoingPlayerMessages.computeIfAbsent(ownerUUID, k -> new LinkedList());
                msgs.add(TransactionMessage.fromJson(message));
            }
        }
        catch (SQLException e) {
            plugin.getLogger().log(Level.WARNING, "Could not load transaction messages from database. Skipping.", e);
        }
    }

    @Deprecated
    public static void sendColoredMessage(@NotNull CommandSender sender, @NotNull ChatColor chatColor, String ... messages) {
        for (String message : messages) {
            MsgUtil.sendDirectMessage(sender, chatColor + message);
        }
    }

    @Deprecated
    public static void send(@NotNull UUID player, @NotNull TransactionMessage transactionMessage, boolean isUnlimited) {
        if (isUnlimited && plugin.getConfig().getBoolean("shop.ignore-unlimited-shop-messages")) {
            return;
        }
        Util.debugLog(transactionMessage.getMessage());
        OfflinePlayer p = Bukkit.getOfflinePlayer((UUID)player);
        if (!p.isOnline()) {
            List msgs = outGoingPlayerMessages.getOrDefault(player, new LinkedList());
            msgs.add(transactionMessage);
            outGoingPlayerMessages.put(player, msgs);
            plugin.getDatabaseHelper().sendMessage(player, transactionMessage.toJson(), System.currentTimeMillis());
        } else if (p.getPlayer() != null) {
            if (transactionMessage.getHoverItem() != null) {
                try {
                    plugin.getQuickChat().sendItemHologramChat(p.getPlayer(), transactionMessage.getMessage(), Objects.requireNonNull(Util.deserialize(transactionMessage.getHoverItem())));
                }
                catch (Exception any) {
                    Util.debugLog("Unknown error, send by plain text.");
                    MsgUtil.sendDirectMessage((CommandSender)p.getPlayer(), transactionMessage.getMessage());
                }
            } else {
                MsgUtil.sendDirectMessage((CommandSender)p.getPlayer(), transactionMessage.getMessage());
            }
        }
    }

    public static void send(@NotNull Shop shop, @NotNull UUID player, @NotNull TransactionMessage transactionMessage) {
        if (shop.isUnlimited() && plugin.getConfig().getBoolean("shop.ignore-unlimited-shop-messages")) {
            return;
        }
        Util.debugLog(transactionMessage.getMessage());
        OfflinePlayer p = Bukkit.getOfflinePlayer((UUID)player);
        if (!p.isOnline()) {
            List msgs = outGoingPlayerMessages.getOrDefault(player, new LinkedList());
            msgs.add(transactionMessage);
            outGoingPlayerMessages.put(player, msgs);
            plugin.getDatabaseHelper().sendMessage(player, transactionMessage.toJson(), System.currentTimeMillis());
        } else if (p.getPlayer() != null) {
            if (transactionMessage.getHoverItem() != null) {
                try {
                    plugin.getQuickChat().sendItemHologramChat(p.getPlayer(), transactionMessage.getMessage(), Objects.requireNonNull(Util.deserialize(transactionMessage.getHoverItem())));
                }
                catch (Exception any) {
                    Util.debugLog("Unknown error, send by plain text.");
                    MsgUtil.sendDirectMessage((CommandSender)p.getPlayer(), transactionMessage.getMessage());
                }
            } else {
                MsgUtil.sendDirectMessage((CommandSender)p.getPlayer(), transactionMessage.getMessage());
            }
        }
    }

    @NotNull
    public static String getSubString(@NotNull String text, @NotNull String left, @NotNull String right) {
        int zLen;
        zLen = left.isEmpty() ? 0 : ((zLen = text.indexOf(left)) > -1 ? (zLen += left.length()) : 0);
        int yLen = text.indexOf(right, zLen);
        if (yLen < 0 || right.isEmpty()) {
            yLen = text.length();
        }
        String result = text.substring(zLen, yLen);
        return result;
    }

    public static void sendControlPanelInfo(@NotNull CommandSender sender, @NotNull Shop shop) {
        String clickCommand;
        String hoverText;
        String text;
        if (!(!(sender instanceof Player) || QuickShop.getPermissionManager().hasPermission(sender, "quickshop.use") || !shop.getOwner().equals(((Player)sender).getUniqueId()) && QuickShop.getPermissionManager().hasPermission(sender, "quickshop.other.control") || InteractUtil.check(InteractUtil.Action.CONTROL, ((Player)sender).isSneaking()))) {
            return;
        }
        if (Util.fireCancellableEvent(new ShopControlPanelOpenEvent(shop, sender))) {
            Util.debugLog("ControlPanel blocked by 3rd-party");
            return;
        }
        plugin.getShopManager().bakeShopRuntimeRandomUniqueIdCache(shop);
        ChatSheetPrinter chatSheetPrinter = new ChatSheetPrinter(sender);
        chatSheetPrinter.printHeader();
        chatSheetPrinter.printLine(MsgUtil.getMessage("controlpanel.infomation", sender, new String[0]));
        if (!QuickShop.getPermissionManager().hasPermission(sender, "quickshop.setowner")) {
            chatSheetPrinter.printLine(MsgUtil.getMessage("menu.owner", sender, shop.ownerName()));
        } else {
            chatSheetPrinter.printSuggestedCmdLine(MsgUtil.getMessage("controlpanel.setowner", sender, shop.ownerName() + (plugin.getConfig().getBoolean("shop.show-owner-uuid-in-controlpanel-if-op") && shop.isUnlimited() ? " (" + shop.getOwner() + ")" : "")), MsgUtil.getMessage("controlpanel.setowner-hover", sender, new String[0]), "/qs setowner ");
        }
        if (QuickShop.getPermissionManager().hasPermission(sender, "quickshop.unlimited")) {
            text = MsgUtil.getMessage("controlpanel.unlimited", sender, MsgUtil.bool2String(shop.isUnlimited()));
            hoverText = MsgUtil.getMessage("controlpanel.unlimited-hover", sender, new String[0]);
            clickCommand = MsgUtil.fillArgs("/qs silentunlimited {0}", shop.getRuntimeRandomUniqueId().toString());
            chatSheetPrinter.printExecutableCmdLine(text, hoverText, clickCommand);
        }
        if (QuickShop.getPermissionManager().hasPermission(sender, "quickshop.create.buy") && QuickShop.getPermissionManager().hasPermission(sender, "quickshop.create.sell")) {
            if (shop.isSelling()) {
                text = MsgUtil.getMessage("controlpanel.mode-selling", sender, new String[0]);
                hoverText = MsgUtil.getMessage("controlpanel.mode-selling-hover", sender, new String[0]);
                clickCommand = MsgUtil.fillArgs("/qs silentbuy {0}", shop.getRuntimeRandomUniqueId().toString());
                chatSheetPrinter.printExecutableCmdLine(text, hoverText, clickCommand);
            } else if (shop.isBuying()) {
                text = MsgUtil.getMessage("controlpanel.mode-buying", sender, new String[0]);
                hoverText = MsgUtil.getMessage("controlpanel.mode-buying-hover", sender, new String[0]);
                clickCommand = MsgUtil.fillArgs("/qs silentsell {0}", shop.getRuntimeRandomUniqueId().toString());
                chatSheetPrinter.printExecutableCmdLine(text, hoverText, clickCommand);
            }
        }
        if (QuickShop.getPermissionManager().hasPermission(sender, "quickshop.other.price") || shop.getOwner().equals(((OfflinePlayer)sender).getUniqueId())) {
            text = MsgUtil.fillArgs(MsgUtil.getMessage("controlpanel.price", sender, new String[0]), plugin.getConfig().getBoolean("use-decimal-format") ? MsgUtil.decimalFormat(shop.getPrice()) : Double.toString(shop.getPrice()));
            hoverText = MsgUtil.getMessage("controlpanel.price-hover", sender, new String[0]);
            clickCommand = "/qs price ";
            chatSheetPrinter.printSuggestedCmdLine(text, hoverText, clickCommand);
        }
        if (QuickShop.getInstance().isAllowStack() && (QuickShop.getPermissionManager().hasPermission(sender, "quickshop.other.amount") || shop.getOwner().equals(((OfflinePlayer)sender).getUniqueId()) && QuickShop.getPermissionManager().hasPermission(sender, "quickshop.create.changeamount"))) {
            text = MsgUtil.getMessage("controlpanel.stack", sender, Integer.toString(shop.getItem().getAmount()));
            hoverText = MsgUtil.getMessage("controlpanel.stack-hover", sender, new String[0]);
            clickCommand = "/qs size ";
            chatSheetPrinter.printSuggestedCmdLine(text, hoverText, clickCommand);
        }
        if (!shop.isUnlimited()) {
            if (QuickShop.getPermissionManager().hasPermission(sender, "quickshop.refill")) {
                text = MsgUtil.getMessage("controlpanel.refill", sender, String.valueOf(shop.getPrice()));
                hoverText = MsgUtil.getMessage("controlpanel.refill-hover", sender, new String[0]);
                clickCommand = "/qs refill ";
                chatSheetPrinter.printSuggestedCmdLine(text, hoverText, clickCommand);
            }
            if (QuickShop.getPermissionManager().hasPermission(sender, "quickshop.empty")) {
                text = MsgUtil.getMessage("controlpanel.empty", sender, String.valueOf(shop.getPrice()));
                hoverText = MsgUtil.getMessage("controlpanel.empty-hover", sender, new String[0]);
                clickCommand = MsgUtil.fillArgs("/qs silentempty {0}", shop.getRuntimeRandomUniqueId().toString());
                chatSheetPrinter.printExecutableCmdLine(text, hoverText, clickCommand);
            }
        }
        if (QuickShop.getPermissionManager().hasPermission(sender, "quickshop.other.destroy") || shop.getOwner().equals(((OfflinePlayer)sender).getUniqueId())) {
            text = MsgUtil.getMessage("controlpanel.remove", sender, String.valueOf(shop.getPrice()));
            hoverText = MsgUtil.getMessage("controlpanel.remove-hover", sender, new String[0]);
            clickCommand = MsgUtil.fillArgs("/qs silentremove {0}", shop.getRuntimeRandomUniqueId().toString());
            chatSheetPrinter.printExecutableCmdLine(text, hoverText, clickCommand);
        }
        chatSheetPrinter.printFooter();
    }

    public static String getMessage(@NotNull String loc, @Nullable CommandSender player, Object ... args) {
        String[] strings = new String[args.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = Objects.toString(args[i]);
        }
        return MsgUtil.getMessage(loc, player, strings);
    }

    public static String getMessage(@NotNull UUID uuid, @NotNull String loc, String ... args) {
        return MsgUtil.getMessage(loc, (CommandSender)Bukkit.getPlayer((UUID)uuid), args);
    }

    public static String getMessage(@NotNull String loc, @Nullable CommandSender player, String ... args) {
        try {
            String filled;
            block8: {
                String raw = messagei18n.getString(loc);
                if (raw == null) {
                    Util.debugLog("ERR: MsgUtil cannot find the the phrase at " + loc + ", printing the all readed datas: " + (Object)((Object)messagei18n));
                    return MsgUtil.fillArgs(loc, args);
                }
                filled = MsgUtil.fillArgs(raw, args);
                if (player instanceof OfflinePlayer && plugin.getPlaceHolderAPI() != null && plugin.getPlaceHolderAPI().isEnabled() && plugin.getConfig().getBoolean("plugin.PlaceHolderAPI")) {
                    try {
                        filled = PlaceholderAPI.setPlaceholders((OfflinePlayer)((OfflinePlayer)player), (String)filled);
                    }
                    catch (Exception ignored) {
                        if (((OfflinePlayer)player).getPlayer() == null) break block8;
                        try {
                            filled = PlaceholderAPI.setPlaceholders((Player)((OfflinePlayer)player).getPlayer(), (String)filled);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            return filled;
        }
        catch (Throwable th) {
            th.printStackTrace();
            plugin.getSentryErrorReporter().ignoreThrow();
            plugin.getLogger().log(Level.WARNING, "Failed to load language key", th);
            return "Cannot load language key: " + loc + " because something not right, check the console for details.";
        }
    }

    public static String bool2String(boolean bool) {
        if (bool) {
            return MsgUtil.getMessage("booleanformat.success", null, new String[0]);
        }
        return MsgUtil.getMessage("booleanformat.failed", null, new String[0]);
    }

    public static String decimalFormat(double value) {
        return decimalFormat.format(value);
    }

    public static void sendGlobalAlert(@Nullable String content) {
        if (content == null) {
            Util.debugLog("Content is null");
            Throwable throwable = new Throwable("Known issue: Global Alert accepted null string, what the fuck");
            plugin.getSentryErrorReporter().sendError(throwable, "NullCheck");
            return;
        }
        MsgUtil.sendMessageToOps(content);
        plugin.getLogger().warning(content);
        plugin.log(content);
    }

    public static void sendMessageToOps(@NotNull String message) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!QuickShop.getPermissionManager().hasPermission((CommandSender)player, "quickshop.alerts")) continue;
            MsgUtil.sendDirectMessage((CommandSender)player, message);
        }
    }

    public static void sendPurchaseSuccess(@NotNull UUID purchaser, @NotNull Shop shop, int amount) {
        Player sender = Bukkit.getPlayer((UUID)purchaser);
        if (sender == null) {
            return;
        }
        ChatSheetPrinter chatSheetPrinter = new ChatSheetPrinter((CommandSender)sender);
        chatSheetPrinter.printHeader();
        chatSheetPrinter.printLine(MsgUtil.getMessage("menu.successful-purchase", (CommandSender)sender, new String[0]));
        chatSheetPrinter.printLine(MsgUtil.getMessage("menu.item-name-and-price", (CommandSender)sender, Integer.toString(amount * shop.getItem().getAmount()), Util.getItemStackName(shop.getItem()), Util.format((double)amount * shop.getPrice(), shop)));
        MsgUtil.printEnchantment(sender, shop, chatSheetPrinter);
        chatSheetPrinter.printFooter();
    }

    public static String getEnchi18n(@NotNull Enchantment key) {
        String enchString = key.getKey().getKey();
        if (enchString.isEmpty()) {
            return "Enchantment key is empty";
        }
        String enchI18n = enchi18n.getString("enchi18n." + enchString);
        if (enchI18n != null && !enchI18n.isEmpty()) {
            return enchI18n;
        }
        return Util.prettifyText(enchString);
    }

    public static void sendSellSuccess(@NotNull UUID seller, @NotNull Shop shop, int amount) {
        Player sender = Bukkit.getPlayer((UUID)seller);
        if (sender == null) {
            return;
        }
        ChatSheetPrinter chatSheetPrinter = new ChatSheetPrinter((CommandSender)sender);
        chatSheetPrinter.printHeader();
        chatSheetPrinter.printLine(MsgUtil.getMessage("menu.successfully-sold", (CommandSender)sender, new String[0]));
        chatSheetPrinter.printLine(MsgUtil.getMessage("menu.item-name-and-price", (CommandSender)sender, Integer.toString(amount), Util.getItemStackName(shop.getItem()), Util.format((double)amount * shop.getPrice(), shop)));
        if (plugin.getConfig().getBoolean("show-tax")) {
            double tax = plugin.getConfig().getDouble("tax");
            double total = (double)amount * shop.getPrice();
            if (tax != 0.0) {
                if (!seller.equals(shop.getOwner())) {
                    chatSheetPrinter.printLine(MsgUtil.getMessage("menu.sell-tax", (CommandSender)sender, Util.format(tax * total, shop)));
                } else {
                    chatSheetPrinter.printLine(MsgUtil.getMessage("menu.sell-tax-self", (CommandSender)sender, new String[0]));
                }
            }
        }
        MsgUtil.printEnchantment(sender, shop, chatSheetPrinter);
        chatSheetPrinter.printFooter();
    }

    private static void printEnchantment(@NotNull Player p, @NotNull Shop shop, ChatSheetPrinter chatSheetPrinter) {
        if (shop.getItem().hasItemMeta() && shop.getItem().getItemMeta().hasItemFlag(ItemFlag.HIDE_ENCHANTS) && plugin.getConfig().getBoolean("respect-item-flag")) {
            return;
        }
        Map<Enchantment, Integer> enchs = new HashMap();
        if (shop.getItem().hasItemMeta() && shop.getItem().getItemMeta().hasEnchants()) {
            enchs = shop.getItem().getItemMeta().getEnchants();
        }
        if (!enchs.isEmpty()) {
            chatSheetPrinter.printCenterLine(MsgUtil.getMessage("menu.enchants", (CommandSender)p, new String[0]));
            MsgUtil.printEnchantment(chatSheetPrinter, enchs);
        }
        if (shop.getItem().getItemMeta() instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta stor = (EnchantmentStorageMeta)shop.getItem().getItemMeta();
            stor.getStoredEnchants();
            enchs = stor.getStoredEnchants();
            if (!enchs.isEmpty()) {
                chatSheetPrinter.printCenterLine(MsgUtil.getMessage("menu.stored-enchants", (CommandSender)p, new String[0]));
                MsgUtil.printEnchantment(chatSheetPrinter, enchs);
            }
        }
    }

    private static void printEnchantment(ChatSheetPrinter chatSheetPrinter, Map<Enchantment, Integer> enchs) {
        for (Map.Entry<Enchantment, Integer> entries : enchs.entrySet()) {
            Integer level = entries.getValue();
            chatSheetPrinter.printLine(ChatColor.YELLOW + MsgUtil.getEnchi18n(entries.getKey()) + " " + RomanNumber.toRoman(level == null ? 1 : level));
        }
    }

    public static void sendShopInfo(@NotNull Player p, @NotNull Shop shop) {
        ItemStack items = shop.getItem();
        ChatSheetPrinter chatSheetPrinter = new ChatSheetPrinter((CommandSender)p);
        chatSheetPrinter.printHeader();
        chatSheetPrinter.printLine(MsgUtil.getMessage("menu.shop-information", (CommandSender)p, new String[0]));
        chatSheetPrinter.printLine(MsgUtil.getMessage("menu.owner", (CommandSender)p, shop.ownerName()));
        plugin.getQuickChat().send((CommandSender)p, plugin.getQuickChat().getItemHologramChat(shop, items, p, ChatColor.DARK_PURPLE + MsgUtil.getMessage("tableformat.left_begin", (CommandSender)p, new String[0]) + MsgUtil.getMessage("menu.item", (CommandSender)p, Util.getItemStackName(items)) + "  "));
        if (Util.isTool(items.getType())) {
            chatSheetPrinter.printLine(MsgUtil.getMessage("menu.damage-percent-remaining", (CommandSender)p, Util.getToolPercentage(items)));
        }
        if (shop.isSelling()) {
            if (shop.getRemainingStock() == -1) {
                chatSheetPrinter.printLine(MsgUtil.getMessage("menu.stock", (CommandSender)p, MsgUtil.getMessage("signs.unlimited", (CommandSender)p, new String[0])));
            } else {
                chatSheetPrinter.printLine(MsgUtil.getMessage("menu.stock", (CommandSender)p, Integer.toString(shop.getRemainingStock())));
            }
        } else if (shop.getRemainingSpace() == -1) {
            chatSheetPrinter.printLine(MsgUtil.getMessage("menu.space", (CommandSender)p, MsgUtil.getMessage("signs.unlimited", (CommandSender)p, new String[0])));
        } else {
            chatSheetPrinter.printLine(MsgUtil.getMessage("menu.space", (CommandSender)p, Integer.toString(shop.getRemainingSpace())));
        }
        if (shop.getItem().getAmount() == 1) {
            chatSheetPrinter.printLine(MsgUtil.getMessage("menu.price-per", (CommandSender)p, Util.getItemStackName(shop.getItem()), Util.format(shop.getPrice(), shop)));
        } else {
            chatSheetPrinter.printLine(MsgUtil.getMessage("menu.price-per-stack", (CommandSender)p, Util.getItemStackName(shop.getItem()), Util.format(shop.getPrice(), shop), Integer.toString(shop.getItem().getAmount())));
        }
        if (shop.isBuying()) {
            chatSheetPrinter.printLine(MsgUtil.getMessage("menu.this-shop-is-buying", (CommandSender)p, new String[0]));
        } else {
            chatSheetPrinter.printLine(MsgUtil.getMessage("menu.this-shop-is-selling", (CommandSender)p, new String[0]));
        }
        MsgUtil.printEnchantment(p, shop, chatSheetPrinter);
        if (items.getItemMeta() instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)items.getItemMeta();
            PotionEffectType potionEffectType = potionMeta.getBasePotionData().getType().getEffectType();
            if (potionEffectType != null) {
                chatSheetPrinter.printLine(MsgUtil.getMessage("menu.effects", (CommandSender)p, new String[0]));
                chatSheetPrinter.printLine(ChatColor.YELLOW + MsgUtil.getPotioni18n(potionEffectType));
            }
            for (PotionEffect potionEffect : potionMeta.getCustomEffects()) {
                chatSheetPrinter.printLine(ChatColor.YELLOW + MsgUtil.getPotioni18n(potionEffect.getType()));
            }
        }
        chatSheetPrinter.printFooter();
    }

    public static String getPotioni18n(@NotNull PotionEffectType potion) {
        String potionString = potion.getName().trim();
        if (potionString.isEmpty()) {
            return "Potion name is empty.";
        }
        String potionI18n = potioni18n.getString("potioni18n." + potionString);
        if (potionI18n != null && !potionI18n.isEmpty()) {
            return potionI18n;
        }
        return Util.prettifyText(potionString);
    }

    public static JsonConfiguration getI18nFile() {
        return messagei18n;
    }

    public static void debugStackTrace(StackTraceElement[] traces) {
        if (Util.isDisableDebugLogger()) {
            return;
        }
        for (StackTraceElement stackTraceElement : traces) {
            String className = stackTraceElement.getClassName();
            String methodName = stackTraceElement.getMethodName();
            int codeLine = stackTraceElement.getLineNumber();
            String fileName = stackTraceElement.getFileName();
            Util.debugLog("[TRACE]  [" + className + "] [" + methodName + "] (" + fileName + ":" + codeLine + ") ");
        }
    }

    private static void updateMessages(int selectedVersion) {
        if (selectedVersion == 0) {
            selectedVersion = 1;
        }
        if (selectedVersion == 1) {
            MsgUtil.setAndUpdate("shop-not-exist");
            MsgUtil.setAndUpdate("controlpanel.infomation");
            MsgUtil.setAndUpdate("controlpanel.setowner");
            MsgUtil.setAndUpdate("controlpanel.setowner-hover");
            MsgUtil.setAndUpdate("controlpanel.unlimited");
            MsgUtil.setAndUpdate("controlpanel.unlimited-hover");
            MsgUtil.setAndUpdate("controlpanel.mode-selling");
            MsgUtil.setAndUpdate("controlpanel.mode-selling-hover");
            MsgUtil.setAndUpdate("controlpanel.mode-buying");
            MsgUtil.setAndUpdate("controlpanel.mode-buying-hover");
            MsgUtil.setAndUpdate("controlpanel.price");
            MsgUtil.setAndUpdate("controlpanel.price-hover");
            MsgUtil.setAndUpdate("controlpanel.refill");
            MsgUtil.setAndUpdate("controlpanel.refill-hover");
            MsgUtil.setAndUpdate("controlpanel.empty");
            MsgUtil.setAndUpdate("controlpanel.empty-hover");
            MsgUtil.setAndUpdate("controlpanel.remove");
            MsgUtil.setAndUpdate("controlpanel.remove-hover");
            MsgUtil.setAndUpdate("language-version", 2);
            selectedVersion = 2;
        }
        if (selectedVersion == 2) {
            MsgUtil.setAndUpdate("command.no-target-given");
            MsgUtil.setAndUpdate("command.description.debug");
            MsgUtil.setAndUpdate("no-permission-remove-shop");
            MsgUtil.setAndUpdate("language-version", 3);
            selectedVersion = 3;
        }
        if (selectedVersion == 3) {
            MsgUtil.setAndUpdate("signs.unlimited");
            MsgUtil.setAndUpdate("controlpanel.sign.owner.line1");
            MsgUtil.setAndUpdate("controlpanel.sign.owner.line2");
            MsgUtil.setAndUpdate("controlpanel.sign.owner.line3");
            MsgUtil.setAndUpdate("controlpanel.sign.owner.line4");
            MsgUtil.setAndUpdate("controlpanel.sign.price.line1");
            MsgUtil.setAndUpdate("controlpanel.sign.price.line2");
            MsgUtil.setAndUpdate("controlpanel.sign.price.line3");
            MsgUtil.setAndUpdate("controlpanel.sign.price.line4");
            MsgUtil.setAndUpdate("controlpanel.sign.refill.line1");
            MsgUtil.setAndUpdate("controlpanel.sign.refill.line2");
            MsgUtil.setAndUpdate("controlpanel.sign.refill.line3");
            MsgUtil.setAndUpdate("controlpanel.sign.refill.line4");
            MsgUtil.setAndUpdate("language-version", 4);
            selectedVersion = 4;
        }
        if (selectedVersion == 4) {
            MsgUtil.setAndUpdate("signs.unlimited");
            MsgUtil.setAndUpdate("controlpanel.sign", null);
            MsgUtil.setAndUpdate("language-version", 5);
            selectedVersion = 5;
        }
        if (selectedVersion == 5) {
            MsgUtil.setAndUpdate("command.description.fetchmessage");
            MsgUtil.setAndUpdate("nothing-to-flush");
            MsgUtil.setAndUpdate("language-version", 6);
            selectedVersion = 6;
        }
        if (selectedVersion == 6) {
            MsgUtil.setAndUpdate("command.description.info");
            MsgUtil.setAndUpdate("command.description.debug");
            MsgUtil.setAndUpdate("break-shop-use-supertool");
            MsgUtil.setAndUpdate("no-creative-break");
            MsgUtil.setAndUpdate("command.now-debuging");
            MsgUtil.setAndUpdate("command.now-nolonger-debuging");
            MsgUtil.setAndUpdate("language-version", 7);
            selectedVersion = 7;
        }
        if (selectedVersion == 7) {
            MsgUtil.setAndUpdate("failed-to-put-sign");
            MsgUtil.setAndUpdate("language-version", 8);
            selectedVersion = 8;
        }
        if (selectedVersion == 8) {
            MsgUtil.setAndUpdate("failed-to-paste");
            MsgUtil.setAndUpdate("warn-to-paste");
            MsgUtil.setAndUpdate("command.description.paste");
            MsgUtil.setAndUpdate("language-version", 9);
            selectedVersion = 9;
        }
        if (selectedVersion == 9) {
            MsgUtil.setAndUpdate("controlpanel.commands.setowner");
            MsgUtil.setAndUpdate("controlpanel.commands.unlimited");
            MsgUtil.setAndUpdate("controlpanel.commands.buy");
            MsgUtil.setAndUpdate("controlpanel.commands.sell");
            MsgUtil.setAndUpdate("controlpanel.commands.price");
            MsgUtil.setAndUpdate("controlpanel.commands.refill");
            MsgUtil.setAndUpdate("controlpanel.commands.empty");
            MsgUtil.setAndUpdate("controlpanel.commands.remove");
            MsgUtil.setAndUpdate("tableformat.full_line");
            MsgUtil.setAndUpdate("tableformat.left_half_line");
            MsgUtil.setAndUpdate("tableformat.right_half_line");
            MsgUtil.setAndUpdate("tableformat.left_begin");
            MsgUtil.setAndUpdate("booleanformat.success");
            MsgUtil.setAndUpdate("booleanformat.failed");
            MsgUtil.setAndUpdate("language-version", 10);
            selectedVersion = 10;
        }
        if (selectedVersion == 10) {
            MsgUtil.setAndUpdate("price-too-high");
            MsgUtil.setAndUpdate("language-version", 11);
            selectedVersion = 11;
        }
        if (selectedVersion == 11) {
            MsgUtil.setAndUpdate("unknown-player");
            MsgUtil.setAndUpdate("shop-staff-cleared");
            MsgUtil.setAndUpdate("shop-staff-added");
            MsgUtil.setAndUpdate("shop-staff-deleted");
            MsgUtil.setAndUpdate("command.wrong-args");
            MsgUtil.setAndUpdate("command.description.staff");
            MsgUtil.setAndUpdate("unknown-player");
            MsgUtil.setAndUpdate("language-version", 12);
            selectedVersion = 12;
        }
        if (selectedVersion == 12) {
            MsgUtil.setAndUpdate("menu.commands.preview");
            MsgUtil.setAndUpdate("shop-staff-cleared");
            MsgUtil.setAndUpdate("shop-staff-added");
            MsgUtil.setAndUpdate("shop-staff-deleted");
            MsgUtil.setAndUpdate("command.wrong-args");
            MsgUtil.setAndUpdate("command.description.staff");
            MsgUtil.setAndUpdate("unknown-player");
            MsgUtil.setAndUpdate("language-version", 13);
            selectedVersion = 13;
        }
        if (selectedVersion == 13) {
            MsgUtil.setAndUpdate("no-permission-build");
            MsgUtil.setAndUpdate("success-change-owner-to-server");
            MsgUtil.setAndUpdate("updatenotify.buttontitle");
            MsgUtil.setAndUpdate("updatenotify.list");
            MsgUtil.setAndUpdate("language-version", 14);
            selectedVersion = 14;
        }
        if (selectedVersion == 14) {
            MsgUtil.setAndUpdate("flush-finished");
            MsgUtil.setAndUpdate("language-version", 15);
            selectedVersion = 15;
        }
        if (selectedVersion == 15) {
            MsgUtil.setAndUpdate("purchase-failed");
            MsgUtil.setAndUpdate("language-version", 16);
            selectedVersion = 16;
        }
        if (selectedVersion == 16) {
            MsgUtil.setAndUpdate("command.description.owner");
            MsgUtil.setAndUpdate("command.description.remove");
            MsgUtil.setAndUpdate("command.description.amount");
            MsgUtil.setAndUpdate("command.description.about");
            MsgUtil.setAndUpdate("command.description.help");
            MsgUtil.setAndUpdate("no-pending-action");
            MsgUtil.setAndUpdate("language-version", 17);
            selectedVersion = 17;
        }
        if (selectedVersion == 17) {
            MsgUtil.setAndUpdate("updatenotify.onekeybuttontitle");
            MsgUtil.setAndUpdate("language-version", 18);
            selectedVersion = 18;
        }
        if (selectedVersion == 18) {
            MsgUtil.setAndUpdate("command.description.supercreate");
            MsgUtil.setAndUpdate("language-version", 19);
            selectedVersion = 19;
        }
        if (selectedVersion == 19) {
            MsgUtil.setAndUpdate("permission-denied-3rd-party");
            MsgUtil.setAndUpdate("updatenotify.remote-disable-warning");
            MsgUtil.setAndUpdate("language-version", 20);
            selectedVersion = 20;
        }
        if (selectedVersion == 20) {
            MsgUtil.setAndUpdate("how-many-buy");
            MsgUtil.setAndUpdate("how-many-sell");
            MsgUtil.setAndUpdate("updatenotify.label.unstable");
            MsgUtil.setAndUpdate("updatenotify.label.stable");
            MsgUtil.setAndUpdate("updatenotify.label.lts");
            MsgUtil.setAndUpdate("updatenotify.label.qualityverifyed");
            MsgUtil.setAndUpdate("updatenotify.label.github");
            MsgUtil.setAndUpdate("updatenotify.label.spigotmc");
            MsgUtil.setAndUpdate("updatenotify.label.bukkitdev");
            MsgUtil.setAndUpdate("language-version", 21);
            selectedVersion = 21;
        }
        if (selectedVersion == 21) {
            MsgUtil.setAndUpdate("shop-removed-cause-ongoing-fee");
            MsgUtil.setAndUpdate("language-version", 22);
            selectedVersion = 22;
        }
        if (selectedVersion == 22) {
            MsgUtil.setAndUpdate("not-a-number");
            MsgUtil.setAndUpdate("not-a-integer");
            MsgUtil.setAndUpdate("language-version", 23);
            selectedVersion = 23;
        }
        if (selectedVersion == 23) {
            MsgUtil.setAndUpdate("command.toggle-unlimited.unlimited");
            MsgUtil.setAndUpdate("command.toggle-unlimited.limited");
            MsgUtil.setAndUpdate("language-version", 24);
            selectedVersion = 24;
        }
        if (selectedVersion == 24) {
            MsgUtil.setAndUpdate("digits-reach-the-limit");
            MsgUtil.setAndUpdate("language-version", 25);
            selectedVersion = 25;
        }
        if (selectedVersion == 25) {
            MsgUtil.setAndUpdate("complete");
            MsgUtil.setAndUpdate("language-version", 26);
            selectedVersion = 26;
        }
        if (selectedVersion == 26) {
            MsgUtil.setAndUpdate("updatenotify.label.master");
            MsgUtil.setAndUpdate("language-version", 27);
            selectedVersion = 27;
        }
        if (selectedVersion == 27) {
            MsgUtil.setAndUpdate("quickshop-gui-preview");
            MsgUtil.setAndUpdate("shops-recovering");
            MsgUtil.setAndUpdate("shops-backingup");
            MsgUtil.setAndUpdate("saved-to-path");
            MsgUtil.setAndUpdate("backup-failed");
            MsgUtil.setAndUpdate("translate-not-completed-yet-click");
            MsgUtil.setAndUpdate("translate-not-completed-yet-url");
            MsgUtil.setAndUpdate("language-info-panel.name");
            MsgUtil.setAndUpdate("language-info-panel.code");
            MsgUtil.setAndUpdate("language-info-panel.progress");
            MsgUtil.setAndUpdate("language-info-panel.help");
            MsgUtil.setAndUpdate("language-info-panel.translate-on-crowdin");
            MsgUtil.setAndUpdate("not-managed-shop");
            MsgUtil.setAndUpdate("language-version", 28);
            selectedVersion = 28;
        }
        if (selectedVersion == 28) {
            MsgUtil.setAndUpdate("quickshop-gui-preview");
            MsgUtil.setAndUpdate("shops-recovering");
            MsgUtil.setAndUpdate("shops-backingup");
            MsgUtil.setAndUpdate("saved-to-path");
            MsgUtil.setAndUpdate("backup-failed");
            MsgUtil.setAndUpdate("translate-not-completed-yet-click");
            MsgUtil.setAndUpdate("translate-not-completed-yet-url");
            MsgUtil.setAndUpdate("language-info-panel.name");
            MsgUtil.setAndUpdate("language-info-panel.code");
            MsgUtil.setAndUpdate("language-info-panel.progress");
            MsgUtil.setAndUpdate("language-info-panel.help");
            MsgUtil.setAndUpdate("language-info-panel.translate-on-crowdin");
            MsgUtil.setAndUpdate("not-managed-shop");
            MsgUtil.setAndUpdate("language-version", 29);
            selectedVersion = 29;
        }
        if (selectedVersion == 29) {
            MsgUtil.setAndUpdate("3rd-plugin-build-check-failed");
            MsgUtil.setAndUpdate("language-version", 30);
            selectedVersion = 30;
        }
        if (selectedVersion == 30) {
            MsgUtil.setAndUpdate("no-creative-break");
            MsgUtil.setAndUpdate("trading-in-creative-mode-is-disabled");
            MsgUtil.setAndUpdate("supertool-is-disabled");
            MsgUtil.setAndUpdate("language-version", 31);
            selectedVersion = 31;
        }
        if (selectedVersion == 31) {
            MsgUtil.setAndUpdate("menu.shop-stack");
            MsgUtil.setAndUpdate("command.description.language");
            MsgUtil.setAndUpdate("signs.stack-price");
            MsgUtil.setAndUpdate("controlpanel.commands.stack");
            MsgUtil.setAndUpdate("controlpanel.stack");
            MsgUtil.setAndUpdate("controlpanel.stack-hover");
            MsgUtil.setAndUpdate("shop-now-freezed");
            MsgUtil.setAndUpdate("shop-nolonger-freezed");
            MsgUtil.setAndUpdate("shop-freezed-at-location");
            MsgUtil.setAndUpdate("shop-cannot-trade-when-freezing");
            MsgUtil.setAndUpdate("denied-put-in-item");
            MsgUtil.setAndUpdate("how-many-buy-stack");
            MsgUtil.setAndUpdate("how-many-sell-stack");
            MsgUtil.setAndUpdate("lang.name");
            MsgUtil.setAndUpdate("lang.code");
            MsgUtil.setAndUpdate("lang.translate-progress");
            MsgUtil.setAndUpdate("lang.approval-progress");
            MsgUtil.setAndUpdate("lang.qa-issues");
            MsgUtil.setAndUpdate("lang.help-us");
            MsgUtil.setAndUpdate("language-version", 32);
            selectedVersion = 32;
        }
        if (selectedVersion == 32) {
            MsgUtil.setAndUpdate("signs.stack-selling");
            MsgUtil.setAndUpdate("signs.stack-buying");
            MsgUtil.setAndUpdate("menu.price-per-stack");
            MsgUtil.setAndUpdate("menu.shop-stack");
            MsgUtil.setAndUpdate("language-version", 33);
            selectedVersion = 33;
        }
        if (selectedVersion == 33) {
            MsgUtil.setAndUpdate("integrations-check-failed-create");
            MsgUtil.setAndUpdate("integrations-check-failed-trade");
            MsgUtil.setAndUpdate("language-version", 34);
            selectedVersion = 34;
        }
        if (selectedVersion == 34) {
            MsgUtil.setAndUpdate("how-many-buy-stack");
            MsgUtil.setAndUpdate("how-many-sell-stack");
            MsgUtil.setAndUpdate("language-version", 35);
            selectedVersion = 35;
        }
        if (selectedVersion == 35) {
            MsgUtil.setAndUpdate("menu.price-per-stack");
            MsgUtil.setAndUpdate("signs.stack-price");
            MsgUtil.setAndUpdate("controlpanel.stack");
            MsgUtil.setAndUpdate("controlpanel.stack-hover");
            MsgUtil.setAndUpdate("controlpanel.commands.stack");
            MsgUtil.setAndUpdate("controlpanel.item");
            MsgUtil.setAndUpdate("controlpanel.item-hover");
            MsgUtil.setAndUpdate("controlpanel.commands.item");
            MsgUtil.setAndUpdate("how-much-to-trade-for");
            MsgUtil.setAndUpdate("command.bulk-size-not-set");
            MsgUtil.setAndUpdate("command.bulk-size-now");
            MsgUtil.setAndUpdate("command.invalid-bulk-amount");
            MsgUtil.setAndUpdate("command.description.size");
            MsgUtil.setAndUpdate("command.no-trade-item");
            MsgUtil.setAndUpdate("command.trade-item-now");
            MsgUtil.setAndUpdate("command.description.item");
            MsgUtil.setAndUpdate("item-holochat-error");
            MsgUtil.setAndUpdate("shop-stack");
            MsgUtil.setAndUpdate("language-version", 36);
            selectedVersion = 36;
        }
        if (selectedVersion == 36) {
            MsgUtil.setAndUpdate("menu.price-per-stack");
            MsgUtil.setAndUpdate("command.trade-item-now");
            MsgUtil.setAndUpdate("command.bulk-size-now");
            MsgUtil.setAndUpdate("how-much-to-trade-for");
            MsgUtil.setAndUpdate("language-version", 37);
            selectedVersion = 37;
        }
        if (selectedVersion == 37) {
            MsgUtil.setAndUpdate("signs.stack-price");
            MsgUtil.setAndUpdate("command.some-shops-removed");
            MsgUtil.setAndUpdate("command.description.removeall");
            MsgUtil.setAndUpdate("command.no-owner-given");
            MsgUtil.setAndUpdate("language-version", 38);
            selectedVersion = 38;
        }
        if (selectedVersion == 38) {
            MsgUtil.setAndUpdate("integrations-check-failed-create");
            MsgUtil.setAndUpdate("integrations-check-failed-trade");
            MsgUtil.setAndUpdate("3rd-plugin-build-check-failed");
            MsgUtil.setAndUpdate("language-version", 39);
            selectedVersion = 39;
        }
        if (selectedVersion == 39) {
            MsgUtil.setAndUpdate("command.transfer-success");
            MsgUtil.setAndUpdate("command.transfer-success-other");
            MsgUtil.setAndUpdate("command.description.transfer");
            MsgUtil.setAndUpdate("language-version", 40);
            selectedVersion = 40;
        }
        if (selectedVersion == 40) {
            MsgUtil.setAndUpdate("controlpanel.commands", null);
            MsgUtil.setAndUpdate("menu.commands", null);
            MsgUtil.setAndUpdate("language-version", 41);
            selectedVersion = 41;
        }
        if (selectedVersion == 41) {
            MsgUtil.setAndUpdate("shops-removed-in-world");
            MsgUtil.setAndUpdate("command.description.removeworld");
            MsgUtil.setAndUpdate("command.no-world-given");
            MsgUtil.setAndUpdate("world-not-exists");
            MsgUtil.setAndUpdate("language-version", 42);
            selectedVersion = 42;
        }
        if (selectedVersion == 42) {
            MsgUtil.setAndUpdate("player-bought-from-your-store-tax");
            MsgUtil.setAndUpdate("player-bought-from-your-store");
            MsgUtil.setAndUpdate("language-version", 43);
            selectedVersion = 43;
        }
        if (selectedVersion == 43) {
            MsgUtil.setAndUpdate("nearby-shop-this-way", null);
            MsgUtil.setAndUpdate("nearby-shop-header");
            MsgUtil.setAndUpdate("nearby-shop-entry");
            MsgUtil.setAndUpdate("language-version", ++selectedVersion);
        }
        if (selectedVersion == 44) {
            MsgUtil.setAndUpdate("nearby-shop-this-way");
            MsgUtil.setAndUpdate("language-version", ++selectedVersion);
        }
        if (selectedVersion == 45) {
            MsgUtil.setAndUpdate("exceeded-maximum");
            MsgUtil.setAndUpdate("language-version", ++selectedVersion);
        }
        if (selectedVersion == 46) {
            MsgUtil.setAndUpdate("currency-not-exists");
            MsgUtil.setAndUpdate("currency-set");
            MsgUtil.setAndUpdate("currency-unset");
            MsgUtil.setAndUpdate("command.description.currency");
            MsgUtil.setAndUpdate("controlpanel.currency");
            MsgUtil.setAndUpdate("controlpanel.currency-hover");
            MsgUtil.setAndUpdate("currency-not-support");
            MsgUtil.setAndUpdate("language-version", ++selectedVersion);
        }
        if (selectedVersion == 47) {
            MsgUtil.setAndUpdate("forbidden-vanilla-behavior");
            MsgUtil.setAndUpdate("language-version", ++selectedVersion);
        }
        if (selectedVersion == 48) {
            MsgUtil.setAndUpdate("tabcomplete.currency");
            MsgUtil.setAndUpdate("tabcomplete.item");
            MsgUtil.setAndUpdate("item-not-exist");
            MsgUtil.setAndUpdate("language-version", ++selectedVersion);
        }
        if (selectedVersion == 49) {
            MsgUtil.setAndUpdate("backup-success");
            MsgUtil.setAndUpdate("console-only");
            MsgUtil.setAndUpdate("console-only-danger");
            MsgUtil.setAndUpdate("clean-warning");
            MsgUtil.setAndUpdate("command.disabled");
            MsgUtil.setAndUpdate("command.feature-not-enabled");
            MsgUtil.setAndUpdate("language-version", ++selectedVersion);
        }
        if (selectedVersion == 50) {
            MsgUtil.setAndUpdate("signs.header");
            MsgUtil.setAndUpdate("signs.status-available");
            MsgUtil.setAndUpdate("signs.status-unavailable");
            MsgUtil.setAndUpdate("language-version", ++selectedVersion);
        }
        if (selectedVersion == 51) {
            MsgUtil.setAndUpdate("signs.out-of-stock");
            MsgUtil.setAndUpdate("signs.out-of-space");
            MsgUtil.setAndUpdate("command.description.ban");
            MsgUtil.setAndUpdate("command.description.unban");
            MsgUtil.setAndUpdate("command.description.freeze");
            MsgUtil.setAndUpdate("command.description.lock");
            MsgUtil.setAndUpdate("controlpanel.lock");
            MsgUtil.setAndUpdate("controlpanel.lock-hover");
            MsgUtil.setAndUpdate("controlpanel.freeze");
            MsgUtil.setAndUpdate("controlpanel.freeze-hover");
            MsgUtil.setAndUpdate("language-version", ++selectedVersion);
        }
        if (selectedVersion == 52) {
            MsgUtil.setAndUpdate("shop-creation-failed");
            MsgUtil.setAndUpdate("language-version", ++selectedVersion);
        }
        if (selectedVersion == 53) {
            MsgUtil.setAndUpdate("language-version", ++selectedVersion);
        }
        if (selectedVersion == 54) {
            MsgUtil.setAndUpdate("shop-owner-self-trade");
            MsgUtil.setAndUpdate("language-version", ++selectedVersion);
        }
        if (selectedVersion == 55) {
            MsgUtil.setAndUpdate("chest-title");
            MsgUtil.setAndUpdate("language-version", ++selectedVersion);
        }
        if (selectedVersion == 56) {
            MsgUtil.setAndUpdate("command-type-mismatch");
            MsgUtil.setAndUpdate("unlimited-shop-owner-keeped");
            MsgUtil.setAndUpdate("unlimited-shop-owner-changed");
            MsgUtil.setAndUpdate("server-crash-warning");
            MsgUtil.setAndUpdate("language-version", ++selectedVersion);
        }
        if (selectedVersion == 57) {
            MsgUtil.setAndUpdate("not-a-integer");
            MsgUtil.setAndUpdate("language-version", ++selectedVersion);
        }
        MsgUtil.setAndUpdate("_comment", "Please edit this file after format with json formatter");
    }

    private static void setAndUpdate(@NotNull String path, @Nullable Object object) {
        messagei18n.set(path, object);
    }

    private static void setAndUpdate(@NotNull String path) {
        Object alt = null;
        if (builtInLang != null) {
            alt = builtInLang.get(path);
        }
        if (alt == null && builtInOriginalLang != null) {
            alt = builtInOriginalLang.get(path);
        }
        if (alt == null) {
            messagei18n.set(path, "Missing no: " + path);
        } else {
            messagei18n.set(path, alt);
        }
    }

    public static void sendDirectMessage(@NotNull UUID sender, String ... messages) {
        MsgUtil.sendDirectMessage((CommandSender)Bukkit.getPlayer((UUID)sender), messages);
    }

    public static void sendDirectMessage(@Nullable CommandSender sender, String ... messages) {
        if (messages == null) {
            Util.debugLog("INFO: null messages trying to be sent.");
            return;
        }
        if (sender == null) {
            Util.debugLog("INFO: Sending message to null sender.");
            return;
        }
        for (String msg : messages) {
            try {
                if (StringUtils.isEmpty((String)msg)) continue;
                plugin.getQuickChat().send(sender, msg);
            }
            catch (Throwable throwable) {
                Util.debugLog("Failed to send formatted text.");
                if (StringUtils.isEmpty((String)msg)) continue;
                sender.sendMessage(msg);
            }
        }
    }

    public static void sendMessage(@Nullable CommandSender sender, @Nullable String key, String ... args) {
        if (sender == null) {
            Util.debugLog("INFO: Sending message to null sender.");
            return;
        }
        if (StringUtils.isEmpty((String)key)) {
            Util.debugLog("INFO: Message key is empty.");
            return;
        }
        String message = MsgUtil.getMessage(key, sender, args);
        if (StringUtils.isEmpty((String)message)) {
            return;
        }
        try {
            plugin.getQuickChat().send(sender, message);
        }
        catch (Throwable throwable) {
            Util.debugLog("Failed to send formatted text.");
            sender.sendMessage(message);
        }
    }

    public static void sendMessage(@Nullable UUID uuid, @Nullable String key, String ... args) {
        if (uuid == null) {
            return;
        }
        MsgUtil.sendMessage((CommandSender)Bukkit.getPlayer((UUID)uuid), key, args);
    }

    public static boolean isJson(String str) {
        try {
            new JsonParser().parse(str);
            return true;
        }
        catch (JsonParseException exception) {
            return false;
        }
    }

    public static YamlConfiguration getEnchi18n() {
        return enchi18n;
    }

    public static YamlConfiguration getItemi18n() {
        return itemi18n;
    }

    public static YamlConfiguration getPotioni18n() {
        return potioni18n;
    }

    static {
        plugin = QuickShop.getInstance();
    }

    public static class TransactionMessage {
        @NotNull
        private String message;
        @Nullable
        private String hoverItem;
        @Nullable
        private String hoverText;

        @NotNull
        public static TransactionMessage fromJson(String json) {
            block6: {
                try {
                    if (MsgUtil.isJson(json)) {
                        return (TransactionMessage)JsonUtil.getGson().fromJson(json, TransactionMessage.class);
                    }
                }
                catch (Exception ignored) {
                    String[] msgData = json.split("##########");
                    if (msgData.length != 3) break block6;
                    try {
                        ItemStack data = Util.deserialize(msgData[1]);
                        if (data != null) {
                            return new TransactionMessage(msgData[0] + Util.getItemStackName(data) + msgData[2], msgData[1], null);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return new TransactionMessage(json, null, null);
                }
            }
            return new TransactionMessage(json, null, null);
        }

        @NotNull
        public String toJson() {
            return JsonUtil.getGson().toJson((Object)this);
        }

        public static TransactionMessageBuilder builder() {
            return new TransactionMessageBuilder();
        }

        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Nullable
        public String getHoverItem() {
            return this.hoverItem;
        }

        @Nullable
        public String getHoverText() {
            return this.hoverText;
        }

        public void setMessage(@NotNull String message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
        }

        public void setHoverItem(@Nullable String hoverItem) {
            this.hoverItem = hoverItem;
        }

        public void setHoverText(@Nullable String hoverText) {
            this.hoverText = hoverText;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransactionMessage)) {
                return false;
            }
            TransactionMessage other = (TransactionMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$hoverItem = this.getHoverItem();
            String other$hoverItem = other.getHoverItem();
            if (this$hoverItem == null ? other$hoverItem != null : !this$hoverItem.equals(other$hoverItem)) {
                return false;
            }
            String this$hoverText = this.getHoverText();
            String other$hoverText = other.getHoverText();
            return !(this$hoverText == null ? other$hoverText != null : !this$hoverText.equals(other$hoverText));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TransactionMessage;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $hoverItem = this.getHoverItem();
            result = result * 59 + ($hoverItem == null ? 43 : $hoverItem.hashCode());
            String $hoverText = this.getHoverText();
            result = result * 59 + ($hoverText == null ? 43 : $hoverText.hashCode());
            return result;
        }

        public String toString() {
            return "MsgUtil.TransactionMessage(message=" + this.getMessage() + ", hoverItem=" + this.getHoverItem() + ", hoverText=" + this.getHoverText() + ")";
        }

        public TransactionMessage(@NotNull String message, @Nullable String hoverItem, @Nullable String hoverText) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
            this.hoverItem = hoverItem;
            this.hoverText = hoverText;
        }

        public static class TransactionMessageBuilder {
            private String message;
            private String hoverItem;
            private String hoverText;

            TransactionMessageBuilder() {
            }

            public TransactionMessageBuilder message(@NotNull String message) {
                this.message = message;
                return this;
            }

            public TransactionMessageBuilder hoverItem(@Nullable String hoverItem) {
                this.hoverItem = hoverItem;
                return this;
            }

            public TransactionMessageBuilder hoverText(@Nullable String hoverText) {
                this.hoverText = hoverText;
                return this;
            }

            public TransactionMessage build() {
                return new TransactionMessage(this.message, this.hoverItem, this.hoverText);
            }

            public String toString() {
                return "MsgUtil.TransactionMessage.TransactionMessageBuilder(message=" + this.message + ", hoverItem=" + this.hoverItem + ", hoverText=" + this.hoverText + ")";
            }
        }
    }
}

