/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.util;

import com.griefcraft.lwc.LWC;
import com.griefcraft.lwc.LWCPlugin;
import com.griefcraft.model.Protection;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.event.ProtectionCheckStatus;
import org.maxgamer.quickshop.event.ShopProtectionCheckEvent;
import org.maxgamer.quickshop.eventmanager.BukkitEventManager;
import org.maxgamer.quickshop.eventmanager.QSEventManager;
import org.maxgamer.quickshop.eventmanager.QuickEventManager;
import org.maxgamer.quickshop.util.Util;
import org.maxgamer.quickshop.util.holder.Result;
import org.primesoft.blockshub.BlocksHubBukkit;

public class PermissionChecker {
    private final QuickShop plugin;
    private final boolean usePermissionChecker;
    private final QuickEventManager eventManager;

    public PermissionChecker(@NotNull QuickShop plugin) {
        this.plugin = plugin;
        this.usePermissionChecker = this.plugin.getConfig().getBoolean("shop.protection-checking");
        this.eventManager = plugin.getConfig().getInt("shop.protection-checking-handler") == 1 ? new QSEventManager(plugin) : new BukkitEventManager();
        plugin.getLogger().info("EventManager selected: " + this.eventManager.getClass().getSimpleName());
    }

    public Result canBuild(@NotNull Player player, @NotNull Location location) {
        return this.canBuild(player, location.getBlock());
    }

    public Result canBuild(final @NotNull Player player, final @NotNull Block block) {
        Protection protection;
        LWCPlugin lwc;
        LWC lwcInstance;
        if (this.plugin.getConfig().getStringList("shop.protection-checking-blacklist").contains(block.getWorld().getName())) {
            Util.debugLog("Skipping protection checking in world " + block.getWorld().getName() + " causing it in blacklist.");
            return Result.SUCCESS;
        }
        if (this.plugin.getLwcPlugin() != null && (lwcInstance = (lwc = (LWCPlugin)this.plugin.getLwcPlugin()).getLWC()) != null && (protection = lwcInstance.findProtection(block.getLocation())) != null && !protection.isOwner(player)) {
            Util.debugLog("LWC reporting player no permission to access this block.");
            return new Result("LWC");
        }
        if (this.plugin.getBlockHubPlugin() != null) {
            BlocksHubBukkit blocksHubBukkit = (BlocksHubBukkit)this.plugin.getBlockHubPlugin();
            boolean bhCanBuild = blocksHubBukkit.getApi().hasAccess(player.getUniqueId(), blocksHubBukkit.getApi().getWorld(block.getWorld().getName()), (double)block.getX(), (double)block.getY(), (double)block.getZ());
            if (this.plugin.getConfig().getBoolean("plugin.BlockHub.only")) {
                Util.debugLog("BlockHub only mode response: " + bhCanBuild);
                return new Result("BlockHub");
            }
            if (!bhCanBuild) {
                Util.debugLog("BlockHub reporting player no permission to access this region.");
                return new Result("BlockHub");
            }
        }
        if (!this.usePermissionChecker) {
            return Result.SUCCESS;
        }
        final Result isCanBuild = new Result();
        final BlockBreakEvent beMainHand = new BlockBreakEvent(block, player){

            public void setCancelled(boolean cancel) {
                if (cancel && !this.isCancelled()) {
                    Util.debugLog("An plugin blocked the protection checking event! See this stacktrace:");
                    for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
                        Util.debugLog(element.getClassName() + "." + element.getMethodName() + "(" + element.getLineNumber() + ")");
                    }
                    isCanBuild.setMessage(Thread.currentThread().getStackTrace()[2].getClassName());
                    block1: for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
                        for (RegisteredListener listener : 1.getHandlerList().getRegisteredListeners()) {
                            if (!listener.getListener().getClass().getName().equals(element.getClassName())) continue;
                            isCanBuild.setResult(false);
                            isCanBuild.setMessage(listener.getPlugin().getName());
                            break block1;
                        }
                    }
                }
                super.setCancelled(cancel);
            }
        };
        this.eventManager.callEvent(new ShopProtectionCheckEvent(block.getLocation(), player, ProtectionCheckStatus.BEGIN, (Event)beMainHand));
        beMainHand.setDropItems(false);
        beMainHand.setExpToDrop(0);
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler(priority=EventPriority.HIGHEST)
            public void onTestEvent(BlockBreakEvent event) {
                if (event.equals(beMainHand)) {
                    PermissionChecker.this.eventManager.callEvent(new ShopProtectionCheckEvent(block.getLocation(), player, ProtectionCheckStatus.END, (Event)beMainHand));
                    if (!event.isCancelled()) {
                        beMainHand.setCancelled(true);
                        isCanBuild.setResult(true);
                    }
                    HandlerList.unregisterAll((Listener)this);
                }
            }
        }, (Plugin)this.plugin);
        this.plugin.getCompatibilityTool().toggleProtectionListeners(false, player);
        this.eventManager.callEvent((Event)beMainHand);
        this.plugin.getCompatibilityTool().toggleProtectionListeners(true, player);
        return isCanBuild;
    }
}

