/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandMap;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.util.GameVersion;

public class ReflectFactory {
    private static String cachedVersion = null;
    private static Method craftItemStack_asNMSCopyMethod;
    private static Method itemStack_saveMethod;
    private static Class<?> nbtTagCompoundClass;
    private static Class<?> craftServerClass;

    @NotNull
    public static String getServerVersion() {
        if (cachedVersion != null) {
            return cachedVersion;
        }
        try {
            Field consoleField = Bukkit.getServer().getClass().getDeclaredField("console");
            consoleField.setAccessible(true);
            Object console = consoleField.get(Bukkit.getServer());
            cachedVersion = String.valueOf(console.getClass().getSuperclass().getMethod("getVersion", new Class[0]).invoke(console, new Object[0]));
            return cachedVersion;
        }
        catch (Exception e) {
            cachedVersion = "Unknown";
            return cachedVersion;
        }
    }

    @Nullable
    public static String convertBukkitItemStackToJson(@NotNull ItemStack bStack) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, InstantiationException {
        if (bStack.getType() == Material.AIR) {
            return null;
        }
        Object mcStack = craftItemStack_asNMSCopyMethod.invoke(null, bStack);
        Object nbtTagCompound = nbtTagCompoundClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        itemStack_saveMethod.invoke(mcStack, nbtTagCompound);
        return nbtTagCompound.toString();
    }

    @Nullable
    public static Object convertBukkitItemStackToMojangItemStack(@NotNull ItemStack bStack) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, InstantiationException {
        if (bStack.getType() == Material.AIR) {
            return null;
        }
        Object mcStack = craftItemStack_asNMSCopyMethod.invoke(null, bStack);
        Object nbtTagCompound = nbtTagCompoundClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        itemStack_saveMethod.invoke(mcStack, nbtTagCompound);
        return nbtTagCompound.toString();
    }

    public static CommandMap getCommandMap() throws NoSuchFieldException, IllegalAccessException {
        Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
        commandMapField.setAccessible(true);
        return (CommandMap)commandMapField.get(Bukkit.getServer());
    }

    public static void syncCommands() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = craftServerClass.getDeclaredMethod("syncCommands", new Class[0]);
        try {
            method.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        method.invoke((Object)Bukkit.getServer(), (Object[])null);
    }

    static {
        String name = Bukkit.getServer().getClass().getPackage().getName();
        String nmsVersion = name.substring(name.lastIndexOf(46) + 1);
        try {
            craftItemStack_asNMSCopyMethod = Class.forName("org.bukkit.craftbukkit." + nmsVersion + ".inventory.CraftItemStack").getDeclaredMethod("asNMSCopy", ItemStack.class);
            GameVersion gameVersion = GameVersion.get(nmsVersion);
            if (gameVersion.isNewNmsName()) {
                nbtTagCompoundClass = Class.forName("net.minecraft.nbt.NBTTagCompound");
                itemStack_saveMethod = Class.forName("net.minecraft.world.item.ItemStack").getDeclaredMethod("save", nbtTagCompoundClass);
            } else {
                nbtTagCompoundClass = Class.forName("net.minecraft.server." + nmsVersion + ".NBTTagCompound");
                itemStack_saveMethod = Class.forName("net.minecraft.server." + nmsVersion + ".ItemStack").getDeclaredMethod("save", nbtTagCompoundClass);
            }
            craftServerClass = Class.forName("org.bukkit.craftbukkit." + nmsVersion + ".CraftServer");
        }
        catch (Exception t) {
            QuickShop.getInstance().getLogger().log(Level.WARNING, "Failed to loading up net.minecraft.server support module, usually this caused by NMS changes but QuickShop not support yet, Did you have up-to-date?", t);
        }
    }
}

