/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.util.compatibility;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.util.Util;
import org.maxgamer.quickshop.util.compatibility.CompatibilityModule;
import org.maxgamer.quickshop.util.compatibility.NCPCompatibilityModule;
import org.maxgamer.quickshop.util.compatibility.SpartanCompatibilityModule;
import org.maxgamer.quickshop.util.holder.QuickShopInstanceHolder;

public class CompatibilityManager
extends QuickShopInstanceHolder {
    private static final Map<String, Class<? extends CompatibilityModule>> compatibilityModuleNameMap = new HashMap<String, Class<? extends CompatibilityModule>>(2);
    private final Map<String, CompatibilityModule> registeredModules = new HashMap<String, CompatibilityModule>(5);

    public CompatibilityManager(QuickShop plugin) {
        super(plugin);
    }

    public static Map<String, Class<? extends CompatibilityModule>> getCompatibilityModuleNameMap() {
        return compatibilityModuleNameMap;
    }

    public void searchAndRegisterPlugins() {
        PluginManager pluginManager = this.plugin.getServer().getPluginManager();
        for (Map.Entry<String, Class<? extends CompatibilityModule>> entry : compatibilityModuleNameMap.entrySet()) {
            String pluginName = entry.getKey();
            if (!pluginManager.isPluginEnabled(pluginName)) continue;
            this.register(entry.getValue());
        }
    }

    public void toggleProtectionListeners(boolean status, @NotNull Player player) {
        for (CompatibilityModule module : this.registeredModules.values()) {
            try {
                module.toggle(player, status);
            }
            catch (Throwable e) {
                this.unregister(module);
                Util.debugLog("Unregistered module " + module.getName() + " for an error: " + e.getMessage());
            }
        }
    }

    public void unregisterAll() {
        this.registeredModules.clear();
    }

    public void register(@NotNull CompatibilityModule module) {
        if (!this.registeredModules.containsKey(module.getName())) {
            this.plugin.getLogger().info("Registering " + module.getName() + " Compatibility Module");
            this.registeredModules.put(module.getName(), module);
        }
    }

    public void register(@NotNull String moduleName) {
        Class<? extends CompatibilityModule> compatibilityModuleClass = compatibilityModuleNameMap.get(moduleName);
        if (compatibilityModuleClass == null) {
            throw new IllegalStateException("Invalid compatibility module name: " + moduleName);
        }
        this.register(compatibilityModuleClass);
    }

    public void register(@NotNull Class<? extends CompatibilityModule> compatibilityModuleClass) {
        CompatibilityModule compatibilityModule;
        try {
            compatibilityModule = compatibilityModuleClass.getConstructor(((Object)((Object)this.plugin)).getClass()).newInstance(new Object[]{this.plugin});
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | NullPointerException | InvocationTargetException e) {
            throw new IllegalStateException("Invalid compatibility module class: " + compatibilityModuleClass, e);
        }
        this.register(compatibilityModule);
    }

    public void unregister(@NotNull String moduleName) {
        this.plugin.getLogger().info("Unregistering " + moduleName + " compatibility module");
        this.registeredModules.remove(moduleName);
    }

    public void unregister(@NotNull CompatibilityModule module) {
        this.plugin.getLogger().info("Unregistering " + module.getName() + " compatibility module");
        this.registeredModules.remove(module.getName());
    }

    static {
        compatibilityModuleNameMap.put("NoCheatPlus", NCPCompatibilityModule.class);
        compatibilityModuleNameMap.put("Spartan", SpartanCompatibilityModule.class);
    }
}

