/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.util.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.util.holder.QuickShopInstanceHolder;

public class ConfigProvider
extends QuickShopInstanceHolder {
    private final File configFile;
    private final Logger logger;
    private FileConfiguration config;

    public ConfigProvider(QuickShop plugin) {
        super(plugin);
        this.configFile = new File(this.plugin.getDataFolder(), "config.yml");
        this.logger = this.plugin.getLogger();
        this.config = null;
    }

    @NotNull
    public FileConfiguration get() {
        if (this.config == null) {
            this.reload();
        }
        return this.config;
    }

    public void save() {
        try {
            this.get().save(this.configFile);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Failed to save configuration!", e);
        }
    }

    public void reload() {
        this.reload(false);
    }

    public void reload(boolean defaults) {
        block18: {
            if (!this.configFile.exists()) {
                this.plugin.saveDefaultConfig();
            }
            if (this.config == null) {
                this.config = new YamlConfiguration();
            }
            try (InputStream defaultConfigStream = this.plugin.getResource("config.yml");){
                this.config.load(this.configFile);
                if (defaultConfigStream == null) break block18;
                try (InputStreamReader reader = new InputStreamReader(defaultConfigStream, StandardCharsets.UTF_8);){
                    this.config.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)reader));
                }
            }
            catch (IOException | InvalidConfigurationException exception) {
                if (!defaults) {
                    this.logger.log(Level.SEVERE, "Cannot reading the configuration, doing backup configuration and use default", exception);
                    try {
                        Files.copy(this.configFile.toPath(), this.plugin.getDataFolder().toPath().resolve("config-broken-" + UUID.randomUUID() + ".yml"), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException fatalException) {
                        this.logger.log(Level.SEVERE, "Failed to backup plugin config! Disabling plugin....", fatalException);
                        throw new IllegalStateException("Failed to backup plugin config!", fatalException);
                    }
                    this.plugin.saveResource("config.yml", true);
                    this.reload(true);
                }
                this.logger.log(Level.SEVERE, "Failed to load default configuration! Disabling plugin....", exception);
                throw new IllegalStateException("Failed to load default configuration!", exception);
            }
        }
    }
}

