/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.util.language;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.util.language.Formatter;
import org.maxgamer.quickshop.util.language.Phrase;
import org.maxgamer.quickshop.util.language.formatter.FilledFormatter;

public class Lang {
    private final File file;
    private final Consumer<FileConfiguration> upgrading;
    private final ImmutableList<Formatter> formatters;
    private FileConfiguration map;

    public Lang(@NotNull File file, @NotNull Consumer<FileConfiguration> upgrading, Formatter ... formatters) {
        this.file = file;
        this.upgrading = upgrading;
        this.formatters = formatters != null ? ImmutableList.copyOf(formatters) : ImmutableList.of(new FilledFormatter());
        this.reload();
    }

    public void reload() {
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.map = YamlConfiguration.loadConfiguration((File)this.file);
        this.upgrading.accept(this.map);
    }

    public void save() {
        try {
            this.map.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void set(@NotNull String path, @Nullable Object data) {
        this.map.set(path, data);
    }

    public String format(@Nullable String raw, @Nullable CommandSender sender, String ... args) {
        if (StringUtils.isNotEmpty((String)raw)) {
            for (Formatter formatter : this.formatters) {
                raw = formatter.format(raw, sender, args);
            }
        }
        return raw;
    }

    public String format(@Nullable String raw, String ... args) {
        return this.format(raw, (CommandSender)null, args);
    }

    @NotNull
    public Phrase create(@NotNull String path) {
        return new Phrase(this, path);
    }

    @NotNull
    public String getString(@NotNull String path, String ... args) {
        return new Phrase(this, path).get(args);
    }

    @NotNull
    public String getString(@NotNull String path, @NotNull CommandSender sender, String ... args) {
        return new Phrase(this, path).get(sender, args);
    }

    public FileConfiguration getMap() {
        return this.map;
    }
}

