/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.util.language;

import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.util.language.Lang;

public class Phrase {
    private final Lang lang;
    private final String original;
    private String last;
    private boolean baked = false;
    private boolean ready = false;

    public Phrase(@NotNull Lang lang, @NotNull String path) {
        this.lang = lang;
        this.last = this.original = lang.getMap().getString(path);
    }

    public Phrase(@NotNull Lang lang, @NotNull String path, @Nullable String defaults) {
        this.lang = lang;
        this.last = this.original = lang.getMap().getString(path, defaults);
    }

    public void bake(String ... args) {
        this.bake((CommandSender)null, args);
    }

    public void bake(@Nullable CommandSender sender, String ... args) {
        this.last = args != null ? this.lang.format(this.original, sender, args) : this.original;
        this.baked = true;
        this.ready = true;
    }

    public String get(String ... args) {
        this.bake(args);
        this.ready = false;
        return this.last();
    }

    public String get(@NotNull CommandSender sender, String ... args) {
        this.bake(sender, args);
        this.ready = false;
        return this.last();
    }

    public String last() {
        return this.last;
    }

    public boolean isBaked() {
        return this.baked;
    }

    public boolean isReady() {
        return this.ready;
    }
}

