/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.util.language.game;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.shade.org.apache.commons.codec.digest.DigestUtils;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.ReflectFactory;
import org.maxgamer.quickshop.util.Util;
import org.maxgamer.quickshop.util.language.game.BukkitGameLanguageImpl;
import org.maxgamer.quickshop.util.language.game.GameLanguage;
import org.maxgamer.quickshop.util.mojangapi.MojangAPI;

public class MojangGameLanguageImpl
extends BukkitGameLanguageImpl
implements GameLanguage {
    private static final Lock LOCK = new ReentrantLock();
    private static final Condition DOWNLOAD_CONDITION = LOCK.newCondition();
    private final QuickShop plugin;
    @Nullable
    private final JsonObject lang;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MojangGameLanguageImpl(@NotNull QuickShop plugin, @NotNull String languageCode) {
        super(plugin);
        this.plugin = plugin;
        if ("default".equalsIgnoreCase(languageCode)) {
            Locale locale = Locale.getDefault();
            String language = locale.getLanguage();
            String country = locale.getCountry();
            boolean isLanguageEmpty = StringUtils.isEmpty((String)language);
            boolean isCountryEmpty = StringUtils.isEmpty((String)country);
            if (isLanguageEmpty && isCountryEmpty) {
                plugin.getLogger().warning("Unable to get language code, fallback to en_US, please change game-language option in config.yml.");
                languageCode = "en_US";
            } else if (isCountryEmpty || isLanguageEmpty) {
                languageCode = isLanguageEmpty ? country + '_' + country : language + '_' + language;
                plugin.getLogger().warning("Unable to get language code, guessing" + languageCode + " instead, If it's incorrect, please change game-language option in config.yml.");
            } else {
                languageCode = language + '_' + country;
            }
        }
        languageCode = languageCode.replace("-", "_").toLowerCase(Locale.ROOT);
        LOCK.lock();
        try {
            boolean timeout;
            GameLanguageLoadThread loadThread = new GameLanguageLoadThread(plugin, languageCode);
            loadThread.start();
            boolean bl = timeout = !DOWNLOAD_CONDITION.await(20L, TimeUnit.SECONDS);
            if (timeout) {
                Util.debugLog("No longer waiting file downloading because it now timed out, now downloading in background.");
                plugin.getLogger().info("No longer waiting file downloading because it now timed out, now downloading in background, please reset itemi18n.yml, potioni18n.yml and enchi18n.yml after download completed.");
            }
            this.lang = loadThread.getLang();
        }
        finally {
            LOCK.unlock();
        }
    }

    @Override
    @NotNull
    public String getName() {
        return "Mojang API";
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    @NotNull
    public String getItem(@NotNull ItemStack itemStack) {
        return this.getItem(itemStack.getType());
    }

    @Override
    @NotNull
    public String getItem(@NotNull Material material) {
        if (this.lang == null) {
            return super.getItem(material);
        }
        JsonElement element = this.lang.get("item.minecraft." + material.name().toLowerCase());
        if (element == null) {
            return this.getBlock(material);
        }
        return element.getAsString();
    }

    @NotNull
    public String getBlock(@NotNull Material material) {
        if (this.lang == null) {
            return super.getItem(material);
        }
        JsonElement jsonElement = this.lang.get("block.minecraft." + material.name().toLowerCase());
        if (jsonElement == null) {
            return super.getItem(material);
        }
        return jsonElement.getAsString();
    }

    @Override
    @NotNull
    public String getPotion(@NotNull PotionEffectType potionEffectType) {
        if (this.lang == null) {
            return super.getPotion(potionEffectType);
        }
        JsonElement jsonElement = this.lang.get("effect.minecraft." + potionEffectType.getName().toLowerCase());
        if (jsonElement == null) {
            return super.getPotion(potionEffectType);
        }
        return jsonElement.getAsString();
    }

    @Override
    @NotNull
    public String getEnchantment(@NotNull Enchantment enchantment) {
        if (this.lang == null) {
            return super.getEnchantment(enchantment);
        }
        JsonElement jsonElement = this.lang.get("enchantment.minecraft." + enchantment.getKey().getKey().toLowerCase());
        if (jsonElement == null) {
            return super.getEnchantment(enchantment);
        }
        return jsonElement.getAsString();
    }

    @Override
    @NotNull
    public String getEntity(@NotNull EntityType entityType) {
        if (this.lang == null) {
            return super.getEntity(entityType);
        }
        JsonElement jsonElement = this.lang.get("entity.minecraft." + entityType.name().toLowerCase());
        if (jsonElement == null) {
            return super.getEntity(entityType);
        }
        return jsonElement.getAsString();
    }

    static class GameLanguageLoadThread
    extends Thread {
        private final String languageCode;
        private final QuickShop plugin;
        private JsonObject lang;
        private boolean isLatest = false;
        private boolean isUpdated = false;

        public GameLanguageLoadThread(@NotNull QuickShop plugin, @NotNull String languageCode) {
            this.plugin = plugin;
            this.languageCode = languageCode;
        }

        @Override
        public void run() {
            LOCK.lock();
            try {
                this.execute();
                DOWNLOAD_CONDITION.signalAll();
            }
            finally {
                LOCK.unlock();
            }
        }

        public void execute() {
            try {
                File cacheFile = new File(Util.getCacheFolder(), "mojanglang.cache");
                if (!cacheFile.exists()) {
                    cacheFile.createNewFile();
                }
                YamlConfiguration yamlConfiguration = new YamlConfiguration();
                yamlConfiguration.load(cacheFile);
                String cacheSha1 = yamlConfiguration.getString("sha1", "ERROR");
                String cacheCode = yamlConfiguration.getString("lang");
                if ("en_us".equalsIgnoreCase(this.languageCode)) {
                    this.isLatest = true;
                    return;
                }
                File cachedFile = new File(Util.getCacheFolder(), cacheSha1);
                if (this.languageCode.equals(cacheCode) && cachedFile.exists() && DigestUtils.sha1Hex(new FileInputStream(cachedFile)).equals(cacheSha1)) {
                    this.isLatest = true;
                    try (FileReader reader2 = new FileReader(cachedFile);){
                        this.lang = new JsonParser().parse((Reader)reader2).getAsJsonObject();
                        return;
                    }
                    catch (Exception reader2) {
                        // empty catch block
                    }
                }
                this.isUpdated = true;
                this.plugin.getLogger().info("Loading required files from Mojang API, Please allow up to 20 secs.");
                MojangAPI mojangAPI = new MojangAPI();
                MojangAPI.AssetsAPI assetsAPI = mojangAPI.getAssetsAPI(ReflectFactory.getServerVersion());
                if (!assetsAPI.isAvailable()) {
                    Util.debugLog("AssetsAPI returns not available, This may caused by Mojang servers down or connection issue.");
                    this.plugin.getLogger().warning("Failed to update game assets from MojangAPI server, This may caused by Mojang servers down, connection issue or invalid language code.");
                    return;
                }
                Optional<MojangAPI.AssetsFileData> assetsFileData = assetsAPI.getGameAssetsFile();
                if (!assetsFileData.isPresent()) {
                    Util.debugLog("AssetsAPI returns nothing about required game asset file, This may caused by Mojang servers down or connection issue.");
                    this.plugin.getLogger().warning("Failed to update game assets from MojangAPI server, This may caused by Mojang servers down, connection issue or invalid language code.");
                    return;
                }
                Util.debugLog(MsgUtil.fillArgs("Assets file loaded! id:[{0}], sha1:[{1}], Content Length:[{2}]", assetsFileData.get().getId(), assetsFileData.get().getSha1(), String.valueOf(assetsFileData.get().getContent().length())));
                String indexSha1Hex = DigestUtils.sha1Hex(assetsFileData.get().getContent());
                if (!assetsFileData.get().getSha1().equals(indexSha1Hex)) {
                    Util.debugLog(MsgUtil.fillArgs("File hashing equals failed! excepted:[{0}], file:[{1}]", assetsFileData.get().getSha1(), indexSha1Hex));
                    this.plugin.getLogger().warning("Failed to update game assets from MojangAPI server because the file seems invalid, please try again later.");
                    return;
                }
                try {
                    Files.write(new File(Util.getCacheFolder(), indexSha1Hex).toPath(), assetsFileData.get().getContent().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                catch (IOException ioException) {
                    this.plugin.getLogger().log(Level.WARNING, "Failed save file to local drive, game language system caches will stop work, we will try download again in next reboot. skipping...", ioException);
                }
                JsonElement indexJson = new JsonParser().parse(assetsFileData.get().getContent());
                if (!indexJson.isJsonObject()) {
                    this.plugin.getLogger().warning("Failed to update game assets from MojangAPI server because the json structure seems invalid, please try again later.");
                    return;
                }
                if (!indexJson.getAsJsonObject().get("objects").isJsonObject()) {
                    this.plugin.getLogger().warning("Failed to update game assets from MojangAPI server because the json structure about objects seems invalid, please try again later.");
                    return;
                }
                JsonElement langElement = indexJson.getAsJsonObject().get("objects").getAsJsonObject().get("minecraft/lang/" + this.languageCode + ".json");
                if (langElement == null) {
                    this.plugin.getLogger().warning("Failed to update game assets from MojangAPI server because the language code " + this.languageCode + " not supported by Minecraft.");
                    return;
                }
                String langHash = langElement.getAsJsonObject().get("hash").getAsString();
                Optional<String> langContent = mojangAPI.getResourcesAPI().get(langHash);
                if (!langContent.isPresent()) {
                    this.plugin.getLogger().warning("Failed to update game assets from MojangAPI server because network connection issue.");
                    return;
                }
                try {
                    Files.write(new File(Util.getCacheFolder(), langHash).toPath(), langContent.get().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                catch (IOException ioException) {
                    this.plugin.getLogger().log(Level.WARNING, "Failed save file to local drive, game language system caches will stop work, we will try download again in next reboot. skipping...", ioException);
                }
                this.lang = new JsonParser().parse(langContent.get()).getAsJsonObject();
                yamlConfiguration.set("ver", (Object)ReflectFactory.getServerVersion());
                yamlConfiguration.set("sha1", (Object)langHash);
                yamlConfiguration.set("lang", (Object)this.languageCode);
                yamlConfiguration.save(cacheFile);
                this.isLatest = true;
                Util.debugLog("Successfully update game assets.");
                this.plugin.getLogger().info("Success! The game assets now up-to-date :)");
                this.plugin.getLogger().info("Now you can execute [/qs reset lang] command to regenerate files with localized.");
            }
            catch (Exception e) {
                this.plugin.getSentryErrorReporter().ignoreThrow();
                this.plugin.getLogger().log(Level.WARNING, "Something going wrong when loading game translation assets", e);
            }
        }

        public boolean isLatest() {
            return this.isLatest;
        }

        public String getLanguageCode() {
            return this.languageCode;
        }

        public QuickShop getPlugin() {
            return this.plugin;
        }

        public JsonObject getLang() {
            return this.lang;
        }

        public boolean isUpdated() {
            return this.isUpdated;
        }
    }
}

