/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.util.matcher.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.ShulkerBox;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.inventory.meta.TropicalFishBucketMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.util.Util;
import org.maxgamer.quickshop.util.matcher.item.ItemMatcher;

public class QuickShopItemMatcherImpl
implements ItemMatcher {
    private final QuickShop plugin;
    private final ItemMetaMatcher itemMetaMatcher;
    private final int workType;

    public QuickShopItemMatcherImpl(@NotNull QuickShop plugin) {
        this.plugin = plugin;
        this.itemMetaMatcher = new ItemMetaMatcher(plugin.getConfig().getConfigurationSection("matcher.item"), this);
        this.workType = plugin.getConfig().getInt("matcher.work-type");
    }

    public QuickShopItemMatcherImpl() {
        this.plugin = QuickShop.getInstance();
        this.itemMetaMatcher = new ItemMetaMatcher(this.plugin.getConfig().getConfigurationSection("matcher.item"), this);
        this.workType = this.plugin.getConfig().getInt("matcher.work-type");
    }

    @Override
    @NotNull
    public String getName() {
        return this.plugin.getName();
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    public boolean matches(@Nullable ItemStack[] requireStack, @Nullable ItemStack[] givenStack) {
        if (requireStack == null && givenStack == null) {
            return true;
        }
        if (requireStack == null || givenStack == null) {
            return false;
        }
        if (requireStack.length != givenStack.length) {
            return false;
        }
        for (int i = 0; i < requireStack.length; ++i) {
            if (requireStack[i] != null && givenStack[i] != null && requireStack[i].getAmount() != givenStack[i].getAmount()) {
                return false;
            }
            if (this.matches(requireStack[i], givenStack[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(@Nullable ItemStack requireStack, @Nullable ItemStack givenStack) {
        if (requireStack == null && givenStack == null) {
            return true;
        }
        if (requireStack == null || givenStack == null) {
            Util.debugLog("Match failed: A stack is null: requireStack[" + requireStack + "] givenStack[" + givenStack + "]");
            return false;
        }
        requireStack = requireStack.clone();
        requireStack.setAmount(1);
        givenStack = givenStack.clone();
        givenStack.setAmount(1);
        if (this.workType == 1) {
            return requireStack.isSimilar(givenStack);
        }
        if (this.workType == 2) {
            return requireStack.equals((Object)givenStack);
        }
        if (!this.typeMatches(requireStack, givenStack)) {
            return false;
        }
        if (requireStack.hasItemMeta() != givenStack.hasItemMeta()) {
            return false;
        }
        if (requireStack.hasItemMeta()) {
            return this.itemMetaMatcher.matches(requireStack, givenStack);
        }
        return true;
    }

    private boolean typeMatches(ItemStack requireStack, ItemStack givenStack) {
        return requireStack.getType().equals((Object)givenStack.getType());
    }

    public QuickShopItemMatcherImpl(QuickShop plugin, ItemMetaMatcher itemMetaMatcher, int workType) {
        this.plugin = plugin;
        this.itemMetaMatcher = itemMetaMatcher;
        this.workType = workType;
    }

    private static class ItemMetaMatcher {
        private final List<Matcher> matcherList = new ArrayList<Matcher>();

        public ItemMetaMatcher(@NotNull ConfigurationSection itemMatcherConfig, @NotNull QuickShopItemMatcherImpl itemMatcher) {
            this.addIfEnable(itemMatcherConfig, "damage", (meta1, meta2) -> {
                if (meta1 instanceof Damageable != meta2 instanceof Damageable) {
                    return false;
                }
                if (meta1 instanceof Damageable) {
                    Damageable damage1 = (Damageable)meta1;
                    Damageable damage2 = (Damageable)meta2;
                    return damage2.getDamage() <= damage1.getDamage();
                }
                return true;
            });
            this.addIfEnable(itemMatcherConfig, "repaircost", (meta1, meta2) -> {
                if (meta1 instanceof Repairable != meta2 instanceof Repairable) {
                    return false;
                }
                if (meta1 instanceof Repairable) {
                    Repairable repairable1 = (Repairable)meta1;
                    Repairable repairable2 = (Repairable)meta2;
                    if (repairable1.hasRepairCost() != repairable2.hasRepairCost()) {
                        return false;
                    }
                    if (repairable1.hasRepairCost()) {
                        return repairable2.getRepairCost() <= repairable1.getRepairCost();
                    }
                }
                return true;
            });
            this.addIfEnable(itemMatcherConfig, "displayname", (meta1, meta2) -> {
                if (meta1.hasDisplayName() != meta2.hasDisplayName()) {
                    return false;
                }
                if (meta1.hasDisplayName()) {
                    return meta1.getDisplayName().equals(meta2.getDisplayName());
                }
                return true;
            });
            this.addIfEnable(itemMatcherConfig, "lores", (meta1, meta2) -> {
                if (meta1.hasLore() != meta2.hasLore()) {
                    return false;
                }
                if (meta1.hasLore()) {
                    List lores1 = meta1.getLore();
                    List lores2 = meta2.getLore();
                    return Arrays.deepEquals(Objects.requireNonNull(lores1).toArray(), Objects.requireNonNull(lores2).toArray());
                }
                return true;
            });
            this.addIfEnable(itemMatcherConfig, "enchs", (meta1, meta2) -> {
                if (meta1.hasEnchants() != meta2.hasEnchants()) {
                    return false;
                }
                if (meta1.hasEnchants()) {
                    Map enchMap1 = meta1.getEnchants();
                    Map enchMap2 = meta2.getEnchants();
                    return enchMap1.equals(enchMap2);
                }
                if (meta1 instanceof EnchantmentStorageMeta != meta2 instanceof EnchantmentStorageMeta) {
                    return false;
                }
                if (meta1 instanceof EnchantmentStorageMeta) {
                    Map stor1 = ((EnchantmentStorageMeta)meta1).getStoredEnchants();
                    Map stor2 = ((EnchantmentStorageMeta)meta2).getStoredEnchants();
                    return stor1.equals(stor2);
                }
                return true;
            });
            this.addIfEnable(itemMatcherConfig, "potions", (meta1, meta2) -> {
                if (meta1 instanceof PotionMeta != meta2 instanceof PotionMeta) {
                    return false;
                }
                if (meta1 instanceof PotionMeta) {
                    PotionData data2;
                    PotionMeta potion1 = (PotionMeta)meta1;
                    PotionMeta potion2 = (PotionMeta)meta2;
                    if (potion1.hasColor() != potion2.hasColor()) {
                        return false;
                    }
                    if (potion1.hasColor() && !Objects.equals(potion1.getColor(), potion2.getColor())) {
                        return false;
                    }
                    if (potion1.hasCustomEffects() != potion2.hasCustomEffects()) {
                        return false;
                    }
                    if (potion1.hasCustomEffects() && !Arrays.deepEquals(potion1.getCustomEffects().toArray(), potion2.getCustomEffects().toArray())) {
                        return false;
                    }
                    PotionData data1 = potion1.getBasePotionData();
                    if (!data1.equals((Object)(data2 = potion2.getBasePotionData()))) {
                        return false;
                    }
                    if (!data2.getType().equals((Object)data1.getType())) {
                        return false;
                    }
                    if (data1.isExtended() != data2.isExtended()) {
                        return false;
                    }
                    return data1.isUpgraded() == data2.isUpgraded();
                }
                return true;
            });
            this.addIfEnable(itemMatcherConfig, "attributes", (meta1, meta2) -> {
                if (meta1.hasAttributeModifiers() != meta2.hasAttributeModifiers()) {
                    return false;
                }
                if (meta1.hasAttributeModifiers() && meta2.hasAttributeModifiers()) {
                    Set set1 = Objects.requireNonNull(meta1.getAttributeModifiers()).keySet();
                    Set set2 = Objects.requireNonNull(meta2.getAttributeModifiers()).keySet();
                    for (Attribute att : set1) {
                        if (!set2.contains(att)) {
                            return false;
                        }
                        if (meta1.getAttributeModifiers().get(att).equals(meta2.getAttributeModifiers().get(att))) continue;
                        return false;
                    }
                }
                return true;
            });
            this.addIfEnable(itemMatcherConfig, "itemflags", (meta1, meta2) -> Arrays.deepEquals(meta1.getItemFlags().toArray(), meta2.getItemFlags().toArray()));
            this.addIfEnable(itemMatcherConfig, "books", (meta1, meta2) -> {
                if (meta1 instanceof BookMeta != meta2 instanceof BookMeta) {
                    return false;
                }
                if (meta1 instanceof BookMeta) {
                    BookMeta book1 = (BookMeta)meta1;
                    BookMeta book2 = (BookMeta)meta2;
                    if (book1.hasTitle() != book2.hasTitle()) {
                        return false;
                    }
                    if (book1.hasTitle() && !Objects.equals(book1.getTitle(), book2.getTitle())) {
                        return false;
                    }
                    if (book1.hasPages() != book2.hasPages()) {
                        return false;
                    }
                    if (book1.hasPages() && !book1.getPages().equals(book2.getPages())) {
                        return false;
                    }
                    if (book1.hasAuthor() != book2.hasAuthor()) {
                        return false;
                    }
                    if (book1.hasAuthor() && !Objects.equals(book1.getAuthor(), book2.getAuthor())) {
                        return false;
                    }
                    if (book1.hasGeneration() != book2.hasGeneration()) {
                        return false;
                    }
                    return !book1.hasGeneration() || Objects.equals(book1.getGeneration(), book2.getGeneration());
                }
                return true;
            });
            this.addIfEnable(itemMatcherConfig, "banner", (meta1, meta2) -> {
                if (meta1 instanceof BannerMeta != meta2 instanceof BannerMeta) {
                    return false;
                }
                if (meta1 instanceof BannerMeta) {
                    BannerMeta bannerMeta1 = (BannerMeta)meta1;
                    BannerMeta bannerMeta2 = (BannerMeta)meta2;
                    if (bannerMeta1.numberOfPatterns() != bannerMeta2.numberOfPatterns()) {
                        return false;
                    }
                    return bannerMeta1.getPatterns().containsAll(bannerMeta2.getPatterns());
                }
                return true;
            });
            this.addIfEnable(itemMatcherConfig, "skull", (meta1, meta2) -> {
                if (meta1 instanceof SkullMeta != meta2 instanceof SkullMeta) {
                    return false;
                }
                if (meta1 instanceof SkullMeta) {
                    String player1 = ((SkullMeta)meta1).getOwner();
                    String player2 = ((SkullMeta)meta2).getOwner();
                    return Objects.equals(player1, player2);
                }
                return true;
            });
            this.addIfEnable(itemMatcherConfig, "map", (meta1, meta2) -> {
                if (meta1 instanceof MapMeta != meta2 instanceof MapMeta) {
                    return false;
                }
                if (meta1 instanceof MapMeta) {
                    MapMeta mapMeta1 = (MapMeta)meta1;
                    MapMeta mapMeta2 = (MapMeta)meta2;
                    if (mapMeta1.hasMapView() != mapMeta2.hasMapView()) {
                        return false;
                    }
                    if (mapMeta1.hasMapView() && mapMeta2.hasMapView() && !Objects.equals(mapMeta1.getMapView(), mapMeta2.getMapView())) {
                        return false;
                    }
                    if (mapMeta1.hasColor() != mapMeta2.hasColor()) {
                        return false;
                    }
                    if (mapMeta1.hasColor() && mapMeta2.hasColor() && !Objects.equals(mapMeta1.getColor(), mapMeta2.getColor())) {
                        return false;
                    }
                    if (mapMeta1.hasLocationName() != mapMeta2.hasLocationName()) {
                        return false;
                    }
                    return !mapMeta1.hasLocationName() || !mapMeta2.hasLocationName() || Objects.equals(mapMeta1.getLocationName(), mapMeta2.getLocationName());
                }
                return true;
            });
            this.addIfEnable(itemMatcherConfig, "firework", (meta1, meta2) -> {
                if (meta1 instanceof FireworkMeta != meta2 instanceof FireworkMeta) {
                    return false;
                }
                if (meta1 instanceof FireworkMeta) {
                    FireworkMeta fireworkMeta1 = (FireworkMeta)meta1;
                    FireworkMeta fireworkMeta2 = (FireworkMeta)meta2;
                    if (fireworkMeta1.hasEffects() != fireworkMeta2.hasEffects()) {
                        return false;
                    }
                    if (!fireworkMeta1.getEffects().equals(fireworkMeta2.getEffects())) {
                        return false;
                    }
                    return fireworkMeta1.getPower() == fireworkMeta2.getPower();
                }
                return true;
            });
            this.addIfEnable(itemMatcherConfig, "leatherArmor", (meta1, meta2) -> {
                if (meta1 instanceof LeatherArmorMeta != meta2 instanceof LeatherArmorMeta) {
                    return false;
                }
                if (meta1 instanceof LeatherArmorMeta) {
                    return ((LeatherArmorMeta)meta1).getColor().equals((Object)((LeatherArmorMeta)meta2).getColor());
                }
                return true;
            });
            this.addIfEnable(itemMatcherConfig, "fishBucket", (meta1, meta2) -> {
                if (meta1 instanceof TropicalFishBucketMeta != meta2 instanceof TropicalFishBucketMeta) {
                    return false;
                }
                if (meta1 instanceof TropicalFishBucketMeta) {
                    TropicalFishBucketMeta fishBucketMeta1 = (TropicalFishBucketMeta)meta1;
                    TropicalFishBucketMeta fishBucketMeta2 = (TropicalFishBucketMeta)meta2;
                    if (fishBucketMeta1.hasVariant() != fishBucketMeta2.hasVariant()) {
                        return false;
                    }
                    return !fishBucketMeta1.hasVariant() || fishBucketMeta1.getPattern() == fishBucketMeta2.getPattern() && fishBucketMeta1.getBodyColor().equals((Object)fishBucketMeta2.getBodyColor()) && fishBucketMeta1.getPatternColor().equals((Object)fishBucketMeta2.getPatternColor());
                }
                return true;
            });
            this.addIfEnable(itemMatcherConfig, "shulkerBox", (meta1, meta2) -> {
                if (meta1 instanceof BlockStateMeta != meta2 instanceof BlockStateMeta) {
                    return false;
                }
                if (meta1 instanceof BlockStateMeta) {
                    if (((BlockStateMeta)meta1).getBlockState() instanceof ShulkerBox != ((BlockStateMeta)meta2).getBlockState() instanceof ShulkerBox) {
                        return false;
                    }
                    if (((BlockStateMeta)meta1).getBlockState() instanceof ShulkerBox) {
                        return itemMatcher.matches(((ShulkerBox)((BlockStateMeta)meta1).getBlockState()).getInventory().getContents(), ((ShulkerBox)((BlockStateMeta)meta2).getBlockState()).getInventory().getContents());
                    }
                }
                return true;
            });
            if (!"v1_13_R1".equals(Util.getNMSVersion()) && !"v1_13_R2".equals(Util.getNMSVersion())) {
                this.addIfEnable(itemMatcherConfig, "custommodeldata", (meta1, meta2) -> {
                    if (meta1.hasCustomModelData() != meta2.hasCustomModelData()) {
                        return false;
                    }
                    if (meta1.hasCustomModelData()) {
                        return meta1.getCustomModelData() == meta2.getCustomModelData();
                    }
                    return true;
                });
                if (!"v1_14_R1".equals(Util.getNMSVersion())) {
                    this.addIfEnable(itemMatcherConfig, "suspiciousStew", (meta1, meta2) -> {
                        if (meta1 instanceof SuspiciousStewMeta != meta2 instanceof SuspiciousStewMeta) {
                            return false;
                        }
                        if (meta1 instanceof SuspiciousStewMeta) {
                            SuspiciousStewMeta stewMeta1 = (SuspiciousStewMeta)meta1;
                            SuspiciousStewMeta stewMeta2 = (SuspiciousStewMeta)meta2;
                            if (stewMeta1.hasCustomEffects() != stewMeta2.hasCustomEffects()) {
                                return false;
                            }
                            if (stewMeta1.hasCustomEffects()) {
                                return stewMeta1.getCustomEffects().equals(stewMeta2.getCustomEffects());
                            }
                        }
                        return true;
                    });
                }
            }
        }

        private void addIfEnable(ConfigurationSection itemMatcherConfig, String path, Matcher matcher) {
            if (itemMatcherConfig.getBoolean(path)) {
                this.matcherList.add(matcher);
            }
        }

        boolean matches(ItemStack requireStack, ItemStack givenStack) {
            if (requireStack.hasItemMeta() != givenStack.hasItemMeta()) {
                return false;
            }
            if (!requireStack.hasItemMeta()) {
                return true;
            }
            ItemMeta meta1 = requireStack.getItemMeta();
            ItemMeta meta2 = givenStack.getItemMeta();
            for (Matcher matcher : this.matcherList) {
                if (matcher.match(meta1, meta2)) continue;
                return false;
            }
            return true;
        }

        private boolean rootMatches(ItemMeta meta1, ItemMeta meta2) {
            return meta1.hashCode() == meta2.hashCode();
        }

        static interface Matcher {
            public boolean match(ItemMeta var1, ItemMeta var2);
        }
    }
}

