/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.watcher;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.event.CalendarEvent;
import org.maxgamer.quickshop.util.Util;

public class CalendarWatcher
extends BukkitRunnable {
    private final File calendarFile = new File(Util.getCacheFolder(), "calendar.cache");
    private final YamlConfiguration configuration;
    private final QuickShop plugin;
    private BukkitTask task;

    public CalendarWatcher(QuickShop plugin) {
        this.plugin = plugin;
        if (!this.calendarFile.exists()) {
            try {
                this.calendarFile.createNewFile();
            }
            catch (IOException ioException) {
                plugin.getLogger().log(Level.WARNING, "Cannot create calendar cache file at " + this.calendarFile.getAbsolutePath() + ", scheduled tasks may cannot or execute wrongly!", ioException);
            }
        }
        this.configuration = YamlConfiguration.loadConfiguration((File)this.calendarFile);
    }

    public void start() {
        this.task = this.runTaskTimerAsynchronously((Plugin)this.plugin, 20L, 20L);
    }

    public void stop() {
        this.save();
        try {
            if (this.task != null && !this.task.isCancelled()) {
                this.task.cancel();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public CalendarEvent.CalendarTriggerType getAndUpdate() {
        Calendar c = Calendar.getInstance();
        CalendarEvent.CalendarTriggerType type = CalendarEvent.CalendarTriggerType.NOTHING_CHANGED;
        int secondRecord = this.configuration.getInt("second");
        int minuteRecord = this.configuration.getInt("minute");
        int hourRecord = this.configuration.getInt("hour");
        int dayRecord = this.configuration.getInt("day");
        int weekRecord = this.configuration.getInt("week");
        int monthRecord = this.configuration.getInt("month");
        int yearRecord = this.configuration.getInt("year");
        int secondNow = c.get(13);
        int minuteNow = c.get(12);
        int hourNow = c.get(11);
        int dayNow = c.get(5);
        int weekNow = c.get(4);
        int monthNow = c.get(2);
        int yearNow = c.get(1);
        if (secondNow != secondRecord) {
            type = CalendarEvent.CalendarTriggerType.SECOND;
        }
        if (minuteNow != minuteRecord) {
            type = CalendarEvent.CalendarTriggerType.MINUTE;
        }
        if (hourNow != hourRecord) {
            type = CalendarEvent.CalendarTriggerType.HOUR;
        }
        if (dayNow != dayRecord) {
            type = CalendarEvent.CalendarTriggerType.DAY;
        }
        if (weekNow != weekRecord) {
            type = CalendarEvent.CalendarTriggerType.WEEK;
        }
        if (monthNow != monthRecord) {
            type = CalendarEvent.CalendarTriggerType.MONTH;
        }
        if (yearNow != yearRecord) {
            type = CalendarEvent.CalendarTriggerType.YEAR;
        }
        this.configuration.set("second", (Object)secondNow);
        this.configuration.set("minute", (Object)minuteNow);
        this.configuration.set("hour", (Object)hourNow);
        this.configuration.set("day", (Object)dayNow);
        this.configuration.set("week", (Object)weekNow);
        this.configuration.set("month", (Object)monthNow);
        this.configuration.set("year", (Object)yearNow);
        if (type.ordinal() >= CalendarEvent.CalendarTriggerType.HOUR.ordinal()) {
            this.save();
        }
        return type;
    }

    public void save() {
        try {
            this.configuration.save(this.calendarFile);
        }
        catch (IOException ioException) {
            this.plugin.getLogger().log(Level.WARNING, "Cannot save calendar cache file at " + this.calendarFile.getAbsolutePath() + ", scheduled tasks may cannot or execute wrongly!", ioException);
        }
    }

    public void run() {
        CalendarEvent.CalendarTriggerType type = this.getAndUpdate();
        Util.mainThreadRun(() -> Bukkit.getPluginManager().callEvent((Event)new CalendarEvent(type)));
    }

    public File getCalendarFile() {
        return this.calendarFile;
    }

    public YamlConfiguration getConfiguration() {
        return this.configuration;
    }
}

