/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.watcher;

import org.bukkit.plugin.Plugin;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.shop.DisplayItem;
import org.maxgamer.quickshop.shop.DisplayType;
import org.maxgamer.quickshop.shop.Shop;

public class DisplayWatcher {
    private QuickShop plugin;

    public DisplayWatcher(QuickShop plugin) {
        this.plugin = plugin;
        this.registerTask();
    }

    private void registerTask() {
        this.plugin.getLogger().info("Registering DisplayCheck task....");
        if (DisplayItem.getNowUsing() == DisplayType.VIRTUALITEM) {
            return;
        }
        if (this.plugin.isDisplay() && this.plugin.getDisplayItemCheckTicks() > 0) {
            this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
                if (this.plugin.getConfig().getInt("shop.display-items-check-ticks") < 3000) {
                    this.plugin.getLogger().severe("Shop.display-items-check-ticks is too low! It may cause HUGE lag! Pick a number > 3000");
                }
                for (Shop shop : this.plugin.getShopManager().getLoadedShops()) {
                    shop.checkDisplay();
                }
            }, 1L, (long)this.plugin.getDisplayItemCheckTicks());
        }
    }

    public QuickShop getPlugin() {
        return this.plugin;
    }

    public void setPlugin(QuickShop plugin) {
        this.plugin = plugin;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DisplayWatcher)) {
            return false;
        }
        DisplayWatcher other = (DisplayWatcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        QuickShop this$plugin = this.getPlugin();
        QuickShop other$plugin = other.getPlugin();
        return !(this$plugin == null ? other$plugin != null : !((Object)((Object)this$plugin)).equals((Object)other$plugin));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DisplayWatcher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QuickShop $plugin = this.getPlugin();
        result = result * 59 + ($plugin == null ? 43 : ((Object)((Object)$plugin)).hashCode());
        return result;
    }

    public String toString() {
        return "DisplayWatcher(plugin=" + (Object)((Object)this.getPlugin()) + ")";
    }
}

