/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.watcher;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import lombok.NonNull;
import org.bukkit.scheduler.BukkitRunnable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.shade.org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.maxgamer.quickshop.shade.org.apache.commons.compress.compressors.gzip.GzipParameters;

public class LogWatcher
extends BukkitRunnable
implements AutoCloseable {
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(ZoneId.systemDefault());
    private static final DateTimeFormatter logFileFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneId.systemDefault());
    private final Queue<String> logs = new ConcurrentLinkedQueue<String>();
    private PrintWriter printWriter = null;

    public LogWatcher(QuickShop plugin, File log) {
        try {
            boolean deleteFailed = false;
            if (!log.exists()) {
                log.createNewFile();
            } else if ((double)((float)log.length() / 1024.0f / 1024.0f) > plugin.getConfig().getDouble("logging.file-size")) {
                Path targetPath;
                Path logPath = plugin.getDataFolder().toPath().resolve("logs");
                Files.createDirectories(logPath, new FileAttribute[0]);
                int i = 1;
                do {
                    targetPath = logPath.resolve(ZonedDateTime.now().format(logFileFormatter) + "-" + i + ".log.gz");
                    ++i;
                } while (Files.exists(targetPath, new LinkOption[0]));
                Files.createFile(targetPath, new FileAttribute[0]);
                GzipParameters gzipParameters = new GzipParameters();
                gzipParameters.setFilename(log.getName());
                try (GzipCompressorOutputStream archiveOutputStream = new GzipCompressorOutputStream(new BufferedOutputStream(new FileOutputStream(targetPath.toFile())), gzipParameters);){
                    Files.copy(log.toPath(), archiveOutputStream);
                    archiveOutputStream.finish();
                    if (log.delete()) {
                        log.createNewFile();
                        deleteFailed = false;
                    } else {
                        deleteFailed = true;
                    }
                }
            }
            FileWriter logFileWriter = deleteFailed ? new FileWriter(log, false) : new FileWriter(log, true);
            this.printWriter = new PrintWriter(logFileWriter);
        }
        catch (FileNotFoundException e) {
            plugin.getLogger().log(Level.SEVERE, "Log file was not found!", e);
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.SEVERE, "Could not create the log file!", e);
        }
    }

    @Override
    public void close() {
        if (this.printWriter != null) {
            this.printWriter.flush();
            this.printWriter.close();
        }
    }

    public void log(@NonNull String log) {
        if (log == null) {
            throw new NullPointerException("log is marked non-null but is null");
        }
        this.logs.add("[" + dateTimeFormatter.format(Instant.now()) + "] " + log);
    }

    public void run() {
        if (this.printWriter == null) {
            return;
        }
        Iterator iterator = this.logs.iterator();
        while (iterator.hasNext()) {
            String log = (String)iterator.next();
            this.printWriter.println(log);
            iterator.remove();
        }
        this.printWriter.flush();
    }
}

