/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.watcher;

import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.economy.EconomyTransaction;
import org.maxgamer.quickshop.economy.Trader;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.Util;
import org.maxgamer.quickshop.util.WarningSender;

public class OngoingFeeWatcher
extends BukkitRunnable {
    private final QuickShop plugin;
    private final WarningSender warningSender;

    public OngoingFeeWatcher(@NotNull QuickShop plugin) {
        this.plugin = plugin;
        this.warningSender = new WarningSender(plugin, 6000L);
    }

    public void run() {
        Util.debugLog("Run task for ongoing fee...");
        if (this.plugin.getEconomy() == null) {
            Util.debugLog("Economy hadn't get ready.");
            return;
        }
        int cost = this.plugin.getConfig().getInt("shop.ongoing-fee.cost-per-shop");
        boolean allowLoan = this.plugin.getConfig().getBoolean("shop.allow-economy-loan");
        boolean ignoreUnlimited = this.plugin.getConfig().getBoolean("shop.ongoing-fee.ignore-unlimited");
        for (Shop shop : this.plugin.getShopManager().getAllShops()) {
            if (shop.isUnlimited() && ignoreUnlimited || shop.isDeleted()) continue;
            UUID shopOwner = shop.getOwner();
            Location location = shop.getLocation();
            if (!Util.isWorldLoaded(location)) continue;
            World world = location.getWorld();
            if (allowLoan || this.plugin.getEconomy().getBalance(shopOwner, Objects.requireNonNull(world), shop.getCurrency()) >= (double)cost) {
                Trader trader = this.plugin.getShopManager().getCacheTaxAccount();
                Util.mainThreadRun(() -> {
                    EconomyTransaction transaction = EconomyTransaction.builder().allowLoan(allowLoan).currency(shop.getCurrency()).core(this.plugin.getEconomy()).world(world).to(trader == null ? null : trader.getUniqueId()).from(shopOwner).build();
                    boolean success = transaction.failSafeCommit();
                    if (!success) {
                        this.warningSender.sendWarn("Unable to deposit ongoing fee to tax account, the last error is " + transaction.getLastError());
                    }
                });
                continue;
            }
            this.removeShop(shop);
        }
    }

    public void removeShop(@NotNull Shop shop) {
        Util.mainThreadRun(shop::delete);
        MsgUtil.send(shop, shop.getOwner(), new MsgUtil.TransactionMessage(MsgUtil.getMessageOfflinePlayer("shop-removed-cause-ongoing-fee", Bukkit.getOfflinePlayer((UUID)shop.getOwner()), "World:" + Objects.requireNonNull(shop.getLocation().getWorld()).getName() + " X:" + shop.getLocation().getBlockX() + " Y:" + shop.getLocation().getBlockY() + " Z:" + shop.getLocation().getBlockZ()), null, null));
    }
}

