/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.watcher;

import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.updater.QuickUpdater;
import org.maxgamer.quickshop.util.updater.VersionType;
import org.maxgamer.quickshop.util.updater.impl.JenkinsUpdater;

public class UpdateWatcher
implements Listener {
    private final QuickUpdater updater = new JenkinsUpdater(QuickShop.getInstance().getBuildInfo());
    private final Random random = new Random();
    private BukkitTask cronTask = null;

    public QuickUpdater getUpdater() {
        return this.updater;
    }

    public BukkitTask getCronTask() {
        return this.cronTask;
    }

    public void init() {
        this.cronTask = QuickShop.getInstance().getServer().getScheduler().runTaskTimerAsynchronously((Plugin)QuickShop.getInstance(), () -> {
            if (this.updater.isLatest(VersionType.STABLE)) {
                return;
            }
            QuickShop.getInstance().getLogger().info("A new version of QuickShop has been released! [" + this.updater.getRemoteServerVersion() + "]");
            QuickShop.getInstance().getLogger().info("Update here: https://www.spigotmc.org/resources/62575/");
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!QuickShop.getPermissionManager().hasPermission((CommandSender)player, "quickshop.alerts")) continue;
                List notifys = MsgUtil.getI18nFile().getStringList("updatenotify.list");
                int notifyNum = -1;
                if (notifys.size() > 1) {
                    notifyNum = this.random.nextInt(notifys.size());
                }
                String notify = notifyNum > 0 ? (String)notifys.get(notifyNum) : "New update {0} now avaliable! Please update!";
                notify = MsgUtil.fillArgs(notify, this.updater.getRemoteServerVersion(), QuickShop.getInstance().getBuildInfo().getBuildTag());
                player.sendMessage(ChatColor.GREEN + "---------------------------------------------------");
                player.sendMessage(ChatColor.GREEN + notify);
                player.sendMessage(ChatColor.GREEN + "Type command " + ChatColor.YELLOW + "/qs update" + ChatColor.GREEN + " or click the link below to update QuickShop :)");
                player.sendMessage(ChatColor.AQUA + " https://www.spigotmc.org/resources/62575/");
                player.sendMessage(ChatColor.GREEN + "---------------------------------------------------");
            }
        }, 1L, 72000L);
    }

    public void uninit() {
        if (this.cronTask == null) {
            return;
        }
        this.cronTask.cancel();
    }

    @EventHandler
    public void playerJoin(PlayerJoinEvent e) {
        QuickShop.getInstance().getServer().getScheduler().runTaskLaterAsynchronously((Plugin)QuickShop.getInstance(), () -> {
            if (!QuickShop.getPermissionManager().hasPermission((CommandSender)e.getPlayer(), "quickshop.alerts") || this.getUpdater().isLatest(this.getUpdater().getCurrentRunning())) {
                return;
            }
            List notifys = MsgUtil.getI18nFile().getStringList("updatenotify.list");
            int notifyNum = this.random.nextInt(notifys.size());
            String notify = (String)notifys.get(notifyNum);
            notify = MsgUtil.fillArgs(notify, this.updater.getRemoteServerVersion(), QuickShop.getInstance().getBuildInfo().getBuildTag());
            e.getPlayer().sendMessage(ChatColor.GREEN + "---------------------------------------------------");
            e.getPlayer().sendMessage(ChatColor.GREEN + notify);
            e.getPlayer().sendMessage(ChatColor.GREEN + "Type command " + ChatColor.YELLOW + "/qs update" + ChatColor.GREEN + " or click the link below to update QuickShop :)");
            e.getPlayer().sendMessage(ChatColor.AQUA + " https://www.spigotmc.org/resources/62575/");
            e.getPlayer().sendMessage(ChatColor.GREEN + "---------------------------------------------------");
        }, 80L);
    }
}

