/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.Container;

import net.Zrips.CMILib.Container.CMINumber;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.entity.Player;

public class CMIExperience {
    public static long getXpToLevelUpFrom(int level) {
        if (Version.isCurrentLower(Version.v1_8_R1)) {
            return level <= 16 ? 17L : (level <= 31 ? (long)(3 * level - 31) : 7L * (long)level - 155L);
        }
        return level <= 15 ? (long)(2 * level + 7) : (level <= 30 ? (long)(5 * level - 38) : 9L * (long)level - 158L);
    }

    public static long getTotalExpToLevel(int level) {
        if (Version.isCurrentLower(Version.v1_8_R1)) {
            return level <= 16 ? (long)(17 * level) : (level <= 31 ? (long)(3 * level * level / 2 - 59 * level / 2 + 360) : (long)(7 * level * level / 2 - 303 * level / 2 + 2220));
        }
        return (long)(level <= 16 ? (double)(level * level + 6 * level) : (level <= 31 ? 2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0 : 4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0));
    }

    public static void setLevel(Player player, int level) {
        if (player == null) {
            return;
        }
        player.setLevel(0);
        player.setExp(0.0f);
        player.setTotalExperience(0);
        player.setLevel(level);
    }

    public static int levelFromExp(long exp) {
        return (int)Math.floor((Math.sqrt(72.0 * (double)exp - 54215.0) + 325.0) / 18.0);
    }

    public static void setExp(Player player, long exp) {
        if (player == null) {
            return;
        }
        exp = (long)CMINumber.clamp((double)exp, 0.0, 3.4028234663852886E38);
        if (Version.isCurrentLower(Version.v1_8_R1) || exp < Integer.MAX_VALUE) {
            player.setLevel(0);
            player.setExp(0.0f);
            player.setTotalExperience(0);
            player.giveExp((int)exp);
            return;
        }
        int level = CMIExperience.levelFromExp(exp);
        float leftOver = exp - CMIExperience.getTotalExpToLevel(level);
        float delta = CMIExperience.getXpToLevelUpFrom(level);
        player.setTotalExperience(0);
        player.setLevel(level);
        player.setExp((float)CMINumber.clamp((double)(leftOver / delta), 0.0, 1));
    }

    public static void addExp(Player player, long exp) {
        if (player == null) {
            return;
        }
        CMIExperience.setExp(player, CMIExperience.getTotalExp(player) + exp);
    }

    public static void takeExp(Player player, long exp) {
        if (player == null) {
            return;
        }
        CMIExperience.setExp(player, CMIExperience.getTotalExp(player) - exp);
    }

    public static long getMissingExp(Player player) {
        if (player == null) {
            return 0L;
        }
        return CMIExperience.getXpToLevelUpFrom(player.getLevel()) - CMIExperience.getExpForCurrentLevel(player);
    }

    public static int getLevel(Player player) {
        if (player == null) {
            return 0;
        }
        return player.getLevel();
    }

    public static long getExpForCurrentLevel(Player player) {
        if (player == null) {
            return 0L;
        }
        return CMIExperience.getTotalExp(player) - CMIExperience.getTotalExpToLevel(player.getLevel());
    }

    public static long getTotalExp(Player player) {
        if (player == null) {
            return 0L;
        }
        return CMIExperience.getTotalExpToLevel(player.getLevel()) + (long)Math.round((float)CMIExperience.getXpToLevelUpFrom(player.getLevel()) * player.getExp());
    }
}

