/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.Container;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.Zrips.CMILib.Container.CMIWorld;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;

public class CMILocation
extends Location {
    private String worldName;
    private static MethodHandle getBlockTypeId = null;
    private static MethodHandle getBlockData = null;

    public CMILocation(World world, double x, double y, double z, float yaw, float pitch) {
        super(world, x, y, z, yaw, pitch);
        this.worldName = world.getName();
    }

    public CMILocation(World world, double x, double y, double z) {
        super(world, x, y, z);
        if (world != null) {
            this.worldName = world.getName();
        }
    }

    public CMILocation(Location loc) {
        super(loc.getWorld(), loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
        if (loc.getWorld() != null) {
            this.worldName = loc.getWorld().getName();
        }
    }

    public CMILocation(String world, double x, double y, double z, float yaw, float pitch) {
        super(Bukkit.getWorld((String)world), x, y, z, yaw, pitch);
        this.worldName = world;
    }

    public CMILocation(String world, double x, double y, double z) {
        super(Bukkit.getWorld((String)world), x, y, z);
        this.worldName = world;
    }

    public void recheck() {
        this.updateWorld();
    }

    private void updateWorld() {
        try {
            if (Version.isCurrentEqualOrHigher(Version.v1_16_R1) && super.getWorld() != null && !super.isWorldLoaded()) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (super.getWorld() == null && this.worldName != null) {
                World w = null;
                w = this.worldName.length() == 36 ? Bukkit.getWorld((UUID)UUID.fromString(this.worldName)) : Bukkit.getWorld((String)this.worldName);
                if (w != null) {
                    super.setWorld(w);
                    this.worldName = super.getWorld().getName();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getWorldName() {
        return this.worldName != null ? this.worldName : (this.getWorld() == null ? null : this.getWorld().getName());
    }

    public Location getBukkitLoc() {
        this.updateWorld();
        return this;
    }

    public boolean isValid() {
        this.updateWorld();
        return this.getWorld() != null && this.getWorld().getName() != null && Bukkit.getWorld((UUID)this.getWorld().getUID()) != null;
    }

    public boolean isWorldNull() {
        this.updateWorld();
        return this.getWorld() != null && this.getWorld().getName() != null && Bukkit.getWorld((UUID)this.getWorld().getUID()) != null;
    }

    public World getWorld() {
        this.updateWorld();
        try {
            if (Version.isCurrentEqualOrHigher(Version.v1_16_R1) && !super.isWorldLoaded()) {
                return null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.getWorld();
    }

    public Chunk getChunk() {
        this.updateWorld();
        return super.getChunk();
    }

    public Block getBlock() {
        this.updateWorld();
        if (super.getWorld() == null) {
            return null;
        }
        return super.getBlock();
    }

    public Location add(Location vec) {
        this.updateWorld();
        return super.add(vec);
    }

    public Location subtract(Location vec) {
        this.updateWorld();
        return super.subtract(vec);
    }

    public double distanceSquared(Location o) {
        if (o == null) {
            return 2.147483647E9;
        }
        if (!this.isValid()) {
            return 2.147483647E9;
        }
        return super.distanceSquared(o);
    }

    public double distance(Location o) {
        if (o == null) {
            return 2.147483647E9;
        }
        if (!this.isValid()) {
            return 2.147483647E9;
        }
        return super.distance(o);
    }

    public boolean equals(Object obj) {
        this.updateWorld();
        return super.equals(obj);
    }

    public int hashCode() {
        this.updateWorld();
        return super.hashCode();
    }

    public String toString() {
        this.updateWorld();
        return super.toString();
    }

    public CMILocation clone() {
        this.updateWorld();
        return new CMILocation(super.clone());
    }

    public Map<String, Object> serialize() {
        this.updateWorld();
        return super.serialize();
    }

    public int getHighestBlockYAt() {
        if (this.getWorld() == null) {
            return 63;
        }
        ChunkSnapshot chunk = this.getWorld().getEmptyChunkSnapshot(this.getBlockX() >> 4, this.getBlockZ() >> 4, true, true);
        int x = this.getBlockX() % 16;
        x = x < 0 ? 16 + x : x;
        int z = this.getBlockZ() % 16;
        z = z < 0 ? 16 + z : z;
        return chunk.getHighestBlockYAt(x, z);
    }

    public Material getBlockType() {
        Location loc = this.getBukkitLoc();
        if (loc == null) {
            return Material.AIR;
        }
        try {
            if (Version.isCurrentEqualOrHigher(Version.v1_16_R1) && !super.isWorldLoaded()) {
                return Material.AIR;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.getBlock().getType();
    }

    public CMIMaterial getBlockCMIType() {
        Location loc = this.getBukkitLoc();
        if (loc == null) {
            return CMIMaterial.AIR;
        }
        try {
            if (Version.isCurrentEqualOrHigher(Version.v1_16_R1) && !super.isWorldLoaded()) {
                return CMIMaterial.AIR;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CMIMaterial mat = CMIMaterial.get(this.getBlock());
        return mat == CMIMaterial.NONE ? CMIMaterial.AIR : mat;
    }

    public static Material getBlockTypeSafe(Location loc) {
        if (loc == null) {
            return Material.AIR;
        }
        int x = loc.getBlockX();
        int z = loc.getBlockZ();
        int y = loc.getBlockY();
        int cx = Math.abs(loc.getBlockX() % 16);
        int cz = Math.abs(loc.getBlockZ() % 16);
        World world = loc.getWorld();
        ChunkSnapshot chunkSnapshot = null;
        if (!world.getBlockAt(x, 0, z).getChunk().isLoaded()) {
            world.getBlockAt(x, 0, z).getChunk().load();
            chunkSnapshot = world.getBlockAt(x, 0, z).getChunk().getChunkSnapshot(false, false, false);
            world.getBlockAt(x, 0, z).getChunk().unload();
        } else {
            chunkSnapshot = world.getBlockAt(x, 0, z).getChunk().getChunkSnapshot();
        }
        if (chunkSnapshot == null) {
            return Material.AIR;
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            BlockData type = chunkSnapshot.getBlockData(cx, y, cz);
            return type.getMaterial();
        }
        if (getBlockTypeId == null) {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            try {
                getBlockTypeId = lookup.findVirtual(ChunkSnapshot.class, "getBlockTypeId", MethodType.methodType(Integer.TYPE, Integer.TYPE, Integer.TYPE)).asType(MethodType.methodType(Integer.TYPE, ChunkSnapshot.class));
                getBlockData = lookup.findVirtual(ChunkSnapshot.class, "getBlockData", MethodType.methodType(Integer.TYPE, Integer.TYPE, Integer.TYPE)).asType(MethodType.methodType(Integer.TYPE, ChunkSnapshot.class));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        if (getBlockTypeId == null || getBlockData == null) {
            return Material.AIR;
        }
        try {
            int type = getBlockTypeId.invokeExact(chunkSnapshot);
            if (type == 0) {
                return Material.AIR;
            }
            int data = getBlockData.invokeExact(chunkSnapshot);
            return CMIMaterial.get(type, data).getMaterial();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return Material.AIR;
        }
    }

    public static CMILocation fromString(String map) {
        return CMILocation.fromString(map, map.contains(";") ? ";" : ":");
    }

    public static CMILocation fromString(String map, String separator) {
        CMILocation loc = null;
        if (map == null) {
            return null;
        }
        if (!map.contains(separator)) {
            return null;
        }
        String[] split = map.replace(",", ".").split(separator);
        Double x = null;
        Double y = null;
        Double z = null;
        Float yaw = null;
        Float pitch = null;
        World world = null;
        String worldName = null;
        for (String one : split) {
            try {
                if (x == null) {
                    x = Double.parseDouble(one);
                    continue;
                }
                if (y == null) {
                    y = Double.parseDouble(one);
                    continue;
                }
                if (z == null) {
                    z = Double.parseDouble(one);
                    continue;
                }
                if (yaw == null) {
                    yaw = Float.valueOf(Float.parseFloat(one));
                    continue;
                }
                if (pitch == null) {
                    pitch = Float.valueOf(Float.parseFloat(one));
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            worldName = one;
            if (world != null) continue;
            world = CMIWorld.getWorld(one);
        }
        String string = worldName = world == null ? worldName : world.getName();
        if (worldName == null) {
            return null;
        }
        loc = new CMILocation(worldName, x == null ? 0.0 : x, y == null ? 0.0 : y, z == null ? 0.0 : z);
        loc.setYaw(yaw == null ? 0.0f : yaw.floatValue());
        loc.setPitch(pitch == null ? 0.0f : pitch.floatValue());
        return loc;
    }

    public static List<CMILocation> fromString(List<String> map) {
        return CMILocation.fromString(map, ";");
    }

    public static List<CMILocation> fromString(List<String> maps, String separator) {
        ArrayList<CMILocation> ls = new ArrayList<CMILocation>();
        for (String map : maps) {
            ls.add(CMILocation.fromString(map, separator));
        }
        return ls;
    }

    public static String toString(Location loc) {
        return CMILocation.toString(loc, ";", false, false);
    }

    public static String toString(Location loc, boolean simplified) {
        return CMILocation.toString(loc, ";", simplified, false);
    }

    public static String toString(Location loc, String separator) {
        return CMILocation.toString(loc, separator, false, false);
    }

    public static String toString(Location loc, String separator, boolean simplified) {
        return CMILocation.toString(loc, separator, simplified, false);
    }

    public static String toString(Location loc, String separator, boolean simplified, boolean integers) {
        StringBuilder map = new StringBuilder();
        try {
            if (loc != null && loc.getWorld() != null) {
                map.append(loc.getWorld().getName());
                if (integers) {
                    map.append(separator + loc.getBlockX());
                    map.append(separator + loc.getBlockY());
                    map.append(separator + loc.getBlockZ());
                } else {
                    map.append(separator + CMILocation.fNumber(loc.getX()));
                    map.append(separator + (double)((long)(loc.getY() * 100.0)) / 100.0);
                    map.append(separator + CMILocation.fNumber(loc.getZ()));
                }
                if (!simplified) {
                    if (integers) {
                        map.append(separator + (long)loc.getYaw());
                        map.append(separator + (long)loc.getPitch());
                    } else {
                        map.append(separator + (double)((long)(loc.getYaw() * 100.0f)) / 100.0);
                        map.append(separator + (double)((long)(loc.getPitch() * 100.0f)) / 100.0);
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return map.toString().replace(",", ".");
    }

    public static List<String> toString(List<CMILocation> loc) {
        return CMILocation.toString(loc, ";");
    }

    public static List<String> toString(List<CMILocation> locations, String separator) {
        ArrayList<String> ls = new ArrayList<String>();
        for (Location location : locations) {
            ls.add(CMILocation.toString(location, separator));
        }
        return ls;
    }

    private static Double fNumber(Double amount) {
        return (double)((long)(amount * 100.0)) / 100.0;
    }

    private static World getWorld(String name) {
        World w = Bukkit.getWorld((String)name);
        if (w != null) {
            return w;
        }
        name = name.replace("_", "").replace(".", "").replace("-", "");
        for (World one : Bukkit.getWorlds()) {
            String n = one.getName().replace("_", "").replace(".", "").replace("-", "");
            if (!n.equalsIgnoreCase(name)) continue;
            return one;
        }
        return null;
    }

    public static int getMinHeight(World world) {
        if (Version.isCurrentEqualOrLower(Version.v1_16_R3)) {
            return 0;
        }
        return world.getMinHeight();
    }

    public static double getDistance(Location loc1, Location loc2) {
        if (loc1 == null || loc2 == null || loc1.getWorld() != loc2.getWorld()) {
            return 2.147483647E9;
        }
        try {
            return loc1.distance(loc2);
        }
        catch (Throwable e) {
            return 2.147483647E9;
        }
    }
}

