/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.Container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Container.CMIText;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class CMIWorld {
    static HashMap<String, String> worldNames = new HashMap();

    public static void onDisable() {
        worldNames.clear();
    }

    public static String getWorldNameFormatted(World world) {
        if (world == null || world.getName() == null) {
            return "Unknown";
        }
        String name = worldNames.get(world.getName());
        return name != null ? name : world.getName();
    }

    public static void initialize() {
        List<String> worlds = new ArrayList<String>();
        for (World one : Bukkit.getWorlds()) {
            worlds.add(one.getName() + "-&2" + CMIText.everyFirstToUpperCase(one.getName().replace("_", " ")));
        }
        ConfigReader locale = CMILib.getInstance().getConfigManager().getLocaleConfig();
        worlds = locale.get("Location.WorldNames", worlds);
        worldNames.clear();
        for (String one : worlds) {
            String[] wsplit;
            if (one.endsWith(" ")) {
                one = one.substring(0, one.length() - 1);
            }
            if ((wsplit = one.split("-", 2)).length == 1) continue;
            worldNames.put(wsplit[0], wsplit[1]);
        }
        if (worldNames.isEmpty()) {
            worldNames.put("--NothingFound--", "--NothingFound--");
        }
    }

    public static boolean insideWorldBorder(Location loc) {
        try {
            Location center = loc.getWorld().getWorldBorder().getCenter();
            double size = loc.getWorld().getWorldBorder().getSize() / 2.0;
            double minX = center.getX() - size;
            double maxX = center.getX() + size;
            double minZ = center.getZ() - size;
            double maxZ = center.getZ() + size;
            return loc.getX() >= minX && loc.getX() < maxX && loc.getZ() >= minZ && loc.getZ() < maxZ;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return true;
        }
    }

    public static int getMinHeight(World world) {
        if (Version.isCurrentEqualOrLower(Version.v1_16_R3)) {
            return 0;
        }
        return world.getMinHeight();
    }

    public static int getMaxHeight(World world) {
        if (world == null) {
            return 256;
        }
        if (world.getEnvironment() == null) {
            return 256;
        }
        try {
            switch (world.getEnvironment()) {
                case NETHER: {
                    return 128;
                }
                case NORMAL: 
                case THE_END: {
                    if (Version.isCurrentEqualOrHigher(Version.v1_17_R1)) {
                        return world.getMaxHeight();
                    }
                    return 256;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return 256;
    }

    public static World getWorld(String name) {
        World w = Bukkit.getWorld((String)name);
        if (w != null) {
            return w;
        }
        name = name.replaceAll("[_|.|-]", "");
        for (World one : Bukkit.getWorlds()) {
            String n = one.getName().replaceAll("[_|.|-]", "");
            if (!n.equalsIgnoreCase(name)) continue;
            return one;
        }
        return null;
    }
}

