/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.Items;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Container.CMIText;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import org.bukkit.potion.PotionEffectType;

public class CMIPotionEffect {
    private static HashMap<String, List<String>> potyionEffectList = new HashMap();
    private static final Map<Integer, PotionEffectType> byId = new HashMap<Integer, PotionEffectType>();
    private static final Map<String, PotionEffectType> byName = new HashMap<String, PotionEffectType>();

    public static void saveEnchants() {
        for (PotionEffectType one : PotionEffectType.values()) {
            if (one == null) continue;
            byId.put(one.getId(), one);
            byName.put(one.getName(), one);
        }
    }

    public static PotionEffectType getById(int id) {
        return byId.get(id);
    }

    public static PotionEffectType get(String nameId) {
        PotionEffectType enchant = CMIPotionEffect.getByName(nameId);
        if (enchant == null) {
            try {
                enchant = CMIPotionEffect.getById(Integer.parseInt(nameId));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return enchant;
    }

    public static PotionEffectType getByName(String name) {
        name = name.replace("_", "");
        block0: for (Map.Entry<String, List<String>> oneEntry : potyionEffectList.entrySet()) {
            for (String oneVar : oneEntry.getValue()) {
                if (!oneVar.replace("_", "").equalsIgnoreCase(name)) continue;
                name = oneEntry.getKey();
                break block0;
            }
        }
        name = name.replace("_", "");
        for (PotionEffectType one : PotionEffectType.values()) {
            if (one == null || one.getName() == null) continue;
            if (one.getName().replace("_", "").equalsIgnoreCase(name)) {
                return one;
            }
            if (!one.toString().replace("_", "").equalsIgnoreCase(name)) continue;
            return one;
        }
        return null;
    }

    public static PotionEffectType[] values() {
        return byId.values().toArray(new PotionEffectType[byId.size()]);
    }

    public static String getName(PotionEffectType enchant) {
        if (enchant == null || enchant.getName() == null) {
            return null;
        }
        for (Map.Entry<String, List<String>> oneEntry : potyionEffectList.entrySet()) {
            if (!oneEntry.getKey().replace("_", "").equalsIgnoreCase(enchant.getName().replace("_", "")) || oneEntry.getValue().isEmpty()) continue;
            return oneEntry.getValue().get(0);
        }
        return enchant.getName();
    }

    public static void initialize() {
        PotionEffectType[] enchants;
        ConfigReader locale = CMILib.getInstance().getConfigManager().getLocaleConfig();
        for (PotionEffectType one : enchants = PotionEffectType.values()) {
            String name;
            if (one == null || (name = one.getName()) == null) continue;
            List<String> ls = potyionEffectList.get(name.toLowerCase());
            if (ls == null) {
                ls = new ArrayList<String>();
            }
            List<String> l = locale.get("info.PotionEffectAliases." + name.toLowerCase(), Arrays.asList(CMIText.firstToUpperCase(name)));
            for (String oneL : l) {
                if (ls.contains(oneL.replace(" ", "_"))) continue;
                ls.add(oneL.replace(" ", "_"));
            }
            potyionEffectList.put(name.toLowerCase(), ls);
        }
        CMIPotionEffect.saveEnchants();
    }
}

