/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.Recipes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum CMIRecipeType {
    Shaped(Arrays.asList(11, 12, 13, 20, 21, 22, 29, 30, 31)),
    Shapeless(Arrays.asList(11, 12, 13, 20, 21, 22, 29, 30, 31)),
    Furnace(20, true),
    Blasting(20, true),
    Campfire(20, true),
    Cooking(20, true),
    Merchant(20),
    Smoking(20, true),
    Stonecutting(20),
    Smithing(2, Arrays.asList(20, 21)),
    Complex(20),
    Unknown(20);

    private List<Integer> ingredientSlots = new ArrayList<Integer>();
    private int minSlots = 1;
    private boolean timeAndExp = false;

    private CMIRecipeType(int minSlots, List<Integer> ingredientSlots) {
        this.ingredientSlots = ingredientSlots;
        this.minSlots = minSlots;
    }

    private CMIRecipeType(int ingredientSlot, boolean timeAndExp) {
        this.ingredientSlots.clear();
        this.ingredientSlots.add(ingredientSlot);
        this.timeAndExp = timeAndExp;
    }

    private CMIRecipeType(int ingredientSlot) {
        this.ingredientSlots.clear();
        this.ingredientSlots.add(ingredientSlot);
    }

    private CMIRecipeType(List<Integer> ingredientSlots) {
        this.ingredientSlots = ingredientSlots;
    }

    public static CMIRecipeType getByName(String name) {
        name = (name = name.toLowerCase()).endsWith("recipe") ? name.substring(0, name.length() - 6) : name;
        name = name.startsWith("craft") ? name.substring(5, name.length()) : name;
        name = name.endsWith("transform") ? name.substring(0, name.length() - 9) : name;
        for (CMIRecipeType one : CMIRecipeType.values()) {
            if (!one.name().equalsIgnoreCase(name)) continue;
            return one;
        }
        return Unknown;
    }

    public List<Integer> getIngredientSlots() {
        return this.ingredientSlots;
    }

    public int getMinSlots() {
        return this.minSlots;
    }

    public boolean isTimeAndExp() {
        return this.timeAndExp;
    }
}

