/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.Time;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.Time.TimeInfo;

public class CMITimeManager {
    static double tPHour = 1000.0;
    static double tPMin = 16.666666666666668;
    static double tPSec = 0.2777777777777778;
    static int dayTime = 600;
    static int sunriseTime = 90;
    static int sunsetTime = 90;
    static int nightTime = 420;
    private List<String> worlds = new ArrayList<String>();

    public List<String> getWorlds() {
        return this.worlds;
    }

    public static int timeInInt() {
        return CMITimeManager.timeInInt(System.currentTimeMillis());
    }

    public static int timeInInt(Long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        return Integer.valueOf(new SimpleDateFormat("YYMMdd").format(calendar.getTime()));
    }

    public static String to24hour(Long ticks) {
        long hours = ticks / 1000L + 6L;
        long minutes = ticks % 1000L * 60L / 1000L;
        if (hours >= 24L) {
            hours -= 24L;
        }
        return hours + ":" + (minutes < 10L ? "0" + minutes : Long.valueOf(minutes));
    }

    public static String to24hourShort(Long ticks) {
        return CMITimeManager.to24hourShort(ticks, true);
    }

    public static String to24hourShort(Long ticks, boolean trim) {
        long years = ticks / 1000L / 60L / 60L / 24L / 365L;
        ticks = ticks - years * 1000L * 60L * 60L * 24L * 365L;
        long days = ticks / 1000L / 60L / 60L / 24L;
        ticks = ticks - days * 1000L * 60L * 60L * 24L;
        long hours = ticks / 1000L / 60L / 60L;
        ticks = ticks - hours * 1000L * 60L * 60L;
        long minutes = ticks / 1000L / 60L;
        ticks = ticks - minutes * 1000L * 60L;
        long sec = ticks / 1000L;
        ticks = ticks - sec * 1000L;
        String time = "";
        if (years > 0L) {
            time = time + (years == 1L ? LC.info_oneYear.getLocale("[years]", years) : LC.info_years.getLocale("[years]", years));
        }
        if (days > 0L || !trim && years > 0L) {
            time = time + (days == 1L ? LC.info_oneDay.getLocale("[days]", days) : LC.info_day.getLocale("[days]", days));
        }
        if (hours > 0L || !trim && (days > 0L || years > 0L)) {
            time = time + (hours == 1L ? LC.info_oneHour.getLocale("[hours]", hours) : LC.info_hour.getLocale("[hours]", hours));
        }
        if (minutes > 0L || !trim && (hours > 0L || days > 0L || years > 0L)) {
            time = time + LC.info_min.getLocale("[mins]", minutes);
        }
        if (sec > 0L || !trim && (minutes > 0L || hours > 0L || days > 0L || years > 0L)) {
            time = time + LC.info_sec.getLocale("[secs]", sec);
        }
        if (time.isEmpty()) {
            time = time + LC.info_sec.getLocale("[secs]", 0);
        }
        return time;
    }

    public static String to24hourAproximateShort(Long ticks, boolean trim) {
        long years = ticks / 1000L / 60L / 60L / 24L / 365L;
        if (years > 0L) {
            ticks = ticks / 1000L / 60L / 60L / 24L * 1000L * 60L * 60L * 24L;
        }
        ticks = ticks - years * 1000L * 60L * 60L * 24L * 365L;
        int months = 0;
        int weeks = 0;
        long days = ticks / 1000L / 60L / 60L / 24L;
        if (days > 30L) {
            months = (int)(days / 30L);
            days -= (long)(months * 30);
        }
        if (days > 7L) {
            weeks = (int)(days / 7L);
            days -= (long)(weeks * 7);
        }
        if (months > 0) {
            ticks = ticks / 1000L / 60L / 60L * 1000L * 60L * 60L;
        }
        if (weeks > 0) {
            ticks = ticks / 1000L / 60L * 1000L * 60L;
        }
        ticks = ticks - (long)months * 1000L * 60L * 60L * 24L * 30L;
        ticks = ticks - (long)weeks * 1000L * 60L * 60L * 24L * 7L;
        ticks = ticks - days * 1000L * 60L * 60L * 24L;
        long hours = ticks / 1000L / 60L / 60L;
        ticks = ticks - hours * 1000L * 60L * 60L;
        long minutes = ticks / 1000L / 60L;
        ticks = ticks - minutes * 1000L * 60L;
        long sec = ticks / 1000L;
        ticks = ticks - sec * 1000L;
        String time = "";
        if (years > 0L) {
            time = time + (years == 1L ? LC.info_oneYear.getLocale("[years]", years) : LC.info_years.getLocale("[years]", years));
        }
        if (months > 0 || !trim && years > 0L) {
            time = time + (months == 1 ? LC.info_oneMonth.getLocale("[months]", months) : LC.info_months.getLocale("[months]", months));
        }
        if (weeks > 0 || !trim && (months > 0 || years > 0L)) {
            time = time + (weeks == 1 ? LC.info_oneWeek.getLocale("[weeks]", weeks) : LC.info_weeks.getLocale("[weeks]", weeks));
        }
        if (days > 0L || !trim && (weeks > 0 || months > 0) && years == 0L) {
            time = time + (days == 1L ? LC.info_oneDay.getLocale("[days]", days) : LC.info_day.getLocale("[days]", days));
        }
        if (hours > 0L || !trim && (days > 0L || weeks > 0 || months > 0 || years > 0L)) {
            time = time + (hours == 1L ? LC.info_oneHour.getLocale("[hours]", hours) : LC.info_hour.getLocale("[hours]", hours));
        }
        if (minutes > 0L || !trim && (hours > 0L || days > 0L || weeks > 0 || months > 0 || years > 0L)) {
            time = time + LC.info_min.getLocale("[mins]", minutes);
        }
        if (sec > 0L || !trim && (minutes > 0L || hours > 0L || days > 0L || weeks > 0 || months > 0 || years > 0L)) {
            time = time + LC.info_sec.getLocale("[secs]", sec);
        }
        if (time.isEmpty()) {
            time = time + LC.info_sec.getLocale("[secs]", 0);
        }
        return time;
    }

    public static String toOnlyHoursShort(Long ticks, boolean trim, boolean includeMinutes) {
        long years = ticks / 1000L / 60L / 60L / 24L / 365L;
        ticks = ticks - years * 1000L * 60L * 60L * 24L * 365L;
        long days = ticks / 1000L / 60L / 60L / 24L;
        ticks = ticks - days * 1000L * 60L * 60L * 24L;
        long hours = ticks / 1000L / 60L / 60L;
        ticks = ticks - hours * 1000L * 60L * 60L;
        long minutes = ticks / 1000L / 60L;
        ticks = ticks - minutes * 1000L * 60L;
        long sec = ticks / 1000L;
        ticks = ticks - sec * 1000L;
        String time = "";
        hours += years * 365L * 24L + days * 24L;
        String fraction = "";
        if (minutes != 0L && !trim && !includeMinutes) {
            fraction = "." + minutes * 100L / 60L;
        }
        if (hours > 0L || !trim && (days > 0L || years > 0L)) {
            time = time + (hours == 1L ? LC.info_oneHour.getLocale("[hours]", hours + fraction) : LC.info_hour.getLocale("[hours]", hours + fraction));
        }
        if (includeMinutes && (minutes > 0L || !trim && (hours > 0L || days > 0L || years > 0L))) {
            time = time + LC.info_min.getLocale("[mins]", minutes);
        }
        return time;
    }

    public static String to12hour(Long ticks) {
        long hours = ticks / 1000L + 6L;
        long minutes = ticks % 1000L * 60L / 1000L;
        if (hours >= 24L) {
            hours -= 24L;
        }
        String form = LC.info_variables_am.getLocale(new Object[0]);
        if (hours >= 12L) {
            form = LC.info_variables_pm.getLocale(new Object[0]);
        }
        if (hours > 12L) {
            hours -= 12L;
        }
        return hours + ":" + (minutes < 10L ? "0" + minutes : Long.valueOf(minutes)) + form;
    }

    public static TimeInfo convertToTicks(TimeInfo tInfo) {
        double minticks = (double)tInfo.getMinutes() * tPMin * 100.0 % 100.0;
        double Fmin = (double)tInfo.getMinutes() * tPMin;
        if (minticks > 60.0) {
            Fmin += 2.0;
        } else if (minticks > 30.0) {
            Fmin += 1.0;
        }
        tInfo.setTicks((int)((double)tInfo.getHours() * tPHour + Fmin + (double)tInfo.getSeconds() * tPSec));
        tInfo.setTicks(tInfo.getTicks() - 6000);
        tInfo.setTicks(tInfo.getTicks() < 0 ? 24000 - tInfo.getTicks() : tInfo.getTicks());
        tInfo.setTicks(tInfo.getTicks() > 24000 ? 24000 - tInfo.getTicks() % 24000 : tInfo.getTicks());
        return tInfo;
    }

    public static TimeInfo stringToTimeInfo(String time) {
        TimeInfo tInfo = new TimeInfo();
        time = time.toLowerCase();
        ArrayList<String> splited = new ArrayList<String>();
        int additional = 0;
        if (time.contains("pm")) {
            time = time.replace("pm", "");
            additional = 12;
        } else if (time.contains("am")) {
            time = time.replace("am", "");
        } else if (time.contains("ticks")) {
            time = time.replace("ticks", "");
            long ticks = -1L;
            try {
                ticks = Long.parseLong(time);
            }
            catch (NumberFormatException e) {
                return tInfo;
            }
            if (ticks < 0L) {
                return tInfo;
            }
            tInfo.setTicks((int)ticks);
            return tInfo;
        }
        if (time.contains(":")) {
            splited.addAll(new LinkedList<String>(Arrays.asList(time.split(":"))));
        } else {
            splited.add(time);
        }
        try {
            tInfo.setHours(Integer.parseInt((String)splited.get(0)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (tInfo.getHours() > 24 || tInfo.getHours() < 0) {
            tInfo.setHours(-1);
        }
        if (splited.size() > 1) {
            try {
                tInfo.setMinutes(Integer.parseInt((String)splited.get(1)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (tInfo.getMinutes() > 60 || tInfo.getMinutes() < 0) {
            tInfo.setHours(-1);
        }
        if (splited.size() > 2) {
            try {
                tInfo.setSeconds(Integer.parseInt((String)splited.get(2)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (tInfo.getSeconds() > 60 || tInfo.getSeconds() < 0) {
            tInfo.setHours(-1);
        }
        tInfo.setHours(tInfo.getHours() + additional);
        return tInfo;
    }

    public static String MiliToDate(long currentTime) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(currentTime);
        return formatter.format(calendar.getTime());
    }

    public static int[] splitToComponentDate(Long biggys) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(biggys);
        int mYear = calendar.get(1);
        int mMonth = calendar.get(2);
        int mDay = calendar.get(5);
        int[] ints = new int[]{mYear, mMonth, mDay};
        return ints;
    }

    public static int[] splitToComponentTimes(Long biggys) {
        int biggy = (int)(System.currentTimeMillis() - biggys) / 1000;
        int hours = biggy / 3600;
        int mins = biggy % 3600 / 60;
        int secs = biggy % 60;
        int[] ints = new int[]{hours, mins, secs};
        return ints;
    }
}

