/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.Version.Schedulers;

import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Container.CMINumber;
import net.Zrips.CMILib.Version.Schedulers.CMIBaseImpl;
import net.Zrips.CMILib.Version.Schedulers.CMIFoliaTask;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import net.Zrips.CMILib.Version.Schedulers.CMITaskResult;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CMIFoliaImpl
implements CMIBaseImpl {
    private final JavaPlugin plugin;
    private final RegionScheduler regionScheduler;
    private final GlobalRegionScheduler globalRegionScheduler;
    private final AsyncScheduler asyncScheduler;

    public CMIFoliaImpl(CMILib plugin) {
        this.plugin = plugin;
        this.globalRegionScheduler = this.plugin.getServer().getGlobalRegionScheduler();
        this.asyncScheduler = this.plugin.getServer().getAsyncScheduler();
        this.regionScheduler = this.plugin.getServer().getRegionScheduler();
    }

    @Override
    public CompletableFuture<Void> runTask(Runnable runnable) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.globalRegionScheduler.execute((Plugin)this.plugin, () -> {
            runnable.run();
            future.complete(null);
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> runTaskAsynchronously(Runnable runnable) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.asyncScheduler.runNow((Plugin)this.plugin, task -> {
            runnable.run();
            future.complete(null);
        });
        return future;
    }

    private static long clamp(long delay) {
        return CMINumber.clamp(delay, 1L, Math.abs(delay));
    }

    @Override
    public CMITask runTaskLater(Runnable runnable, long delay) {
        return new CMIFoliaTask(this.globalRegionScheduler.runDelayed((Plugin)this.plugin, task -> runnable.run(), CMIFoliaImpl.clamp(delay)));
    }

    @Override
    public CMITask runLaterAsync(Runnable runnable, long delay) {
        return new CMIFoliaTask(this.asyncScheduler.runDelayed((Plugin)this.plugin, task -> runnable.run(), CMIFoliaImpl.clamp(delay) * 50L, TimeUnit.MILLISECONDS));
    }

    @Override
    public CMITask scheduleSyncRepeatingTask(Runnable runnable, long delay, long period) {
        return new CMIFoliaTask(this.globalRegionScheduler.runAtFixedRate((Plugin)this.plugin, task -> runnable.run(), CMIFoliaImpl.clamp(delay), CMIFoliaImpl.clamp(period)));
    }

    @Override
    public CMITask runTimerAsync(Runnable runnable, long delay, long period) {
        return new CMIFoliaTask(this.asyncScheduler.runAtFixedRate((Plugin)this.plugin, task -> runnable.run(), CMIFoliaImpl.clamp(delay) * 50L, CMIFoliaImpl.clamp(period) * 50L, TimeUnit.MILLISECONDS));
    }

    @Override
    public CompletableFuture<Void> runAtLocation(Location location, Runnable runnable) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.regionScheduler.execute((Plugin)this.plugin, location, () -> {
            runnable.run();
            future.complete(null);
        });
        return future;
    }

    @Override
    public CMITask runAtLocationLater(Location location, Runnable runnable, long delay) {
        return new CMIFoliaTask(this.regionScheduler.runDelayed((Plugin)this.plugin, location, task -> runnable.run(), CMIFoliaImpl.clamp(delay)));
    }

    @Override
    public CMITask runAtLocationTimer(Location location, Runnable runnable, long delay, long period) {
        return new CMIFoliaTask(this.regionScheduler.runAtFixedRate((Plugin)this.plugin, location, task -> runnable.run(), CMIFoliaImpl.clamp(delay), CMIFoliaImpl.clamp(period)));
    }

    @Override
    public CompletableFuture<CMITaskResult> runAtEntity(Entity entity, Runnable runnable) {
        CompletableFuture<CMITaskResult> future = new CompletableFuture<CMITaskResult>();
        boolean success = entity.getScheduler().execute((Plugin)this.plugin, () -> {
            runnable.run();
            future.complete(CMITaskResult.SUCCESS);
        }, null, 0L);
        if (!success) {
            future.complete(CMITaskResult.SCHEDULER_RETIRED);
        }
        return future;
    }

    @Override
    public CompletableFuture<CMITaskResult> runAtEntityWithFallback(Entity entity, Runnable runnable, Runnable fallback) {
        CompletableFuture<CMITaskResult> future = new CompletableFuture<CMITaskResult>();
        boolean success = entity.getScheduler().execute((Plugin)this.plugin, () -> {
            runnable.run();
            future.complete(CMITaskResult.SUCCESS);
        }, () -> {
            fallback.run();
            future.complete(CMITaskResult.ENTITY_RETIRED);
        }, 0L);
        if (!success) {
            future.complete(CMITaskResult.SCHEDULER_RETIRED);
        }
        return future;
    }

    @Override
    public CMITask runAtEntityLater(Entity entity, Runnable runnable, long delay) {
        return new CMIFoliaTask(entity.getScheduler().runDelayed((Plugin)this.plugin, task -> runnable.run(), null, CMIFoliaImpl.clamp(delay)));
    }

    @Override
    public CMITask runAtEntityTimer(Entity entity, Runnable runnable, long delay, long period) {
        return new CMIFoliaTask(entity.getScheduler().runAtFixedRate((Plugin)this.plugin, task -> runnable.run(), null, CMIFoliaImpl.clamp(delay), CMIFoliaImpl.clamp(period)));
    }
}

