/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.command.main;

import java.util.Locale;
import org.geysermc.floodgate.command.main.FirewallCheckSubcommand;
import org.geysermc.floodgate.command.main.VersionSubcommand;
import org.geysermc.floodgate.command.util.Permission;
import org.geysermc.floodgate.platform.command.FloodgateCommand;
import org.geysermc.floodgate.platform.command.FloodgateSubCommand;
import org.geysermc.floodgate.platform.command.SubCommands;
import org.geysermc.floodgate.player.UserAudience;
import org.geysermc.floodgate.shadow.cloud.commandframework.ArgumentDescription;
import org.geysermc.floodgate.shadow.cloud.commandframework.Command;
import org.geysermc.floodgate.shadow.cloud.commandframework.CommandManager;
import org.geysermc.floodgate.shadow.cloud.commandframework.context.CommandContext;

public final class MainCommand
extends SubCommands
implements FloodgateCommand {
    public MainCommand() {
        this.defineSubCommand(FirewallCheckSubcommand.class);
        this.defineSubCommand(VersionSubcommand.class);
    }

    @Override
    public Command<UserAudience> buildCommand(CommandManager<UserAudience> commandManager) {
        Command.Builder<UserAudience> builder = commandManager.commandBuilder("floodgate", ArgumentDescription.of("A set of Floodgate related actions in one command"), new String[0]).senderType(UserAudience.class).permission(Permission.COMMAND_MAIN.get()).handler(this::execute);
        for (FloodgateSubCommand subCommand : this.subCommands()) {
            commandManager.command(builder.literal(subCommand.name().toLowerCase(Locale.ROOT), subCommand.description()).permission(subCommand.permission().get()).handler(subCommand::execute));
        }
        return builder.build();
    }

    @Override
    public void execute(CommandContext<UserAudience> context) {
        StringBuilder helpMessage = new StringBuilder("Available subcommands are:\n");
        for (FloodgateSubCommand subCommand : this.subCommands()) {
            if (!context.getSender().hasPermission(subCommand.permission().get())) continue;
            helpMessage.append('\n').append('\u00a7').append('b').append(subCommand.name().toLowerCase(Locale.ROOT)).append('\u00a7').append("f - ").append('\u00a7').append('7').append(subCommand.description());
        }
        context.getSender().sendMessage(helpMessage.toString());
    }
}

