/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.module;

import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.geysermc.floodgate.SpigotPlugin;
import org.geysermc.floodgate.command.util.Permission;
import org.geysermc.floodgate.module.CommandModule;
import org.geysermc.floodgate.platform.command.CommandUtil;
import org.geysermc.floodgate.player.FloodgateCommandPreprocessor;
import org.geysermc.floodgate.player.UserAudience;
import org.geysermc.floodgate.shadow.cloud.commandframework.CommandManager;
import org.geysermc.floodgate.shadow.cloud.commandframework.bukkit.BukkitCommandManager;
import org.geysermc.floodgate.shadow.cloud.commandframework.execution.CommandExecutionCoordinator;
import org.geysermc.floodgate.shadow.com.google.inject.Provides;
import org.geysermc.floodgate.shadow.com.google.inject.Singleton;

public final class SpigotCommandModule
extends CommandModule {
    private final SpigotPlugin plugin;

    @Override
    protected void configure() {
        super.configure();
        this.registerPermissions();
    }

    @Provides
    @Singleton
    public CommandManager<UserAudience> commandManager(CommandUtil commandUtil) {
        BukkitCommandManager<UserAudience> commandManager = new BukkitCommandManager<UserAudience>((Plugin)this.plugin, CommandExecutionCoordinator.simpleCoordinator(), commandUtil::getUserAudience, audience -> (CommandSender)audience.source());
        commandManager.registerCommandPreProcessor(new FloodgateCommandPreprocessor(commandUtil));
        return commandManager;
    }

    private void registerPermissions() {
        PluginManager manager = Bukkit.getPluginManager();
        for (Permission permission : Permission.values()) {
            if (manager.getPermission(permission.get()) != null) continue;
            PermissionDefault defaultValue = PermissionDefault.getByName((String)permission.defaultValue().name());
            manager.addPermission(new org.bukkit.permissions.Permission(permission.get(), defaultValue));
        }
    }

    public SpigotCommandModule(SpigotPlugin plugin) {
        this.plugin = plugin;
    }
}

