/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.register;

import java.util.Set;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.geysermc.floodgate.platform.command.FloodgateCommand;
import org.geysermc.floodgate.player.UserAudience;
import org.geysermc.floodgate.shadow.cloud.commandframework.CommandManager;
import org.geysermc.floodgate.shadow.com.google.inject.Inject;
import org.geysermc.floodgate.shadow.com.google.inject.Injector;
import org.geysermc.floodgate.shadow.com.google.inject.Key;

public final class CommandRegister {
    private final CommandManager<UserAudience> commandManager;
    private final FloodgateConfig config;
    private final Injector guice;

    @Inject
    public CommandRegister(Injector guice) {
        this.commandManager = guice.getInstance(new Key<CommandManager<UserAudience>>(){});
        this.config = guice.getInstance(FloodgateConfig.class);
        this.guice = guice;
    }

    @Inject
    public void registerCommands(Set<FloodgateCommand> foundCommands) {
        for (FloodgateCommand command : foundCommands) {
            this.guice.injectMembers(command);
            if (!command.shouldRegister(this.config)) continue;
            this.commandManager.command(command.buildCommand(this.commandManager));
        }
    }
}

