/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.cloud.commandframework.arguments.standard;

import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.floodgate.shadow.cloud.commandframework.ArgumentDescription;
import org.geysermc.floodgate.shadow.cloud.commandframework.arguments.CommandArgument;
import org.geysermc.floodgate.shadow.cloud.commandframework.arguments.parser.ArgumentParseResult;
import org.geysermc.floodgate.shadow.cloud.commandframework.arguments.parser.ArgumentParser;
import org.geysermc.floodgate.shadow.cloud.commandframework.arguments.standard.IntegerArgument;
import org.geysermc.floodgate.shadow.cloud.commandframework.context.CommandContext;
import org.geysermc.floodgate.shadow.cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import org.geysermc.floodgate.shadow.cloud.commandframework.exceptions.parsing.NumberParseException;

public final class ShortArgument<C>
extends CommandArgument<C, Short> {
    private final short min;
    private final short max;

    private ShortArgument(boolean required, @NonNull String name, short min2, short max, String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new ShortParser(min2, max), defaultValue, Short.class, suggestionsProvider, defaultDescription);
        this.min = min2;
        this.max = max;
    }

    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull CommandArgument<C, Short> of(@NonNull String name) {
        return ShortArgument.newBuilder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, Short> optional(@NonNull String name) {
        return ShortArgument.newBuilder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, Short> optional(@NonNull String name, short defaultNum) {
        return ShortArgument.newBuilder(name).asOptionalWithDefault(defaultNum).build();
    }

    public short getMin() {
        return this.min;
    }

    public short getMax() {
        return this.max;
    }

    public static final class ShortParser<C>
    implements ArgumentParser<C, Short> {
        public static final short DEFAULT_MINIMUM = Short.MIN_VALUE;
        public static final short DEFAULT_MAXIMUM = Short.MAX_VALUE;
        private final short min;
        private final short max;

        public ShortParser(short min2, short max) {
            this.min = min2;
            this.max = max;
        }

        @Override
        public @NonNull ArgumentParseResult<Short> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(ShortParser.class, commandContext));
            }
            try {
                short value = Short.parseShort(input);
                if (value < this.min || value > this.max) {
                    return ArgumentParseResult.failure(new ShortParseException(input, this, commandContext));
                }
                inputQueue.remove();
                return ArgumentParseResult.success(value);
            }
            catch (Exception e) {
                return ArgumentParseResult.failure(new ShortParseException(input, this, commandContext));
            }
        }

        @Override
        public boolean isContextFree() {
            return true;
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            return IntegerArgument.IntegerParser.getSuggestions(this.min, this.max, input);
        }

        public short getMax() {
            return this.max;
        }

        public short getMin() {
            return this.min;
        }

        public boolean hasMax() {
            return this.max != Short.MAX_VALUE;
        }

        public boolean hasMin() {
            return this.min != Short.MIN_VALUE;
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, Short> {
        private short min = Short.MIN_VALUE;
        private short max = Short.MAX_VALUE;

        private Builder(@NonNull String name) {
            super(Short.class, name);
        }

        public @NonNull Builder<C> withMin(short min2) {
            this.min = min2;
            return this;
        }

        public @NonNull Builder<C> withMax(short max) {
            this.max = max;
            return this;
        }

        public @NonNull Builder<C> asOptionalWithDefault(short defaultValue) {
            return (Builder)this.asOptionalWithDefault(Short.toString(defaultValue));
        }

        public @NonNull ShortArgument<C> build() {
            return new ShortArgument(this.isRequired(), this.getName(), this.min, this.max, this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }

    public static final class ShortParseException
    extends NumberParseException {
        private static final long serialVersionUID = -478674263339091032L;
        private final ShortParser<?> parser;

        @Deprecated
        public ShortParseException(@NonNull String input, short min2, short max, @NonNull CommandContext<?> commandContext) {
            this(input, new ShortParser(min2, max), commandContext);
        }

        public ShortParseException(@NonNull String input, @NonNull ShortParser<?> parser, @NonNull CommandContext<?> commandContext) {
            super(input, ((ShortParser)parser).min, ((ShortParser)parser).max, ShortParser.class, commandContext);
            this.parser = parser;
        }

        @Override
        public boolean hasMin() {
            return this.parser.hasMin();
        }

        @Override
        public boolean hasMax() {
            return this.parser.hasMax();
        }

        @Override
        public @NonNull String getNumberType() {
            return "short";
        }
    }
}

