/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

public final class MessageFormatter {
    private static final String DELIM_STR = "{}";
    private static final int DELIM_LENGTH = "{}".length();

    public static String format(String message, Object ... arguments) {
        if (arguments == null || arguments.length == 0) {
            return message;
        }
        String[] args = new String[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            args[i] = arguments[i].toString();
        }
        int previousIndex = -1;
        StringBuilder stringBuilder = new StringBuilder(message.length() + MessageFormatter.getArgsContentLength(args));
        for (String argument : args) {
            int currentIndex = message.indexOf(DELIM_STR, previousIndex);
            if (currentIndex == -1) {
                if (previousIndex == -1) {
                    return message;
                }
                stringBuilder.append(message.substring(previousIndex));
                return stringBuilder.toString();
            }
            if (previousIndex == -1) {
                stringBuilder.append(message, 0, currentIndex);
            } else {
                stringBuilder.append(message, previousIndex, currentIndex);
            }
            stringBuilder.append(argument);
            previousIndex = currentIndex + DELIM_LENGTH;
        }
        if (previousIndex != message.length()) {
            stringBuilder.append(message, previousIndex, message.length());
        }
        return stringBuilder.toString();
    }

    public static int getArgsContentLength(String ... args) {
        int length = 0;
        for (String arg : args) {
            length += arg.length();
        }
        return length;
    }
}

