/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.gypopo.economyshopgui.VersionHandler;
import me.gypopo.economyshopgui.api.EconomyShopGUIHook;
import me.gypopo.economyshopgui.commands.SellGUI;
import me.gypopo.economyshopgui.commands.Sellall;
import me.gypopo.economyshopgui.commands.Shop;
import me.gypopo.economyshopgui.commands.ShopGive;
import me.gypopo.economyshopgui.commands.Sreload;
import me.gypopo.economyshopgui.commands.editshop.CommandManager;
import me.gypopo.economyshopgui.events.JoinEvent;
import me.gypopo.economyshopgui.events.LevelEvent;
import me.gypopo.economyshopgui.events.MenuHandler;
import me.gypopo.economyshopgui.files.ConfigManager;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.files.TransactionLog;
import me.gypopo.economyshopgui.methodes.CalculateAmount;
import me.gypopo.economyshopgui.methodes.CreateItem;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.methodes.StartupReload;
import me.gypopo.economyshopgui.methodes.UpdateChecker;
import me.gypopo.economyshopgui.metrics.Metrics;
import me.gypopo.economyshopgui.objects.LoreFormatter;
import me.gypopo.economyshopgui.objects.ShopInventory;
import me.gypopo.economyshopgui.objects.ShopItem;
import me.gypopo.economyshopgui.objects.ShopSection;
import me.gypopo.economyshopgui.objects.navbar.NavBar;
import me.gypopo.economyshopgui.providers.ModifierManager;
import me.gypopo.economyshopgui.providers.SpawnerManager;
import me.gypopo.economyshopgui.providers.UserManager;
import me.gypopo.economyshopgui.util.ConfigUtil;
import me.gypopo.economyshopgui.util.EcoType;
import me.gypopo.economyshopgui.util.EconomyHandler;
import me.gypopo.economyshopgui.util.SkullUtil;
import me.gypopo.economyshopgui.util.XMaterial;
import net.md_5.bungee.api.ChatColor;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.permission.Permission;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public final class EconomyShopGUI
extends JavaPlugin {
    public final int version = this.getVersion();
    public final boolean spigot = this.isSpigotServer();
    private Map<Integer, ItemStack> sectionItems = new HashMap<Integer, ItemStack>();
    private Map<Integer, String> mainMenuItemSlots = new HashMap<Integer, String>();
    private Map<String, ShopSection> sections = new HashMap<String, ShopSection>();
    private List<String> shopSections = new ArrayList<String>();
    private Map<String, String> sectionTitles = new HashMap<String, String>();
    public final List<String> supportedMatNames = this.setSupportedMatNames();
    public Map<String, List<ShopItem>> shopItemsByMaterialName;
    public List<String> ignoredNBTData;
    private final Map<String, HashMap<String, Double>> sellMultipliers = new HashMap<String, HashMap<String, Double>>();
    private final Map<String, HashMap<String, Double>> discounts = new HashMap<String, HashMap<String, Double>>();
    public List<GameMode> bannedGamemodes = new ArrayList<GameMode>();
    public Map<EntityType, String> spawnerNames = new HashMap<EntityType, String>();
    private final EconomyHandler ecoHandler = new EconomyHandler(this);
    public Permission permissions;
    private Locale locale;
    private NumberFormat curFormat;
    public boolean boughtItemsLore;
    public boolean dropItemsOnGround;
    public boolean allowIllegalStacks;
    public int maxShopSize;
    public int mainMenuSize;
    public boolean allowUnsafeEnchants;
    public boolean discountsActive;
    public boolean multipliers;
    public boolean useItemName;
    public boolean bedrock;
    public boolean resizeGUI;
    public boolean prefixSuffix = true;
    public boolean prioritizeItemLore;
    public boolean sellShulkers;
    public boolean MMB;
    public boolean seasonalLore;
    public String badYMLParse = null;
    private final Pattern rgbPattern = Pattern.compile("#[a-fA-F0-9]{6}");
    private static EconomyShopGUI instance;
    public VersionHandler versionHandler;
    public StartupReload startupReload = new StartupReload(this);
    private SendMessage sendMessage = new SendMessage(this);
    public CalculateAmount calculateAmount = new CalculateAmount(this);
    public CreateItem createItem = new CreateItem(this);
    public NavBar navBar = new NavBar(this);
    private JoinEvent joinEvent;
    public UpdateChecker updateChecker;
    private final EconomyShopGUIHook api = new EconomyShopGUIHook(this);
    private final TransactionLog transactionLog = new TransactionLog();
    private final UserManager userManager = new UserManager(this);
    private final ConfigManager configManager = new ConfigManager(this);
    private LoreFormatter loreFormatter;
    private ModifierManager modifierManager;
    private SkullUtil skullUtil;
    private Chat chat;
    private final SpawnerManager spawnerManager = new SpawnerManager(this);

    public static EconomyShopGUI getInstance() {
        return instance;
    }

    public void onEnable() {
        long start = System.currentTimeMillis();
        instance = this;
        this.configManager.loadConfig();
        this.startupReload.checkIfLanguageFilesExist();
        Lang.CONFIGS_RELOADED.reload();
        this.configManager.init();
        this.getConfigManager().validate();
        if (this.badYMLParse == null) {
            if (!this.ecoHandler.registerPaymentSolutions()) {
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
            this.startupReload.setupPluginVersion();
            ConfigUtil.updateConfigs();
            this.spawnerManager.init();
            this.setSkullUtil(new SkullUtil(this));
            this.userManager.init();
            this.setModifierManager(new ModifierManager(this));
            this.startupReload.checkDebugMode();
            this.startupReload.loadInventoryTitles();
            this.startupReload.loadItems();
            if (ConfigManager.getConfig().getBoolean("update-checking", true)) {
                this.updateChecker = new UpdateChecker();
            }
            SendMessage.infoMessage(Lang.DONE.get().replace("%millis%", String.valueOf(System.currentTimeMillis() - start)));
        } else {
            SendMessage.errorMessage("Skipping all settings and item loading because the configuration files could not be loaded...");
        }
        if (this.checkForGson()) {
            int pluginId = 5282;
            Metrics metrics = new Metrics((Plugin)this, pluginId);
        }
        this.registerPermissions();
        this.registerEvents();
        this.registerCommands();
        this.reloadPlayerData();
    }

    public void onDisable() {
        this.getServer().getOnlinePlayers().forEach(p -> {
            if (p.getOpenInventory().getTopInventory().getHolder() instanceof ShopInventory) {
                p.closeInventory();
            }
        });
        this.transactionLog.save();
        if (this.skullUtil != null) {
            this.skullUtil.saveCache();
        }
        this.sections.clear();
        this.supportedMatNames.clear();
        this.discounts.clear();
        this.spawnerNames.clear();
        Lang.DISABLING_PLUGIN.clearMessages();
        Bukkit.getPluginManager().disablePlugin((Plugin)instance);
        instance = null;
    }

    public void loadCurrencyFormat() {
        this.curFormat = this.getCurrencyFormat();
    }

    public TransactionLog getTransactionLog() {
        return this.transactionLog;
    }

    public Map<Integer, String> getMainMenuItemSlots() {
        return this.mainMenuItemSlots;
    }

    public String getMainMenuSectionForSlot(int slot) {
        return this.mainMenuItemSlots.get(slot);
    }

    public void setMainMenuItemSlots(Map<Integer, String> newMainMenuItemSlots) {
        this.mainMenuItemSlots = newMainMenuItemSlots;
    }

    public Map<Integer, ItemStack> getSectionItems() {
        return this.sectionItems;
    }

    public void setSectionItems(Map<Integer, ItemStack> newSectionItems) {
        this.sectionItems = newSectionItems;
    }

    public void addSection(String section, ShopSection shopSection) {
        this.sections.put(section, shopSection);
    }

    public Map<String, ShopSection> getSections() {
        return this.sections;
    }

    public ShopSection getSection(String section) {
        return this.sections.get(section);
    }

    public void setShopSections(List<String> newShopSections) {
        this.shopSections = newShopSections;
    }

    public List<String> getShopSections() {
        return this.shopSections;
    }

    public void removeShopSection(String section) {
        this.shopSections.remove(section);
    }

    public List<String> getSupportedMatNames() {
        return this.supportedMatNames;
    }

    public void addSpawnerName(EntityType entityType, String name) {
        this.spawnerNames.put(entityType, name);
    }

    public String getSpawnerName(EntityType entityType) {
        return this.spawnerNames.get(entityType);
    }

    public boolean isSeasonalPricing() {
        return this.modifierManager.hasSeasonalPrices();
    }

    private void setModifierManager(ModifierManager modifierManager) {
        this.modifierManager = modifierManager;
    }

    public void reloadModifiers() {
        this.modifierManager.reloadModifiers();
    }

    private void setSkullUtil(SkullUtil skullUtil) {
        this.skullUtil = skullUtil;
    }

    public HashMap<String, Double> getDiscounts(String section) {
        return this.discounts.get(section);
    }

    public void setDiscounts(HashMap<String, HashMap<String, Double>> discounts) {
        if (!this.discounts.isEmpty()) {
            this.discounts.clear();
        }
        this.discounts.putAll(discounts);
    }

    public boolean hasDiscount(String section) {
        return this.discounts.containsKey(section);
    }

    public HashMap<String, Double> getMultipliers(String section) {
        return this.sellMultipliers.get(section);
    }

    public boolean hasMultiplier(String section) {
        return this.sellMultipliers.containsKey(section);
    }

    public void setSellMultipliers(HashMap<String, HashMap<String, Double>> sellMultipliers) {
        if (!this.sellMultipliers.isEmpty()) {
            this.sellMultipliers.clear();
        }
        this.sellMultipliers.putAll(sellMultipliers);
    }

    public Map<String, String> getSectionTitles() {
        return this.sectionTitles;
    }

    public void setSectionTitles(HashMap<String, String> newSectionTitles) {
        this.sectionTitles = newSectionTitles;
    }

    public String getSectionTitle(String section) {
        return this.sectionTitles.get(section);
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public SpawnerManager getSpawnerManager() {
        return this.spawnerManager;
    }

    public Chat getChat() {
        return this.chat;
    }

    public void setLoreFormatter(LoreFormatter loreFormatter) {
        this.loreFormatter = loreFormatter;
    }

    public LoreFormatter getLoreFormatter() {
        return this.loreFormatter;
    }

    public String getDisplayName(Player p, String s) {
        try {
            if (this.chat != null && this.prefixSuffix) {
                return this.getPlayerPrefix(p) + org.bukkit.ChatColor.getLastColors((String)s.split("%player_displayname%")[0]) + p.getDisplayName() + this.getPlayerSuffix(p);
            }
            return p.getDisplayName();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.getPlayerPrefix(p) + p.getDisplayName() + this.getPlayerSuffix(p);
        }
    }

    public String getDisplayName(Player p) {
        if (this.chat != null && this.prefixSuffix) {
            return this.getPlayerPrefix(p) + p.getDisplayName() + this.getPlayerSuffix(p);
        }
        return p.getDisplayName();
    }

    private String getPlayerPrefix(Player p) {
        if (!this.chat.getPlayerPrefix(p).isEmpty()) {
            return this.formatColors(this.chat.getPlayerPrefix(p) + "&r ");
        }
        return "";
    }

    private String getPlayerSuffix(Player p) {
        if (!this.chat.getPlayerSuffix(p).isEmpty()) {
            return this.formatColors("&r " + this.chat.getPlayerSuffix(p));
        }
        return "";
    }

    public EconomyHandler getEcoHandler() {
        return this.ecoHandler;
    }

    public void reloadPlayerData() {
        this.userManager.reloadPlayerData();
    }

    public void reloadPermissions() {
        org.bukkit.permissions.Permission perm = this.getServer().getPluginManager().getPermission("EconomyShopGUI.shop.all");
        if (perm != null) {
            this.shopSections.forEach(s -> {
                String node = "EconomyShopGUI.shop." + s.toLowerCase(Locale.ENGLISH);
                if (!perm.getChildren().containsKey(node)) {
                    perm.getChildren().put(node, true);
                }
            });
        }
    }

    private void registerPermissions() {
        try {
            Bukkit.getPluginManager().addPermission(new org.bukkit.permissions.Permission("EconomyShopGUI.shop.all", "Gives access to all shop category's", PermissionDefault.TRUE, this.shopSections.stream().map(s -> "EconomyShopGUI.shop." + s.toLowerCase(Locale.ENGLISH)).collect(Collectors.toMap(Function.identity(), s -> true))));
            Bukkit.getPluginManager().addPermission(new org.bukkit.permissions.Permission("EconomyShopGUI.sellall.all", "Allows players to sell items to every shop section with the /sellall command", PermissionDefault.TRUE, this.shopSections.stream().map(s -> "EconomyShopGUI.sellall." + s.toLowerCase(Locale.ENGLISH)).collect(Collectors.toMap(Function.identity(), s -> true))));
            Bukkit.getPluginManager().addPermission(new org.bukkit.permissions.Permission("EconomyShopGUI.sellallitem.all", "Allows players to sell items to every shop section with the /sellall <item> command", PermissionDefault.TRUE, this.shopSections.stream().map(s -> "EconomyShopGUI.sellallitem." + s.toLowerCase(Locale.ENGLISH)).collect(Collectors.toMap(Function.identity(), s -> true))));
            Bukkit.getPluginManager().addPermission(new org.bukkit.permissions.Permission("EconomyShopGUI.sellallhand.all", "Allows players to sell items to every shop section with the /sellall hand command", PermissionDefault.TRUE, this.shopSections.stream().map(s -> "EconomyShopGUI.sellallhand." + s.toLowerCase(Locale.ENGLISH)).collect(Collectors.toMap(Function.identity(), s -> true))));
            Bukkit.getPluginManager().addPermission(new org.bukkit.permissions.Permission("EconomyShopGUI.sellgui.all", "Allows players to sell items to every shop section with the SellGUI screen", PermissionDefault.TRUE, this.shopSections.stream().map(s -> "EconomyShopGUI.sellgui." + s.toLowerCase(Locale.ENGLISH)).collect(Collectors.toMap(Function.identity(), s -> true))));
        }
        catch (IllegalArgumentException e) {
            SendMessage.logDebugMessage("Failed to register permissions, ignore this if you reloaded the plugin.");
            SendMessage.logDebugMessage(e.getMessage());
        }
    }

    private void registerEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)new MenuHandler(this), (Plugin)this);
        if (this.badYMLParse == null) {
            if (ConfigManager.getConfig().getBoolean("enable-levelevent")) {
                this.getServer().getPluginManager().registerEvents((Listener)new LevelEvent(), (Plugin)this);
            }
            this.joinEvent = new JoinEvent(this, ConfigManager.getConfig().getBoolean("enable-joinmessage"));
            this.getServer().getPluginManager().registerEvents((Listener)this.joinEvent, (Plugin)this);
        }
    }

    private void registerCommands() {
        try {
            Field bukkitCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            bukkitCommandMap.setAccessible(true);
            CommandMap commandMap = (CommandMap)bukkitCommandMap.get(Bukkit.getServer());
            if (this.badYMLParse != null || ConfigManager.getConfig().getBoolean("commands.shopgive", true)) {
                commandMap.register("economyshopgui", (Command)new ShopGive(this, this.getDisabledWorlds("shopgive")));
            }
            if (this.badYMLParse != null || ConfigManager.getConfig().getBoolean("commands.editshop", true)) {
                commandMap.register("economyshopgui", (Command)new CommandManager(this, this.getDisabledWorlds("editshop")));
            }
            if (this.badYMLParse != null || ConfigManager.getConfig().getBoolean("commands.sreload", true)) {
                commandMap.register("economyshopgui", (Command)new Sreload(this, this.getDisabledWorlds("sreload")));
            }
            if (this.badYMLParse != null || ConfigManager.getConfig().getBoolean("commands.shop", true)) {
                List<String> shopAliases;
                List list = shopAliases = this.badYMLParse != null ? new ArrayList() : ConfigManager.getConfig().getStringList("shop-commands");
                if (shopAliases.isEmpty()) {
                    shopAliases.add("shop");
                }
                commandMap.register("economyshopgui", (Command)new Shop(this, shopAliases, this.getDisabledWorlds("shop")));
            }
            if (this.badYMLParse != null || ConfigManager.getConfig().getBoolean("commands.sellall", true)) {
                List<String> sellallAliases;
                List list = sellallAliases = this.badYMLParse != null ? new ArrayList() : ConfigManager.getConfig().getStringList("sellall-commands");
                if (sellallAliases.isEmpty()) {
                    sellallAliases.add("sellall");
                }
                if (this.badYMLParse == null && Bukkit.getPluginManager().isPluginEnabled("Essentials")) {
                    this.overrideSellCommand(ConfigManager.getConfig().getBoolean("override-sell-command", true));
                }
                commandMap.register("economyshopgui", (Command)new Sellall(this, sellallAliases, this.getDisabledWorlds("sellall")));
            }
            if (this.badYMLParse != null || ConfigManager.getConfig().getBoolean("commands.sellgui", true)) {
                List<String> sellguiAliases;
                List list = sellguiAliases = this.badYMLParse != null ? new ArrayList() : ConfigManager.getConfig().getStringList("sellgui-commands");
                if (sellguiAliases.isEmpty()) {
                    sellguiAliases.add("sellgui");
                }
                commandMap.register("economyshopgui", (Command)new SellGUI(this, sellguiAliases, this.getDisabledWorlds("sellgui")));
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            SendMessage.errorMessage("Error registering commands.");
            e.printStackTrace();
        }
    }

    private List<String> getDisabledWorlds(String commandName) {
        if (this.badYMLParse == null && ConfigManager.getConfig().getBoolean("enable-disabled-worlds", false)) {
            return ConfigManager.getConfig().getStringList("disabled-worlds-per-command." + commandName);
        }
        return new ArrayList<String>();
    }

    public void loadChat() {
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Chat.class);
        if (rsp != null) {
            this.chat = (Chat)rsp.getProvider();
        }
    }

    public String initLore(String s) {
        ItemStack item = new ItemStack(Material.BARRIER);
        ItemMeta meta = item.getItemMeta();
        meta.setLore(Collections.singletonList(s));
        item.setItemMeta(meta);
        return this.versionHandler.getLoreAsNBT(item);
    }

    public YamlConfiguration loadConfiguration(File file, String fileName) {
        Validate.notNull((Object)file, (String)("Cannot load " + fileName + " config file."));
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load((Reader)new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
            if (this.badYMLParse != null && this.badYMLParse.equals(fileName)) {
                this.badYMLParse = null;
            }
            return config;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidConfigurationException e) {
            SendMessage.errorMessage("Cannot read " + fileName + " config because it is mis-configured, use a online Yaml parser with the error underneath here to find out the cause of the problem and to solve it. If you cannot find the cause yourself, join our discord support server that can be found at a plugin page of EconomyShopGUI.");
            e.printStackTrace();
        }
        this.badYMLParse = fileName;
        return null;
    }

    public YamlConfiguration loadConfiguration(BufferedReader reader, String fileName) {
        Validate.notNull((Object)reader, (String)("Cannot load " + fileName + " config file."));
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load((Reader)reader);
            if (this.badYMLParse != null && this.badYMLParse.equals(fileName)) {
                this.badYMLParse = null;
            }
            return config;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidConfigurationException e) {
            SendMessage.errorMessage("Cannot read " + fileName + " config because it is mis-configured, use a online Yaml parser with the error underneath here to find out the cause of the problem and to solve it. If you cannot find the cause yourself, join our discord support server that can be found at a plugin page of EconomyShopGUI.");
            e.printStackTrace();
        }
        this.badYMLParse = fileName;
        return null;
    }

    public void createConfigBackup() {
        String fileName = "config.yml";
        SendMessage.infoMessage(Lang.CREATING_BACKUP.get().replace("%fileName%", fileName));
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH-mm-ss");
        LocalDateTime now = LocalDateTime.now();
        Path backupDir = Paths.get(EconomyShopGUI.getInstance().getDataFolder() + "/backups/", new String[0]);
        if (!Files.exists(backupDir, new LinkOption[0]) || !Files.isDirectory(backupDir, new LinkOption[0])) {
            try {
                Files.createDirectory(backupDir, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        File file = new File(EconomyShopGUI.getInstance().getDataFolder(), fileName);
        try {
            try {
                Files.copy(file.toPath(), Paths.get(EconomyShopGUI.getInstance().getDataFolder() + "/backups/", "config " + dtf.format(now) + ".yml"), new CopyOption[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createConfigBackup(String fileName) {
        SendMessage.logDebugMessage(Lang.CREATING_BACKUP.get().replace("%fileName%", fileName));
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH-mm-ss");
        LocalDateTime now = LocalDateTime.now();
        Path backupDir = Paths.get(EconomyShopGUI.getInstance().getDataFolder() + "/backups/", new String[0]);
        if (!Files.exists(backupDir, new LinkOption[0]) || !Files.isDirectory(backupDir, new LinkOption[0])) {
            try {
                Files.createDirectory(backupDir, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        File file = new File(EconomyShopGUI.getInstance().getDataFolder(), fileName);
        try {
            try {
                Files.copy(file.toPath(), Paths.get(EconomyShopGUI.getInstance().getDataFolder() + "/backups/", fileName.substring(0, fileName.indexOf(".")) + " " + dtf.format(now) + ".yml"), new CopyOption[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void disablePlugin() {
        SendMessage.errorMessage(Lang.DISABLING_PLUGIN.get());
        this.sections.clear();
        this.supportedMatNames.clear();
        this.ignoredNBTData.clear();
        this.discounts.clear();
        this.spawnerNames.clear();
        Lang.DISABLING_PLUGIN.clearMessages();
        Bukkit.getPluginManager().disablePlugin((Plugin)instance);
        instance = null;
    }

    public String formatColors(String value) {
        if (this.version >= 116) {
            Matcher matcher = this.rgbPattern.matcher(value);
            while (matcher.find()) {
                String hex = value.substring(matcher.start(), matcher.end());
                ChatColor rgb = ChatColor.of((String)hex);
                if (matcher.start() != 0 && matcher.end() != value.length()) {
                    if (value.charAt(matcher.start() - 1) == '&') {
                        hex = "&" + hex;
                    }
                    if (value.charAt(matcher.start() - 1) == '{' && value.charAt(matcher.end()) == '}') {
                        hex = "{" + hex + "}";
                    }
                }
                value = value.replace(hex, rgb + "");
                matcher = this.rgbPattern.matcher(value);
            }
        }
        return org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)value).replace("\\n", "\n");
    }

    public int scheduleSyncDelayedTask(Runnable run, long delay) {
        return this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, run, delay);
    }

    public BukkitTask runTaskLaterAsync(Runnable run, long delay) {
        return this.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)this, run, delay);
    }

    public BukkitTask runTaskAsync(Runnable run) {
        return this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, run);
    }

    public String formatPrice(EcoType type, Double amount) {
        if (type != null && !this.ecoHandler.getEcon(type).isDecimal()) {
            amount = Math.round(amount);
        }
        if (amount == Math.floor(amount)) {
            return (amount == 1.0 ? this.ecoHandler.getEcon(type).getSingular() : this.ecoHandler.getEcon(type).getPlural()).replace("%price%", String.format(this.locale, "%,.0f", amount).replace("\u202f", ".").replace("\u00a0", "."));
        }
        return (amount == 1.0 ? this.ecoHandler.getEcon(type).getSingular() : this.ecoHandler.getEcon(type).getPlural()).replace("%price%", String.format(this.locale, "%,.2f", amount).replace("\u202f", ".").replace("\u00a0", "."));
    }

    private NumberFormat getCurrencyFormat() {
        DecimalFormat currencyFormat;
        String locale = ConfigManager.getConfig().getString("locale", "en-US");
        this.locale = Locale.forLanguageTag(locale);
        String currencyFormatString = ConfigManager.getConfig().getString("currency-format", "#,##0.00");
        try {
            currencyFormat = new DecimalFormat(currencyFormatString, DecimalFormatSymbols.getInstance(this.locale));
        }
        catch (IllegalArgumentException e) {
            SendMessage.warnMessage("Could not load currency format of '" + currencyFormatString + "', with reason: " + e.getMessage());
            currencyFormat = new DecimalFormat("#,##0.00", DecimalFormatSymbols.getInstance(this.locale));
        }
        currencyFormat.setRoundingMode(RoundingMode.FLOOR);
        return currencyFormat;
    }

    private boolean checkForGson() {
        String VersionName = this.getServer().getClass().getPackage().getName().split("\\.")[3];
        return !VersionName.equalsIgnoreCase("v1_8_R1") && !VersionName.equalsIgnoreCase("v1_8_R2");
    }

    private boolean isSpigotServer() {
        try {
            Class.forName("org.spigotmc.SpigotConfig");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void overrideSellCommand(boolean override) {
        boolean modified = false;
        String path = new File("commands.yml").getAbsolutePath();
        YamlConfiguration config = this.loadConfiguration(new File(path), path);
        if (override) {
            if (!config.contains("aliases.sell")) {
                config.set("aliases.sell", Collections.singletonList("economyshopgui:sellall $1-"));
                modified = true;
            } else if (!config.getStringList("aliases.sell").contains("economyshopgui:sellall $1-")) {
                List aliases = config.getStringList("aliases.sell");
                aliases.add("economyshopgui:sellall $1-");
                config.set("aliases.sell", (Object)aliases);
                modified = true;
            }
        } else if (config.getStringList("aliases.sell").contains("economyshopgui:sellall $1-")) {
            if (config.getStringList("aliases.sell").size() == 1) {
                config.set("aliases.sell", null);
                modified = true;
            } else {
                List aliases = config.getStringList("aliases.sell");
                aliases.remove("economyshopgui:sellall $1-");
                config.set("aliases.sell", (Object)aliases);
                modified = true;
            }
        }
        if (!modified) {
            return;
        }
        try {
            config.save(path);
        }
        catch (IOException e) {
            SendMessage.errorMessage("Failed to save " + path);
        }
    }

    private Integer getVersion() {
        String version = Bukkit.getBukkitVersion().split("-")[0];
        if (StringUtils.countMatches((String)version, (String)".") == 2) {
            return Integer.valueOf(version.substring(0, version.length() - 2).replace(".", ""));
        }
        return Integer.valueOf(version.replace(".", ""));
    }

    public String getInvTitle(String title) {
        if (this.version == 18) {
            return title.length() > 32 ? title.substring(0, 32) : title;
        }
        return this.version == 113 ? this.getTitle(title) : title;
    }

    private String getTitle(String title) {
        return this.versionHandler.getTitle(Bukkit.createInventory(null, (int)9, (String)title));
    }

    public boolean isSimilar(ItemStack itemOne, ItemStack itemTwo) {
        if (itemOne == itemTwo) {
            return true;
        }
        return this.versionHandler.isSimilar(new ItemStack(itemOne), new ItemStack(itemTwo), this.ignoredNBTData);
    }

    public boolean isSimilar(ItemStack itemOne, ItemStack itemTwo, List<String> ignoredNBTData) {
        if (itemOne == itemTwo) {
            return true;
        }
        ignoredNBTData.addAll(this.ignoredNBTData);
        return this.versionHandler.isSimilar(new ItemStack(itemOne), new ItemStack(itemTwo), ignoredNBTData);
    }

    public String getMaterialName(String mat) {
        String[] arr = mat.toLowerCase().replace("_", " ").split(" ");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            sb.append(Character.toUpperCase(arr[i].charAt(0))).append(arr[i].substring(1)).append(" ");
        }
        return sb.toString().trim();
    }

    public List<String> getExamplePrices() {
        return new ArrayList<String>(Arrays.asList("-1", "24.99", "100"));
    }

    private List<String> setSupportedMatNames() {
        ArrayList<String> supportedMatNames = new ArrayList<String>();
        for (XMaterial mat : XMaterial.values()) {
            if (!mat.isSupported()) continue;
            supportedMatNames.add(mat.name());
        }
        return supportedMatNames;
    }
}

