/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.api.objects;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import me.gypopo.economyshopgui.objects.ShopItem;
import me.gypopo.economyshopgui.util.EcoType;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class BuyPrice {
    private final OfflinePlayer player;
    private final int amount;
    private final ShopItem shopItem;
    private final Map<EcoType, Double> prices;

    public BuyPrice(OfflinePlayer player, int amount, ShopItem shopItem, Map<EcoType, Double> prices) {
        this.player = player;
        this.amount = amount;
        this.shopItem = shopItem;
        this.prices = prices;
    }

    public BuyPrice(OfflinePlayer player, int amount, ShopItem shopItem, EcoType ecoType, double price) {
        this.player = player;
        this.amount = amount;
        this.shopItem = shopItem;
        this.prices = new HashMap<EcoType, Double>(Collections.singletonMap(ecoType, price));
    }

    public OfflinePlayer getPlayer() {
        return this.player;
    }

    public int getAmount() {
        return this.amount;
    }

    public ShopItem getShopItem() {
        return this.shopItem;
    }

    public Map<EcoType, Double> getPrices() {
        return this.prices;
    }

    public double getPrice(@NotNull EcoType ecoType) {
        return this.prices.getOrDefault(ecoType, -1.0);
    }

    public BuyPrice updateLimits() {
        return this;
    }
}

