/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.api.events.PostTransactionEvent;
import me.gypopo.economyshopgui.api.events.PreTransactionEvent;
import me.gypopo.economyshopgui.files.ConfigManager;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.objects.ShopItem;
import me.gypopo.economyshopgui.util.EcoType;
import me.gypopo.economyshopgui.util.PermissionsCache;
import me.gypopo.economyshopgui.util.SmartStack;
import me.gypopo.economyshopgui.util.Transaction;
import me.gypopo.economyshopgui.util.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.StringUtil;

public class Sellall
extends BukkitCommand {
    private final EconomyShopGUI plugin;
    private final boolean oldSellallCommand;
    private final List<String> disabledWorlds;

    public Sellall(EconomyShopGUI plugin, List<String> aliases, List<String> disabledWorlds) {
        super(aliases.get(0));
        this.description = "Sell all items from your inventory, hand items or specific items";
        this.usageMessage = "/" + aliases.remove(0) + " <inventory/item/hand> [qty]";
        this.setAliases(aliases);
        this.plugin = plugin;
        this.oldSellallCommand = plugin.badYMLParse == null && ConfigManager.getConfig().getBoolean("old-sellall-command");
        this.disabledWorlds = disabledWorlds;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(CommandSender sender, String label, String[] args) {
        if (this.plugin.badYMLParse != null) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&4This command cannot be executed now, please fix the configuration formatting first!"));
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(Lang.REAL_PLAYER.get());
            return true;
        }
        Player player = (Player)sender;
        if (!this.hasAccesInWorld(player)) return true;
        if (!this.isAllowedGamemode(player)) {
            return true;
        }
        if (args.length == 0) {
            if (this.oldSellallCommand) {
                if (PermissionsCache.hasPermission(player, "EconomyShopGUI.sellall")) {
                    this.sellInventory(player);
                    return true;
                }
                SendMessage.chatToPlayer(player, Lang.NO_PERMISSIONS.get());
                return true;
            }
            String usages = this.getCommandUsages(player);
            if (!usages.isEmpty()) {
                SendMessage.chatToPlayer(player, Lang.SELLALL_COMMAND_USAGES.get());
                SendMessage.chatToPlayer(player, usages);
                return true;
            }
            SendMessage.chatToPlayer(player, Lang.NO_PERMISSIONS.get());
            return true;
        }
        switch (args[0].toUpperCase(Locale.ENGLISH)) {
            case "INVENTORY": {
                if (PermissionsCache.hasPermission(player, "EconomyShopGUI.sellall")) {
                    this.sellInventory(player);
                    return true;
                }
                SendMessage.chatToPlayer(player, Lang.NO_PERMISSIONS.get());
                return true;
            }
            case "HAND": {
                if (!PermissionsCache.hasPermission(player, "EconomyShopGUI.sellallhand")) {
                    SendMessage.chatToPlayer(player, Lang.NO_PERMISSIONS.get());
                    return true;
                }
                int qty = 0;
                if (args.length >= 2) {
                    try {
                        qty = Integer.parseInt(args[1]);
                        if (qty <= 0) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException e) {
                        SendMessage.chatToPlayer(player, Lang.NO_VALID_AMOUNT.get());
                        return true;
                    }
                }
                this.sellHand(player, qty);
                return true;
            }
        }
        if (PermissionsCache.hasPermission(player, "EconomyShopGUI.sellallitem")) {
            int quantity;
            XMaterial mat;
            block28: {
                mat = this.getItem(args[0].toUpperCase(Locale.ENGLISH), player);
                if (mat == null) {
                    return true;
                }
                if (mat == XMaterial.AIR) {
                    SendMessage.chatToPlayer(player, Lang.CANNOT_SELL_AIR.get());
                    return true;
                }
                if (args.length >= 2) {
                    try {
                        quantity = Integer.parseInt(args[1]);
                        if (quantity <= 0) {
                            throw new NumberFormatException();
                        }
                        break block28;
                    }
                    catch (NumberFormatException e) {
                        SendMessage.chatToPlayer(player, Lang.NO_VALID_AMOUNT.get());
                        return true;
                    }
                }
                quantity = Integer.MAX_VALUE;
            }
            this.removeItems(player, mat, quantity);
            return true;
        }
        SendMessage.chatToPlayer(player, Lang.NO_PERMISSIONS.get());
        return true;
    }

    private void sellInventory(Player player) {
        Transaction.Result result = Transaction.Result.SUCCESS;
        HashMap<Integer, SmartStack> toRemove = new HashMap<Integer, SmartStack>();
        HashMap<ShopItem, Integer> items = new HashMap<ShopItem, Integer>();
        Map<EcoType, Double> prices = new HashMap<EcoType, Double>();
        int amount = 0;
        for (int i = 0; i <= 36; ++i) {
            Integer sold;
            ItemStack itemInInv = player.getInventory().getItem(i);
            if (itemInInv == null || itemInInv.getType() == Material.AIR) continue;
            ShopItem shopItem = this.plugin.createItem.matchShopItem(itemInInv, player, "sellall");
            if (shopItem != null && shopItem.getSellPrice() >= 0.0) {
                int qty = itemInInv.getAmount();
                if (shopItem.isMaxSell(items.getOrDefault(shopItem, 0) + qty)) {
                    if (items.getOrDefault(shopItem, 0) >= shopItem.getMaxSell()) continue;
                    qty = shopItem.getMaxSell() - items.getOrDefault(shopItem, 0);
                }
                prices.put(shopItem.getEcoType(), prices.getOrDefault(shopItem.getEcoType(), 0.0) + shopItem.getSellPrice(player, itemInInv, qty));
                items.put(shopItem, items.getOrDefault(shopItem, 0) + qty);
                amount += qty;
                ItemStack itemStack = new ItemStack(itemInInv);
                itemStack.setAmount(itemStack.getAmount() - qty);
                toRemove.put(i, new SmartStack(itemStack));
                continue;
            }
            if (!this.plugin.sellShulkers || !XMaterial.isShulker(itemInInv.getType()) || (sold = this.sellShulker(items, prices, toRemove, player, itemInInv, "sellall", i)) == null) continue;
            amount += sold.intValue();
        }
        if (amount > 0) {
            if ((prices = this.callPreTransactionEvent(items, prices, player, amount)) != null) {
                this.removeItems((Inventory)player.getInventory(), toRemove);
                prices.forEach((type, price) -> this.plugin.getEcoHandler().getEcon((EcoType)type).depositBalance((OfflinePlayer)player, (double)price));
                SendMessage.sendTransactionMessage(player, amount, prices, items, Transaction.Type.SELL_ALL_COMMAND);
            } else {
                result = Transaction.Result.TRANSACTION_CANCELLED;
            }
        } else {
            result = Transaction.Result.NO_ITEMS_FOUND;
            SendMessage.chatToPlayer(player, Lang.NO_ITEM_FOUND.get());
        }
        Bukkit.getPluginManager().callEvent((Event)new PostTransactionEvent(items, prices, player, amount, Transaction.Type.SELL_ALL_COMMAND, result));
    }

    private void sellHand(Player player, int quantity) {
        Transaction.Result result = Transaction.Result.SUCCESS;
        ItemStack itemInHand = this.plugin.versionHandler.getItemInHand(player);
        ShopItem shopItem = null;
        double sellPrice = 0.0;
        if (itemInHand != null && itemInHand.getType() != Material.AIR) {
            shopItem = this.plugin.createItem.matchShopItem(itemInHand, player, "sellallhand");
            if (shopItem != null && shopItem.getSellPrice() >= 0.0) {
                if (quantity == 0 || quantity >= itemInHand.getAmount()) {
                    quantity = itemInHand.getAmount();
                }
                if (shopItem.isMaxSell(quantity)) {
                    quantity = shopItem.getMaxSell();
                }
                if ((sellPrice = this.callPreTransactionEvent(shopItem, player, quantity, shopItem.getSellPrice(player, itemInHand, quantity))) >= 0.0) {
                    if (quantity >= itemInHand.getAmount()) {
                        quantity = itemInHand.getAmount();
                        if (this.plugin.version <= 110) {
                            player.getInventory().removeItem(new ItemStack[]{itemInHand});
                        } else {
                            itemInHand.setAmount(0);
                        }
                    } else {
                        itemInHand.setAmount(itemInHand.getAmount() - quantity);
                    }
                    this.plugin.getEcoHandler().getEcon(shopItem.getEcoType()).depositBalance((OfflinePlayer)player, sellPrice);
                    SendMessage.sendTransactionMessage(player, quantity, sellPrice, shopItem, Transaction.Mode.SELL, Transaction.Type.SELL_ALL_COMMAND);
                } else {
                    result = Transaction.Result.TRANSACTION_CANCELLED;
                }
            } else if (this.plugin.sellShulkers && XMaterial.isShulker(itemInHand.getType())) {
                HashMap<ShopItem, Integer> items = new HashMap<ShopItem, Integer>();
                Map<EcoType, Double> prices = new HashMap<EcoType, Double>();
                HashMap<Integer, SmartStack> toRemove = new HashMap<Integer, SmartStack>();
                Integer sold = this.sellShulker(items, prices, toRemove, player, itemInHand, "sellallhand", player.getInventory().getHeldItemSlot());
                if (sold != null) {
                    if ((prices = this.callPreTransactionEvent(items, prices, player, sold)) != null) {
                        this.removeItems((Inventory)player.getInventory(), toRemove);
                        prices.forEach((type, price) -> this.plugin.getEcoHandler().getEcon((EcoType)type).depositBalance((OfflinePlayer)player, (double)price));
                        SendMessage.sendTransactionMessage(player, sold, prices, items, Transaction.Type.SELL_ALL_COMMAND);
                    } else {
                        result = Transaction.Result.TRANSACTION_CANCELLED;
                    }
                } else {
                    result = Transaction.Result.NO_ITEMS_FOUND;
                    SendMessage.chatToPlayer(player, Lang.NO_ITEM_FOUND.get());
                }
            } else {
                result = Transaction.Result.NO_ITEMS_FOUND;
                SendMessage.chatToPlayer(player, Lang.NO_ITEM_FOUND.get());
            }
        } else {
            result = Transaction.Result.NO_ITEMS_FOUND;
            SendMessage.chatToPlayer(player, Lang.CANNOT_SELL_AIR.get());
        }
        Bukkit.getPluginManager().callEvent((Event)new PostTransactionEvent(shopItem, player, quantity, sellPrice, Transaction.Type.SELL_ALL_COMMAND, result));
    }

    private XMaterial getItem(String material, Player player) {
        XMaterial mat;
        if (material != null && !material.isEmpty()) {
            Optional<XMaterial> optionalMat = XMaterial.matchXMaterial(material);
            if (!optionalMat.isPresent()) {
                SendMessage.chatToPlayer(player, ChatColor.RED + Lang.INVALID_ITEM_TYPE.get().replace("%material%", material).replace("%type%", material));
                return null;
            }
            mat = optionalMat.get();
            if (!mat.isSupported()) {
                SendMessage.chatToPlayer(player, ChatColor.RED + Lang.MATERIAL_NOT_SUPPORTED.get() + " (" + material + ")");
                return null;
            }
        } else {
            SendMessage.chatToPlayer(player, ChatColor.RED + Lang.NEED_ITEM_MATERIAL.get() + " (" + material + ")");
            return null;
        }
        return mat;
    }

    private void removeItems(Player p, XMaterial mat, int amount) {
        Transaction.Result result = Transaction.Result.SUCCESS;
        HashMap<Integer, SmartStack> toRemove = new HashMap<Integer, SmartStack>();
        HashMap<ShopItem, Integer> items = new HashMap<ShopItem, Integer>();
        Map<EcoType, Double> prices = new HashMap<EcoType, Double>();
        int removed = 0;
        for (int i = 0; i < 36; ++i) {
            Integer sold;
            ItemStack is = p.getInventory().getItem(i);
            if (is == null || is.getType().equals((Object)Material.AIR) || !XMaterial.matchXMaterial(is).equals((Object)mat)) continue;
            ShopItem shopItem = this.plugin.createItem.matchShopItem(is, p, "sellallitem");
            if (shopItem != null && shopItem.getSellPrice() >= 0.0) {
                int qty = is.getAmount();
                if (shopItem.isMaxSell(items.getOrDefault(shopItem, 0) + qty)) {
                    if (items.getOrDefault(shopItem, 0) >= shopItem.getMaxSell()) continue;
                    qty = shopItem.getMaxSell() - items.getOrDefault(shopItem, 0);
                }
                if (qty > amount) {
                    qty = amount;
                }
                prices.put(shopItem.getEcoType(), prices.getOrDefault(shopItem.getEcoType(), 0.0) + shopItem.getSellPrice(p, is, qty));
                items.put(shopItem, items.getOrDefault(shopItem, 0) + qty);
                removed += qty;
                ItemStack itemStack = new ItemStack(is);
                itemStack.setAmount(is.getAmount() - qty);
                toRemove.put(i, new SmartStack(itemStack));
                if ((amount -= qty) > 0) continue;
                break;
            }
            if (!this.plugin.sellShulkers || !XMaterial.isShulker(is.getType()) || (sold = this.sellShulker(items, prices, toRemove, p, is, "sellallitem", i)) == null) continue;
            removed += sold.intValue();
        }
        if (removed > 0) {
            if ((prices = this.callPreTransactionEvent(items, prices, p, removed)) != null) {
                this.removeItems((Inventory)p.getInventory(), toRemove);
                prices.forEach((type, price) -> this.plugin.getEcoHandler().getEcon((EcoType)type).depositBalance((OfflinePlayer)p, (double)price));
                if (items.size() == 1) {
                    SendMessage.sendTransactionMessage(p, removed, prices.values().stream().mapToDouble(d -> d).sum(), (ShopItem)items.keySet().stream().findFirst().get(), Transaction.Mode.SELL, Transaction.Type.SELL_ALL_COMMAND);
                } else {
                    SendMessage.sendTransactionMessage(p, removed, prices, items, Transaction.Type.SELL_ALL_COMMAND);
                }
            } else {
                result = Transaction.Result.TRANSACTION_CANCELLED;
            }
        } else {
            result = Transaction.Result.NO_ITEMS_FOUND;
            SendMessage.chatToPlayer(p, Lang.NO_ITEM_FOUND.get());
        }
        Bukkit.getPluginManager().callEvent((Event)new PostTransactionEvent(items, prices, p, removed, Transaction.Type.SELL_ALL_COMMAND, result));
    }

    private Integer sellShulker(Map<ShopItem, Integer> history, Map<EcoType, Double> prices, Map<Integer, SmartStack> toRemove, Player p, ItemStack box, String perm, int slot) {
        BlockStateMeta bm;
        HashMap<ShopItem, Integer> bItems = new HashMap<ShopItem, Integer>();
        HashMap<EcoType, Double> bPrices = new HashMap<EcoType, Double>();
        HashMap<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
        int removed = 0;
        if (box.getItemMeta() instanceof BlockStateMeta && (bm = (BlockStateMeta)box.getItemMeta()).getBlockState() instanceof ShulkerBox) {
            Inventory inv = ((ShulkerBox)bm.getBlockState()).getInventory();
            if (inv.isEmpty()) {
                return null;
            }
            for (int i = 0; i < 27; ++i) {
                ShopItem shopItem;
                ItemStack is = inv.getItem(i);
                if (is == null || is.getType().equals((Object)Material.AIR) || (shopItem = this.plugin.createItem.matchShopItem(is, p, perm)) == null || !(shopItem.getSellPrice() >= 0.0)) continue;
                int qty = is.getAmount();
                if (shopItem.isMaxSell(bItems.getOrDefault(shopItem, 0) + history.getOrDefault(shopItem, 0) + qty)) {
                    if (history.getOrDefault(shopItem, 0) >= shopItem.getMaxSell()) continue;
                    qty = shopItem.getMaxSell() - history.getOrDefault(shopItem, 0);
                }
                bItems.put(shopItem, bItems.getOrDefault(shopItem, 0) + qty);
                bPrices.put(shopItem.getEcoType(), bPrices.getOrDefault(shopItem.getEcoType(), 0.0) + shopItem.getSellPrice(p, is, qty));
                removed += qty;
                ItemStack stack = new ItemStack(is);
                stack.setAmount(is.getAmount() - qty);
                items.put(i, stack);
            }
            if (!bItems.isEmpty()) {
                bPrices.forEach((k, v) -> prices.put((EcoType)k, prices.getOrDefault(k, 0.0) + v));
                ItemStack sBox = new ItemStack(box);
                this.emptyShulker(new SmartStack.Shulker(sBox, items));
                ShopItem shopItem = this.plugin.createItem.matchShopItem(sBox);
                if (shopItem != null) {
                    prices.put(shopItem.getEcoType(), prices.getOrDefault(shopItem.getEcoType(), 0.0) + shopItem.getSellPrice(p));
                    ++removed;
                    toRemove.put(slot, new SmartStack(box));
                    history.put(new ShopItem.Shulker(shopItem, sBox, bItems), history.getOrDefault(shopItem, 0) + 1);
                } else {
                    toRemove.put(slot, new SmartStack.Shulker(box, items));
                    bItems.forEach((k, v) -> history.put((ShopItem)k, history.getOrDefault(k, 0) + v));
                }
                return removed;
            }
        }
        return null;
    }

    private void removeItems(Inventory inv, Map<Integer, SmartStack> items) {
        items.forEach((i, stack) -> {
            if (stack instanceof SmartStack.Shulker) {
                this.emptyShulker((SmartStack.Shulker)stack);
            } else if (stack.getItem().getAmount() != 0) {
                inv.setItem(i.intValue(), stack.getItem());
            } else {
                inv.clear(i.intValue());
            }
        });
    }

    private void emptyShulker(SmartStack.Shulker shulker) {
        ItemStack sBox = shulker.getItem();
        BlockStateMeta sbm = (BlockStateMeta)sBox.getItemMeta();
        ShulkerBox s = (ShulkerBox)sbm.getBlockState();
        shulker.getItems().forEach((i, item) -> {
            if (item.getAmount() != 0) {
                s.getInventory().setItem(i.intValue(), item);
            } else {
                s.getInventory().clear(i.intValue());
            }
        });
        sbm.setBlockState((BlockState)s);
        sBox.setItemMeta((ItemMeta)sbm);
    }

    private boolean hasAccesInWorld(Player player) {
        if (!this.disabledWorlds.contains(player.getWorld().getName())) {
            return true;
        }
        SendMessage.chatToPlayer(player, Lang.COMMAND_DISABLED_IN_WORLD.get());
        return false;
    }

    private double callPreTransactionEvent(ShopItem shopItem, Player player, int quantity, double sellPrice) {
        PreTransactionEvent preTransactionEvent = new PreTransactionEvent(shopItem, player, quantity, sellPrice, Transaction.Type.SELL_ALL_COMMAND);
        Bukkit.getPluginManager().callEvent((Event)preTransactionEvent);
        sellPrice = preTransactionEvent.getPrice();
        return preTransactionEvent.isCancelled() ? -1.0 : sellPrice;
    }

    private Map<EcoType, Double> callPreTransactionEvent(Map<ShopItem, Integer> items, Map<EcoType, Double> prices, Player player, int amount) {
        PreTransactionEvent preTransactionEvent = new PreTransactionEvent(items, prices, player, amount, Transaction.Type.SELL_ALL_COMMAND);
        Bukkit.getPluginManager().callEvent((Event)preTransactionEvent);
        return preTransactionEvent.isCancelled() ? null : preTransactionEvent.getPrices();
    }

    private boolean isAllowedGamemode(Player player) {
        if (this.plugin.bannedGamemodes.contains(player.getGameMode()) && !PermissionsCache.hasPermission(player, "EconomyShopGUI.bypassgamemode")) {
            SendMessage.chatToPlayer(player, Lang.CANNOT_USE_COMMAND_BANNED_GAMEMODE.get().replace("%gamemode%", player.getGameMode().name().toLowerCase()));
            return false;
        }
        return true;
    }

    private String getCommandUsages(Player p) {
        StringBuilder builder = new StringBuilder();
        if (PermissionsCache.hasPermission(p, "EconomyShopGUI.sellall")) {
            builder.append(Lang.SELLALL_INVENTORY_COMMAND_USAGE.get()).append("\n");
        }
        if (PermissionsCache.hasPermission(p, "EconomyShopGUI.sellallhand")) {
            builder.append(Lang.SELLALL_HAND_COMMAND_USAGE.get()).append("\n");
        }
        if (PermissionsCache.hasPermission(p, "EconomyShopGUI.sellallitem")) {
            builder.append(Lang.SELLALL_ITEM_COMMAND_USAGE.get()).append("\n");
        }
        return builder.toString();
    }

    public List<String> tabComplete(CommandSender commandSender, String s, String[] args) {
        if (!(PermissionsCache.hasPermission(commandSender, "EconomyShopGUI.sellall") && PermissionsCache.hasPermission(commandSender, "EconomyShopGUI.sellallhand") && PermissionsCache.hasPermission(commandSender, "EconomyShopGUI.sellallitem"))) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            List<String> tabCompletions = this.plugin.getSupportedMatNames();
            tabCompletions.add("hand");
            tabCompletions.add("inventory");
            if (!args[0].isEmpty()) {
                ArrayList<String> completions = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args[0], tabCompletions, completions);
                Collections.sort(completions);
                return completions;
            }
            return tabCompletions;
        }
        if (args.length == 2) {
            if (!args[1].isEmpty()) {
                ArrayList<String> completions = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args[1], Arrays.asList("8", "16", "32", "64", "128", "256", "512", "1024"), completions);
                Collections.sort(completions);
                return completions;
            }
            return Arrays.asList("8", "16", "32", "64", "128", "256", "512", "1024");
        }
        return Collections.emptyList();
    }
}

