/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.files.ConfigManager;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.objects.MainMenu;
import me.gypopo.economyshopgui.objects.ShopSection;
import me.gypopo.economyshopgui.util.PermissionsCache;
import org.bukkit.ChatColor;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class Shop
extends BukkitCommand {
    private final EconomyShopGUI plugin;
    private final List<String> disabledWorlds;
    private final boolean disableBackButtonWithShopSectionCommand;

    public Shop(EconomyShopGUI plugin, List<String> aliases, List<String> disabledWorlds) {
        super(aliases.get(0));
        this.description = "Opens the server shop";
        this.usageMessage = "/" + aliases.remove(0) + " <section/search>";
        this.setAliases(aliases);
        this.setPermission("EconomyShopGUI.shop");
        this.plugin = plugin;
        this.disabledWorlds = disabledWorlds;
        this.disableBackButtonWithShopSectionCommand = plugin.badYMLParse == null && ConfigManager.getConfig().getBoolean("disableBackButtonWithShopSectionCommand");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execute(CommandSender sender, String label, String[] args) {
        if (this.plugin.badYMLParse != null) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&4This command cannot be executed now, please fix the configuration formatting first!"));
            return true;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!this.hasAccesInWorld(player)) return true;
            if (args.length == 0) {
                if (PermissionsCache.hasPermission(player, "EconomyShopGUI.shop")) {
                    new MainMenu(player);
                    return true;
                } else {
                    SendMessage.chatToPlayer(player, Lang.NO_PERMISSIONS.get());
                }
                return true;
            } else {
                if (args.length != 1) return false;
                if (this.plugin.getShopSections().contains(args[0])) {
                    if (this.plugin.getSection(args[0]).isSubSection()) {
                        SendMessage.chatToPlayer(player, Lang.NO_SHOP_FOUND.get());
                        return true;
                    }
                    if (PermissionsCache.hasPermission(player, "EconomyShopGUI.shop." + args[0])) {
                        this.plugin.getSection(args[0]).openShopSection(player, this.disableBackButtonWithShopSectionCommand);
                        return true;
                    } else {
                        SendMessage.chatToPlayer(player, Lang.NO_PERMISSIONS_TO_OPEN_SHOP.get());
                    }
                    return true;
                } else {
                    SendMessage.chatToPlayer(player, Lang.NO_SHOP_FOUND.get());
                }
            }
            return true;
        } else {
            if (!(sender instanceof ConsoleCommandSender) && !(sender instanceof BlockCommandSender) && !(sender instanceof RemoteConsoleCommandSender)) return true;
            if (args.length == 1) {
                Player p = this.plugin.getServer().getPlayer(args[0]);
                if (p != null) {
                    new MainMenu(p);
                    return true;
                } else {
                    sender.sendMessage(Lang.PLAYER_NOT_ONLINE.get());
                }
                return true;
            } else {
                if (args.length != 2) return false;
                Player p = this.plugin.getServer().getPlayer(args[1]);
                if (p != null) {
                    if (this.plugin.getShopSections().contains(args[0])) {
                        this.plugin.getSection(args[0]).openShopSection(p, this.disableBackButtonWithShopSectionCommand);
                        return true;
                    } else {
                        sender.sendMessage(Lang.NO_SHOP_FOUND.get());
                    }
                    return true;
                } else {
                    sender.sendMessage(Lang.PLAYER_NOT_ONLINE.get());
                }
            }
        }
        return true;
    }

    private boolean hasAccesInWorld(Player player) {
        if (!this.disabledWorlds.contains(player.getWorld().getName())) {
            return true;
        }
        SendMessage.chatToPlayer(player, Lang.COMMAND_DISABLED_IN_WORLD.get());
        return false;
    }

    public List<String> tabComplete(CommandSender commandSender, String s, String[] args) {
        if (!PermissionsCache.hasPermission(commandSender, "EconomyShopGUI.shop")) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            List<String> tabCompletions = this.plugin.getSections().values().stream().filter(section -> !section.isSubSection() && PermissionsCache.hasPermission(commandSender, "EconomyShopGUI.shop." + section.getSection())).map(ShopSection::getSection).collect(Collectors.toList());
            if (!args[0].isEmpty()) {
                ArrayList<String> completions = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args[0], tabCompletions, completions);
                Collections.sort(completions);
                return completions;
            }
            return tabCompletions;
        }
        return Collections.emptyList();
    }
}

