/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.util.PermissionsCache;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.StringUtil;

public class ShopGive
extends BukkitCommand {
    private final EconomyShopGUI plugin;
    private final List<String> disabledWorlds;

    public ShopGive(EconomyShopGUI plugin, List<String> disabledWorlds) {
        super("shopgive");
        this.description = "Give a shop item to a player";
        this.usageMessage = "/shopgive <section> <itemIndex> [player] [amount]";
        this.setPermission("EconomyShopGUI.shopgive");
        this.plugin = plugin;
        this.disabledWorlds = disabledWorlds;
    }

    public boolean execute(CommandSender sender, String label, String[] args) {
        if (this.plugin.badYMLParse != null) {
            SendMessage.sendMessage(sender, ChatColor.DARK_RED + "This command cannot be executed now, please fix the configuration formatting first!");
            return true;
        }
        if (!this.hasAccesInWorld(sender)) {
            return true;
        }
        if (args.length > 0) {
            if (this.plugin.getShopSections().stream().noneMatch(s -> s.equals(args[0]))) {
                SendMessage.sendMessage(sender, Lang.NO_SHOP_FOUND.get());
                return true;
            }
        } else {
            SendMessage.sendMessage(sender, ChatColor.GREEN + "/shopgive <section> <itemIndex> [player] [amount]");
            return true;
        }
        if (args.length > 1) {
            if (this.plugin.getSection((String)args[0]).itemLocs.stream().noneMatch(s -> s.equals(args[1]))) {
                SendMessage.sendMessage(sender, Lang.SECTION_DOES_NOT_CONTAIN_ITEM.get().replace("%shopsection%", args[0]).replace("%itemLoc%", args[1]));
                return true;
            }
        } else {
            SendMessage.sendMessage(sender, ChatColor.GREEN + "/shopgive <section> <itemIndex> [player] [amount]");
            return true;
        }
        if (args.length > 2 && !this.isInt(args[2])) {
            Player p = this.plugin.getServer().getPlayer(args[2]);
            if (p != null) {
                ItemStack item = this.plugin.getSection(args[0]).getShopItem(args[0] + "." + args[1]).getItemToGive();
                if (args.length > 3) {
                    this.setAmount(item, args[3]);
                }
                SendMessage.sendMessage(sender, Lang.SHOP_ITEM_GIVEN.get().replace("%amount%", String.valueOf(item.getAmount())).replace("%section%", args[0]).replace("%itemIndex%", args[1]).replace("%material%", this.plugin.getMaterialName(item.getType().toString())));
                this.giveItem(p, item);
            } else {
                SendMessage.warnMessage(Lang.PLAYER_NOT_ONLINE.get(), sender);
            }
        } else if (sender instanceof Player) {
            ItemStack item = this.plugin.getSection(args[0]).getShopItem(args[0] + "." + args[1]).getItemToGive();
            if (args.length > 2) {
                this.setAmount(item, args[2]);
            }
            SendMessage.sendMessage(sender, Lang.SHOP_ITEM_RECEIVED.get().replace("%amount%", String.valueOf(item.getAmount())).replace("%section%", args[0]).replace("%itemIndex%", args[1]).replace("%material%", this.plugin.getMaterialName(item.getType().toString())));
            this.giveItem((Player)sender, item);
        } else {
            SendMessage.sendMessage(sender, ChatColor.GREEN + "/shopgive <section> <itemIndex> [player] [amount]");
        }
        return true;
    }

    private void giveItem(Player p, ItemStack item) {
        ArrayList items = new ArrayList(p.getInventory().addItem(new ItemStack[]{item}).values());
        for (int i = 0; i < items.size() && i != 2; ++i) {
            p.getWorld().dropItem(p.getLocation(), (ItemStack)items.get(i));
        }
    }

    private ItemStack[] getStacks(ItemStack item) {
        int amount = item.getAmount();
        int maxStackSize = item.getMaxStackSize();
        double div = (double)amount / (double)maxStackSize;
        int fullStacks = (int)Math.floor(div);
        int stacks = div == Math.floor(div) ? fullStacks : (int)Math.ceil(div);
        int amountLeft = amount;
        ItemStack[] items = new ItemStack[stacks];
        if (fullStacks >= 1) {
            for (int i = 0; i < fullStacks; ++i) {
                ItemStack is = new ItemStack(item);
                is.setAmount(maxStackSize);
                items[i] = is;
                amountLeft -= maxStackSize;
            }
        }
        if (amountLeft >= 1) {
            ItemStack is = new ItemStack(item);
            is.setAmount(amountLeft);
            items[stacks - 1] = is;
        }
        return items;
    }

    private void setAmount(ItemStack item, String s) {
        try {
            item.setAmount(Integer.parseInt(s));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private boolean isLimit(String s, ItemStack item) {
        try {
            return Integer.parseInt(s) > 128;
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
    }

    private boolean isInt(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean hasAccesInWorld(CommandSender sender) {
        if (!(sender instanceof Player)) {
            return true;
        }
        if (!this.disabledWorlds.contains(((Player)sender).getWorld().getName())) {
            return true;
        }
        sender.sendMessage(Lang.COMMAND_DISABLED_IN_WORLD.get());
        return false;
    }

    public List<String> tabComplete(CommandSender commandSender, String s, String[] args) {
        if (!PermissionsCache.hasPermission(commandSender, "EconomyShopGUI.shopgive")) {
            return Collections.emptyList();
        }
        switch (args.length) {
            case 1: {
                if (!args[0].isEmpty()) {
                    ArrayList<String> completions = new ArrayList<String>();
                    StringUtil.copyPartialMatches((String)args[0], this.plugin.getShopSections(), completions);
                    Collections.sort(completions);
                    return completions;
                }
                return this.plugin.getShopSections();
            }
            case 2: {
                if (!this.isSection(args[0])) {
                    return null;
                }
                if (!args[1].isEmpty()) {
                    ArrayList<String> completions = new ArrayList<String>();
                    StringUtil.copyPartialMatches((String)args[1], this.plugin.getSection((String)args[0]).itemLocs, completions);
                    Collections.sort(completions);
                    return completions;
                }
                return this.plugin.getSection((String)args[0]).itemLocs;
            }
            case 3: {
                return this.plugin.getServer().getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
            }
            case 4: {
                return Arrays.asList("1", "16", "32", "64", "128");
            }
        }
        return null;
    }

    private boolean isSection(String section) {
        return this.plugin.getShopSections().contains(section);
    }
}

